/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectProfileObjectTypeResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<DetectProfileObjectTypeResponse.Builder, DetectProfileObjectTypeResponse> {
    private static final SdkField<List<DetectedProfileObjectType>> DETECTED_PROFILE_OBJECT_TYPES_FIELD = SdkField
            .<List<DetectedProfileObjectType>> builder(MarshallingType.LIST)
            .memberName("DetectedProfileObjectTypes")
            .getter(getter(DetectProfileObjectTypeResponse::detectedProfileObjectTypes))
            .setter(setter(Builder::detectedProfileObjectTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedProfileObjectTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectedProfileObjectType> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectedProfileObjectType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DETECTED_PROFILE_OBJECT_TYPES_FIELD));

    private final List<DetectedProfileObjectType> detectedProfileObjectTypes;

    private DetectProfileObjectTypeResponse(BuilderImpl builder) {
        super(builder);
        this.detectedProfileObjectTypes = builder.detectedProfileObjectTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the DetectedProfileObjectTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDetectedProfileObjectTypes() {
        return detectedProfileObjectTypes != null && !(detectedProfileObjectTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detected <code>ProfileObjectType</code> mappings from given objects. A maximum of one mapping is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetectedProfileObjectTypes} method.
     * </p>
     * 
     * @return Detected <code>ProfileObjectType</code> mappings from given objects. A maximum of one mapping is
     *         supported.
     */
    public final List<DetectedProfileObjectType> detectedProfileObjectTypes() {
        return detectedProfileObjectTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDetectedProfileObjectTypes() ? detectedProfileObjectTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProfileObjectTypeResponse)) {
            return false;
        }
        DetectProfileObjectTypeResponse other = (DetectProfileObjectTypeResponse) obj;
        return hasDetectedProfileObjectTypes() == other.hasDetectedProfileObjectTypes()
                && Objects.equals(detectedProfileObjectTypes(), other.detectedProfileObjectTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectProfileObjectTypeResponse")
                .add("DetectedProfileObjectTypes", hasDetectedProfileObjectTypes() ? detectedProfileObjectTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectedProfileObjectTypes":
            return Optional.ofNullable(clazz.cast(detectedProfileObjectTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectProfileObjectTypeResponse, T> g) {
        return obj -> g.apply((DetectProfileObjectTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectProfileObjectTypeResponse> {
        /**
         * <p>
         * Detected <code>ProfileObjectType</code> mappings from given objects. A maximum of one mapping is supported.
         * </p>
         * 
         * @param detectedProfileObjectTypes
         *        Detected <code>ProfileObjectType</code> mappings from given objects. A maximum of one mapping is
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedProfileObjectTypes(Collection<DetectedProfileObjectType> detectedProfileObjectTypes);

        /**
         * <p>
         * Detected <code>ProfileObjectType</code> mappings from given objects. A maximum of one mapping is supported.
         * </p>
         * 
         * @param detectedProfileObjectTypes
         *        Detected <code>ProfileObjectType</code> mappings from given objects. A maximum of one mapping is
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedProfileObjectTypes(DetectedProfileObjectType... detectedProfileObjectTypes);

        /**
         * <p>
         * Detected <code>ProfileObjectType</code> mappings from given objects. A maximum of one mapping is supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.DetectedProfileObjectType.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.DetectedProfileObjectType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.DetectedProfileObjectType.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #detectedProfileObjectTypes(List<DetectedProfileObjectType>)}.
         * 
         * @param detectedProfileObjectTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.DetectedProfileObjectType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectedProfileObjectTypes(java.util.Collection<DetectedProfileObjectType>)
         */
        Builder detectedProfileObjectTypes(Consumer<DetectedProfileObjectType.Builder>... detectedProfileObjectTypes);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private List<DetectedProfileObjectType> detectedProfileObjectTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectProfileObjectTypeResponse model) {
            super(model);
            detectedProfileObjectTypes(model.detectedProfileObjectTypes);
        }

        public final List<DetectedProfileObjectType.Builder> getDetectedProfileObjectTypes() {
            List<DetectedProfileObjectType.Builder> result = DetectedProfileObjectTypesCopier
                    .copyToBuilder(this.detectedProfileObjectTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectedProfileObjectTypes(
                Collection<DetectedProfileObjectType.BuilderImpl> detectedProfileObjectTypes) {
            this.detectedProfileObjectTypes = DetectedProfileObjectTypesCopier.copyFromBuilder(detectedProfileObjectTypes);
        }

        @Override
        public final Builder detectedProfileObjectTypes(Collection<DetectedProfileObjectType> detectedProfileObjectTypes) {
            this.detectedProfileObjectTypes = DetectedProfileObjectTypesCopier.copy(detectedProfileObjectTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectedProfileObjectTypes(DetectedProfileObjectType... detectedProfileObjectTypes) {
            detectedProfileObjectTypes(Arrays.asList(detectedProfileObjectTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectedProfileObjectTypes(Consumer<DetectedProfileObjectType.Builder>... detectedProfileObjectTypes) {
            detectedProfileObjectTypes(Stream.of(detectedProfileObjectTypes)
                    .map(c -> DetectedProfileObjectType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectProfileObjectTypeResponse build() {
            return new DetectProfileObjectTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
