/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSimilarProfilesResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetSimilarProfilesResponse.Builder, GetSimilarProfilesResponse> {
    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProfileIds")
            .getter(getter(GetSimilarProfilesResponse::profileIds))
            .setter(setter(Builder::profileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MATCH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchId").getter(getter(GetSimilarProfilesResponse::matchId)).setter(setter(Builder::matchId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchId").build()).build();

    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchType").getter(getter(GetSimilarProfilesResponse::matchTypeAsString))
            .setter(setter(Builder::matchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()).build();

    private static final SdkField<Integer> RULE_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleLevel").getter(getter(GetSimilarProfilesResponse::ruleLevel)).setter(setter(Builder::ruleLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleLevel").build()).build();

    private static final SdkField<Double> CONFIDENCE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ConfidenceScore").getter(getter(GetSimilarProfilesResponse::confidenceScore))
            .setter(setter(Builder::confidenceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfidenceScore").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSimilarProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_IDS_FIELD,
            MATCH_ID_FIELD, MATCH_TYPE_FIELD, RULE_LEVEL_FIELD, CONFIDENCE_SCORE_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> profileIds;

    private final String matchId;

    private final String matchType;

    private final Integer ruleLevel;

    private final Double confidenceScore;

    private final String nextToken;

    private GetSimilarProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.profileIds = builder.profileIds;
        this.matchId = builder.matchId;
        this.matchType = builder.matchType;
        this.ruleLevel = builder.ruleLevel;
        this.confidenceScore = builder.confidenceScore;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfileIds() {
        return profileIds != null && !(profileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Set of <code>profileId</code>s that belong to the same matching group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileIds} method.
     * </p>
     * 
     * @return Set of <code>profileId</code>s that belong to the same matching group.
     */
    public final List<String> profileIds() {
        return profileIds;
    }

    /**
     * <p>
     * The string <code>matchId</code> that the similar profiles belong to.
     * </p>
     * 
     * @return The string <code>matchId</code> that the similar profiles belong to.
     */
    public final String matchId() {
        return matchId;
    }

    /**
     * <p>
     * Specify the type of matching to get similar profiles for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchTypeAsString}.
     * </p>
     * 
     * @return Specify the type of matching to get similar profiles for.
     * @see MatchType
     */
    public final MatchType matchType() {
        return MatchType.fromValue(matchType);
    }

    /**
     * <p>
     * Specify the type of matching to get similar profiles for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchTypeAsString}.
     * </p>
     * 
     * @return Specify the type of matching to get similar profiles for.
     * @see MatchType
     */
    public final String matchTypeAsString() {
        return matchType;
    }

    /**
     * <p>
     * The integer rule level that the profiles matched on.
     * </p>
     * 
     * @return The integer rule level that the profiles matched on.
     */
    public final Integer ruleLevel() {
        return ruleLevel;
    }

    /**
     * <p>
     * It only has value when the <code>MatchType</code> is <code>ML_BASED_MATCHING</code>.A number between 0 and 1,
     * where a higher score means higher similarity. Examining match confidence scores lets you distinguish between
     * groups of similar records in which the system is highly confident (which you may decide to merge), groups of
     * similar records about which the system is uncertain (which you may decide to have reviewed by a human), and
     * groups of similar records that the system deems to be unlikely (which you may decide to reject). Given confidence
     * scores vary as per the data input, it should not be used as an absolute measure of matching quality.
     * </p>
     * 
     * @return It only has value when the <code>MatchType</code> is <code>ML_BASED_MATCHING</code>.A number between 0
     *         and 1, where a higher score means higher similarity. Examining match confidence scores lets you
     *         distinguish between groups of similar records in which the system is highly confident (which you may
     *         decide to merge), groups of similar records about which the system is uncertain (which you may decide to
     *         have reviewed by a human), and groups of similar records that the system deems to be unlikely (which you
     *         may decide to reject). Given confidence scores vary as per the data input, it should not be used as an
     *         absolute measure of matching quality.
     */
    public final Double confidenceScore() {
        return confidenceScore;
    }

    /**
     * <p>
     * The pagination token from the previous <code>GetSimilarProfiles</code> API call.
     * </p>
     * 
     * @return The pagination token from the previous <code>GetSimilarProfiles</code> API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileIds() ? profileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matchId());
        hashCode = 31 * hashCode + Objects.hashCode(matchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleLevel());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceScore());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSimilarProfilesResponse)) {
            return false;
        }
        GetSimilarProfilesResponse other = (GetSimilarProfilesResponse) obj;
        return hasProfileIds() == other.hasProfileIds() && Objects.equals(profileIds(), other.profileIds())
                && Objects.equals(matchId(), other.matchId()) && Objects.equals(matchTypeAsString(), other.matchTypeAsString())
                && Objects.equals(ruleLevel(), other.ruleLevel()) && Objects.equals(confidenceScore(), other.confidenceScore())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSimilarProfilesResponse").add("ProfileIds", hasProfileIds() ? profileIds() : null)
                .add("MatchId", matchId()).add("MatchType", matchTypeAsString()).add("RuleLevel", ruleLevel())
                .add("ConfidenceScore", confidenceScore()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileIds":
            return Optional.ofNullable(clazz.cast(profileIds()));
        case "MatchId":
            return Optional.ofNullable(clazz.cast(matchId()));
        case "MatchType":
            return Optional.ofNullable(clazz.cast(matchTypeAsString()));
        case "RuleLevel":
            return Optional.ofNullable(clazz.cast(ruleLevel()));
        case "ConfidenceScore":
            return Optional.ofNullable(clazz.cast(confidenceScore()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSimilarProfilesResponse, T> g) {
        return obj -> g.apply((GetSimilarProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSimilarProfilesResponse> {
        /**
         * <p>
         * Set of <code>profileId</code>s that belong to the same matching group.
         * </p>
         * 
         * @param profileIds
         *        Set of <code>profileId</code>s that belong to the same matching group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(Collection<String> profileIds);

        /**
         * <p>
         * Set of <code>profileId</code>s that belong to the same matching group.
         * </p>
         * 
         * @param profileIds
         *        Set of <code>profileId</code>s that belong to the same matching group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(String... profileIds);

        /**
         * <p>
         * The string <code>matchId</code> that the similar profiles belong to.
         * </p>
         * 
         * @param matchId
         *        The string <code>matchId</code> that the similar profiles belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchId(String matchId);

        /**
         * <p>
         * Specify the type of matching to get similar profiles for.
         * </p>
         * 
         * @param matchType
         *        Specify the type of matching to get similar profiles for.
         * @see MatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchType
         */
        Builder matchType(String matchType);

        /**
         * <p>
         * Specify the type of matching to get similar profiles for.
         * </p>
         * 
         * @param matchType
         *        Specify the type of matching to get similar profiles for.
         * @see MatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchType
         */
        Builder matchType(MatchType matchType);

        /**
         * <p>
         * The integer rule level that the profiles matched on.
         * </p>
         * 
         * @param ruleLevel
         *        The integer rule level that the profiles matched on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleLevel(Integer ruleLevel);

        /**
         * <p>
         * It only has value when the <code>MatchType</code> is <code>ML_BASED_MATCHING</code>.A number between 0 and 1,
         * where a higher score means higher similarity. Examining match confidence scores lets you distinguish between
         * groups of similar records in which the system is highly confident (which you may decide to merge), groups of
         * similar records about which the system is uncertain (which you may decide to have reviewed by a human), and
         * groups of similar records that the system deems to be unlikely (which you may decide to reject). Given
         * confidence scores vary as per the data input, it should not be used as an absolute measure of matching
         * quality.
         * </p>
         * 
         * @param confidenceScore
         *        It only has value when the <code>MatchType</code> is <code>ML_BASED_MATCHING</code>.A number between 0
         *        and 1, where a higher score means higher similarity. Examining match confidence scores lets you
         *        distinguish between groups of similar records in which the system is highly confident (which you may
         *        decide to merge), groups of similar records about which the system is uncertain (which you may decide
         *        to have reviewed by a human), and groups of similar records that the system deems to be unlikely
         *        (which you may decide to reject). Given confidence scores vary as per the data input, it should not be
         *        used as an absolute measure of matching quality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceScore(Double confidenceScore);

        /**
         * <p>
         * The pagination token from the previous <code>GetSimilarProfiles</code> API call.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from the previous <code>GetSimilarProfiles</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();

        private String matchId;

        private String matchType;

        private Integer ruleLevel;

        private Double confidenceScore;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSimilarProfilesResponse model) {
            super(model);
            profileIds(model.profileIds);
            matchId(model.matchId);
            matchType(model.matchType);
            ruleLevel(model.ruleLevel);
            confidenceScore(model.confidenceScore);
            nextToken(model.nextToken);
        }

        public final Collection<String> getProfileIds() {
            if (profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return profileIds;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
        }

        @Override
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIds(String... profileIds) {
            profileIds(Arrays.asList(profileIds));
            return this;
        }

        public final String getMatchId() {
            return matchId;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        @Override
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public final String getMatchType() {
            return matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public final Integer getRuleLevel() {
            return ruleLevel;
        }

        public final void setRuleLevel(Integer ruleLevel) {
            this.ruleLevel = ruleLevel;
        }

        @Override
        public final Builder ruleLevel(Integer ruleLevel) {
            this.ruleLevel = ruleLevel;
            return this;
        }

        public final Double getConfidenceScore() {
            return confidenceScore;
        }

        public final void setConfidenceScore(Double confidenceScore) {
            this.confidenceScore = confidenceScore;
        }

        @Override
        public final Builder confidenceScore(Double confidenceScore) {
            this.confidenceScore = confidenceScore;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSimilarProfilesResponse build() {
            return new GetSimilarProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
