/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.MatchItem;
import software.amazon.awssdk.services.customerprofiles.model.MatchesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMatchesResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetMatchesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMatchesResponse.getter(GetMatchesResponse::nextToken)).setter(GetMatchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Instant> MATCH_GENERATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MatchGenerationDate").getter(GetMatchesResponse.getter(GetMatchesResponse::matchGenerationDate)).setter(GetMatchesResponse.setter(Builder::matchGenerationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchGenerationDate").build()}).build();
    private static final SdkField<Integer> POTENTIAL_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PotentialMatches").getter(GetMatchesResponse.getter(GetMatchesResponse::potentialMatches)).setter(GetMatchesResponse.setter(Builder::potentialMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PotentialMatches").build()}).build();
    private static final SdkField<List<MatchItem>> MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Matches").getter(GetMatchesResponse.getter(GetMatchesResponse::matches)).setter(GetMatchesResponse.setter(Builder::matches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MATCH_GENERATION_DATE_FIELD, POTENTIAL_MATCHES_FIELD, MATCHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MatchGenerationDate", MATCH_GENERATION_DATE_FIELD);
            this.put("PotentialMatches", POTENTIAL_MATCHES_FIELD);
            this.put("Matches", MATCHES_FIELD);
        }
    });
    private final String nextToken;
    private final Instant matchGenerationDate;
    private final Integer potentialMatches;
    private final List<MatchItem> matches;

    private GetMatchesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.matchGenerationDate = builder.matchGenerationDate;
        this.potentialMatches = builder.potentialMatches;
        this.matches = builder.matches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant matchGenerationDate() {
        return this.matchGenerationDate;
    }

    public final Integer potentialMatches() {
        return this.potentialMatches;
    }

    public final boolean hasMatches() {
        return this.matches != null && !(this.matches instanceof SdkAutoConstructList);
    }

    public final List<MatchItem> matches() {
        return this.matches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchGenerationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.potentialMatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatches() ? this.matches() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchesResponse)) {
            return false;
        }
        GetMatchesResponse other = (GetMatchesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.matchGenerationDate(), other.matchGenerationDate()) && Objects.equals(this.potentialMatches(), other.potentialMatches()) && this.hasMatches() == other.hasMatches() && Objects.equals(this.matches(), other.matches());
    }

    public final String toString() {
        return ToString.builder((String)"GetMatchesResponse").add("NextToken", (Object)this.nextToken()).add("MatchGenerationDate", (Object)this.matchGenerationDate()).add("PotentialMatches", (Object)this.potentialMatches()).add("Matches", this.hasMatches() ? this.matches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MatchGenerationDate": {
                return Optional.ofNullable(clazz.cast(this.matchGenerationDate()));
            }
            case "PotentialMatches": {
                return Optional.ofNullable(clazz.cast(this.potentialMatches()));
            }
            case "Matches": {
                return Optional.ofNullable(clazz.cast(this.matches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMatchesResponse, T> g) {
        return obj -> g.apply((GetMatchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Instant matchGenerationDate;
        private Integer potentialMatches;
        private List<MatchItem> matches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMatchesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.matchGenerationDate(model.matchGenerationDate);
            this.potentialMatches(model.potentialMatches);
            this.matches(model.matches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getMatchGenerationDate() {
            return this.matchGenerationDate;
        }

        public final void setMatchGenerationDate(Instant matchGenerationDate) {
            this.matchGenerationDate = matchGenerationDate;
        }

        @Override
        public final Builder matchGenerationDate(Instant matchGenerationDate) {
            this.matchGenerationDate = matchGenerationDate;
            return this;
        }

        public final Integer getPotentialMatches() {
            return this.potentialMatches;
        }

        public final void setPotentialMatches(Integer potentialMatches) {
            this.potentialMatches = potentialMatches;
        }

        @Override
        public final Builder potentialMatches(Integer potentialMatches) {
            this.potentialMatches = potentialMatches;
            return this;
        }

        public final List<MatchItem.Builder> getMatches() {
            List<MatchItem.Builder> result = MatchesListCopier.copyToBuilder(this.matches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatches(Collection<MatchItem.BuilderImpl> matches) {
            this.matches = MatchesListCopier.copyFromBuilder(matches);
        }

        @Override
        public final Builder matches(Collection<MatchItem> matches) {
            this.matches = MatchesListCopier.copy(matches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matches(MatchItem ... matches) {
            this.matches(Arrays.asList(matches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matches(Consumer<MatchItem.Builder> ... matches) {
            this.matches(Stream.of(matches).map(c -> (MatchItem)((MatchItem.Builder)MatchItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMatchesResponse build() {
            return new GetMatchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMatchesResponse> {
        public Builder nextToken(String var1);

        public Builder matchGenerationDate(Instant var1);

        public Builder potentialMatches(Integer var1);

        public Builder matches(Collection<MatchItem> var1);

        public Builder matches(MatchItem ... var1);

        public Builder matches(Consumer<MatchItem.Builder> ... var1);
    }
}

