/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentDefinitionItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentDefinitionItem> {
    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentDefinitionName").getter(SegmentDefinitionItem.getter(SegmentDefinitionItem::segmentDefinitionName)).setter(SegmentDefinitionItem.setter(Builder::segmentDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(SegmentDefinitionItem.getter(SegmentDefinitionItem::displayName)).setter(SegmentDefinitionItem.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SegmentDefinitionItem.getter(SegmentDefinitionItem::description)).setter(SegmentDefinitionItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SEGMENT_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentDefinitionArn").getter(SegmentDefinitionItem.getter(SegmentDefinitionItem::segmentDefinitionArn)).setter(SegmentDefinitionItem.setter(Builder::segmentDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(SegmentDefinitionItem.getter(SegmentDefinitionItem::createdAt)).setter(SegmentDefinitionItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(SegmentDefinitionItem.getter(SegmentDefinitionItem::tags)).setter(SegmentDefinitionItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_DEFINITION_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, SEGMENT_DEFINITION_ARN_FIELD, CREATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("SegmentDefinitionArn", SEGMENT_DEFINITION_ARN_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String segmentDefinitionName;
    private final String displayName;
    private final String description;
    private final String segmentDefinitionArn;
    private final Instant createdAt;
    private final Map<String, String> tags;

    private SegmentDefinitionItem(BuilderImpl builder) {
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.segmentDefinitionArn = builder.segmentDefinitionArn;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
    }

    public final String segmentDefinitionName() {
        return this.segmentDefinitionName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final String segmentDefinitionArn() {
        return this.segmentDefinitionArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDefinitionItem)) {
            return false;
        }
        SegmentDefinitionItem other = (SegmentDefinitionItem)obj;
        return Objects.equals(this.segmentDefinitionName(), other.segmentDefinitionName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.segmentDefinitionArn(), other.segmentDefinitionArn()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentDefinitionItem").add("SegmentDefinitionName", (Object)this.segmentDefinitionName()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("SegmentDefinitionArn", (Object)this.segmentDefinitionArn()).add("CreatedAt", (Object)this.createdAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.segmentDefinitionName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SegmentDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.segmentDefinitionArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SegmentDefinitionItem, T> g) {
        return obj -> g.apply((SegmentDefinitionItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String segmentDefinitionName;
        private String displayName;
        private String description;
        private String segmentDefinitionArn;
        private Instant createdAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDefinitionItem model) {
            this.segmentDefinitionName(model.segmentDefinitionName);
            this.displayName(model.displayName);
            this.description(model.description);
            this.segmentDefinitionArn(model.segmentDefinitionArn);
            this.createdAt(model.createdAt);
            this.tags(model.tags);
        }

        public final String getSegmentDefinitionName() {
            return this.segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSegmentDefinitionArn() {
            return this.segmentDefinitionArn;
        }

        public final void setSegmentDefinitionArn(String segmentDefinitionArn) {
            this.segmentDefinitionArn = segmentDefinitionArn;
        }

        @Override
        public final Builder segmentDefinitionArn(String segmentDefinitionArn) {
            this.segmentDefinitionArn = segmentDefinitionArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public SegmentDefinitionItem build() {
            return new SegmentDefinitionItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentDefinitionItem> {
        public Builder segmentDefinitionName(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder segmentDefinitionArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

