/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.AddressDimension;
import software.amazon.awssdk.services.customerprofiles.model.AttributeDimension;
import software.amazon.awssdk.services.customerprofiles.model.CustomAttributesCopier;
import software.amazon.awssdk.services.customerprofiles.model.DateDimension;
import software.amazon.awssdk.services.customerprofiles.model.ExtraLengthValueProfileDimension;
import software.amazon.awssdk.services.customerprofiles.model.ProfileDimension;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileAttributes> {
    private static final SdkField<ProfileDimension> ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountNumber").getter(ProfileAttributes.getter(ProfileAttributes::accountNumber)).setter(ProfileAttributes.setter(Builder::accountNumber)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountNumber").build()}).build();
    private static final SdkField<ExtraLengthValueProfileDimension> ADDITIONAL_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalInformation").getter(ProfileAttributes.getter(ProfileAttributes::additionalInformation)).setter(ProfileAttributes.setter(Builder::additionalInformation)).constructor(ExtraLengthValueProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInformation").build()}).build();
    private static final SdkField<ProfileDimension> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirstName").getter(ProfileAttributes.getter(ProfileAttributes::firstName)).setter(ProfileAttributes.setter(Builder::firstName)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<ProfileDimension> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastName").getter(ProfileAttributes.getter(ProfileAttributes::lastName)).setter(ProfileAttributes.setter(Builder::lastName)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<ProfileDimension> MIDDLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MiddleName").getter(ProfileAttributes.getter(ProfileAttributes::middleName)).setter(ProfileAttributes.setter(Builder::middleName)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()}).build();
    private static final SdkField<ProfileDimension> GENDER_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GenderString").getter(ProfileAttributes.getter(ProfileAttributes::genderString)).setter(ProfileAttributes.setter(Builder::genderString)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenderString").build()}).build();
    private static final SdkField<ProfileDimension> PARTY_TYPE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartyTypeString").getter(ProfileAttributes.getter(ProfileAttributes::partyTypeString)).setter(ProfileAttributes.setter(Builder::partyTypeString)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyTypeString").build()}).build();
    private static final SdkField<DateDimension> BIRTH_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BirthDate").getter(ProfileAttributes.getter(ProfileAttributes::birthDate)).setter(ProfileAttributes.setter(Builder::birthDate)).constructor(DateDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BirthDate").build()}).build();
    private static final SdkField<ProfileDimension> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PhoneNumber").getter(ProfileAttributes.getter(ProfileAttributes::phoneNumber)).setter(ProfileAttributes.setter(Builder::phoneNumber)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<ProfileDimension> BUSINESS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BusinessName").getter(ProfileAttributes.getter(ProfileAttributes::businessName)).setter(ProfileAttributes.setter(Builder::businessName)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessName").build()}).build();
    private static final SdkField<ProfileDimension> BUSINESS_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BusinessPhoneNumber").getter(ProfileAttributes.getter(ProfileAttributes::businessPhoneNumber)).setter(ProfileAttributes.setter(Builder::businessPhoneNumber)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessPhoneNumber").build()}).build();
    private static final SdkField<ProfileDimension> HOME_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HomePhoneNumber").getter(ProfileAttributes.getter(ProfileAttributes::homePhoneNumber)).setter(ProfileAttributes.setter(Builder::homePhoneNumber)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomePhoneNumber").build()}).build();
    private static final SdkField<ProfileDimension> MOBILE_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MobilePhoneNumber").getter(ProfileAttributes.getter(ProfileAttributes::mobilePhoneNumber)).setter(ProfileAttributes.setter(Builder::mobilePhoneNumber)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobilePhoneNumber").build()}).build();
    private static final SdkField<ProfileDimension> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailAddress").getter(ProfileAttributes.getter(ProfileAttributes::emailAddress)).setter(ProfileAttributes.setter(Builder::emailAddress)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<ProfileDimension> PERSONAL_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PersonalEmailAddress").getter(ProfileAttributes.getter(ProfileAttributes::personalEmailAddress)).setter(ProfileAttributes.setter(Builder::personalEmailAddress)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalEmailAddress").build()}).build();
    private static final SdkField<ProfileDimension> BUSINESS_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BusinessEmailAddress").getter(ProfileAttributes.getter(ProfileAttributes::businessEmailAddress)).setter(ProfileAttributes.setter(Builder::businessEmailAddress)).constructor(ProfileDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessEmailAddress").build()}).build();
    private static final SdkField<AddressDimension> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(ProfileAttributes.getter(ProfileAttributes::address)).setter(ProfileAttributes.setter(Builder::address)).constructor(AddressDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<AddressDimension> SHIPPING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShippingAddress").getter(ProfileAttributes.getter(ProfileAttributes::shippingAddress)).setter(ProfileAttributes.setter(Builder::shippingAddress)).constructor(AddressDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()}).build();
    private static final SdkField<AddressDimension> MAILING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MailingAddress").getter(ProfileAttributes.getter(ProfileAttributes::mailingAddress)).setter(ProfileAttributes.setter(Builder::mailingAddress)).constructor(AddressDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailingAddress").build()}).build();
    private static final SdkField<AddressDimension> BILLING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingAddress").getter(ProfileAttributes.getter(ProfileAttributes::billingAddress)).setter(ProfileAttributes.setter(Builder::billingAddress)).constructor(AddressDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingAddress").build()}).build();
    private static final SdkField<Map<String, AttributeDimension>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(ProfileAttributes.getter(ProfileAttributes::attributes)).setter(ProfileAttributes.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NUMBER_FIELD, ADDITIONAL_INFORMATION_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, MIDDLE_NAME_FIELD, GENDER_STRING_FIELD, PARTY_TYPE_STRING_FIELD, BIRTH_DATE_FIELD, PHONE_NUMBER_FIELD, BUSINESS_NAME_FIELD, BUSINESS_PHONE_NUMBER_FIELD, HOME_PHONE_NUMBER_FIELD, MOBILE_PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD, PERSONAL_EMAIL_ADDRESS_FIELD, BUSINESS_EMAIL_ADDRESS_FIELD, ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD, MAILING_ADDRESS_FIELD, BILLING_ADDRESS_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountNumber", ACCOUNT_NUMBER_FIELD);
            this.put("AdditionalInformation", ADDITIONAL_INFORMATION_FIELD);
            this.put("FirstName", FIRST_NAME_FIELD);
            this.put("LastName", LAST_NAME_FIELD);
            this.put("MiddleName", MIDDLE_NAME_FIELD);
            this.put("GenderString", GENDER_STRING_FIELD);
            this.put("PartyTypeString", PARTY_TYPE_STRING_FIELD);
            this.put("BirthDate", BIRTH_DATE_FIELD);
            this.put("PhoneNumber", PHONE_NUMBER_FIELD);
            this.put("BusinessName", BUSINESS_NAME_FIELD);
            this.put("BusinessPhoneNumber", BUSINESS_PHONE_NUMBER_FIELD);
            this.put("HomePhoneNumber", HOME_PHONE_NUMBER_FIELD);
            this.put("MobilePhoneNumber", MOBILE_PHONE_NUMBER_FIELD);
            this.put("EmailAddress", EMAIL_ADDRESS_FIELD);
            this.put("PersonalEmailAddress", PERSONAL_EMAIL_ADDRESS_FIELD);
            this.put("BusinessEmailAddress", BUSINESS_EMAIL_ADDRESS_FIELD);
            this.put("Address", ADDRESS_FIELD);
            this.put("ShippingAddress", SHIPPING_ADDRESS_FIELD);
            this.put("MailingAddress", MAILING_ADDRESS_FIELD);
            this.put("BillingAddress", BILLING_ADDRESS_FIELD);
            this.put("Attributes", ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ProfileDimension accountNumber;
    private final ExtraLengthValueProfileDimension additionalInformation;
    private final ProfileDimension firstName;
    private final ProfileDimension lastName;
    private final ProfileDimension middleName;
    private final ProfileDimension genderString;
    private final ProfileDimension partyTypeString;
    private final DateDimension birthDate;
    private final ProfileDimension phoneNumber;
    private final ProfileDimension businessName;
    private final ProfileDimension businessPhoneNumber;
    private final ProfileDimension homePhoneNumber;
    private final ProfileDimension mobilePhoneNumber;
    private final ProfileDimension emailAddress;
    private final ProfileDimension personalEmailAddress;
    private final ProfileDimension businessEmailAddress;
    private final AddressDimension address;
    private final AddressDimension shippingAddress;
    private final AddressDimension mailingAddress;
    private final AddressDimension billingAddress;
    private final Map<String, AttributeDimension> attributes;

    private ProfileAttributes(BuilderImpl builder) {
        this.accountNumber = builder.accountNumber;
        this.additionalInformation = builder.additionalInformation;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.middleName = builder.middleName;
        this.genderString = builder.genderString;
        this.partyTypeString = builder.partyTypeString;
        this.birthDate = builder.birthDate;
        this.phoneNumber = builder.phoneNumber;
        this.businessName = builder.businessName;
        this.businessPhoneNumber = builder.businessPhoneNumber;
        this.homePhoneNumber = builder.homePhoneNumber;
        this.mobilePhoneNumber = builder.mobilePhoneNumber;
        this.emailAddress = builder.emailAddress;
        this.personalEmailAddress = builder.personalEmailAddress;
        this.businessEmailAddress = builder.businessEmailAddress;
        this.address = builder.address;
        this.shippingAddress = builder.shippingAddress;
        this.mailingAddress = builder.mailingAddress;
        this.billingAddress = builder.billingAddress;
        this.attributes = builder.attributes;
    }

    public final ProfileDimension accountNumber() {
        return this.accountNumber;
    }

    public final ExtraLengthValueProfileDimension additionalInformation() {
        return this.additionalInformation;
    }

    public final ProfileDimension firstName() {
        return this.firstName;
    }

    public final ProfileDimension lastName() {
        return this.lastName;
    }

    public final ProfileDimension middleName() {
        return this.middleName;
    }

    public final ProfileDimension genderString() {
        return this.genderString;
    }

    public final ProfileDimension partyTypeString() {
        return this.partyTypeString;
    }

    public final DateDimension birthDate() {
        return this.birthDate;
    }

    public final ProfileDimension phoneNumber() {
        return this.phoneNumber;
    }

    public final ProfileDimension businessName() {
        return this.businessName;
    }

    public final ProfileDimension businessPhoneNumber() {
        return this.businessPhoneNumber;
    }

    public final ProfileDimension homePhoneNumber() {
        return this.homePhoneNumber;
    }

    public final ProfileDimension mobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    public final ProfileDimension emailAddress() {
        return this.emailAddress;
    }

    public final ProfileDimension personalEmailAddress() {
        return this.personalEmailAddress;
    }

    public final ProfileDimension businessEmailAddress() {
        return this.businessEmailAddress;
    }

    public final AddressDimension address() {
        return this.address;
    }

    public final AddressDimension shippingAddress() {
        return this.shippingAddress;
    }

    public final AddressDimension mailingAddress() {
        return this.mailingAddress;
    }

    public final AddressDimension billingAddress() {
        return this.billingAddress;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeDimension> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.middleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.genderString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partyTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.birthDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessName());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.mobilePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileAttributes)) {
            return false;
        }
        ProfileAttributes other = (ProfileAttributes)obj;
        return Objects.equals(this.accountNumber(), other.accountNumber()) && Objects.equals(this.additionalInformation(), other.additionalInformation()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.middleName(), other.middleName()) && Objects.equals(this.genderString(), other.genderString()) && Objects.equals(this.partyTypeString(), other.partyTypeString()) && Objects.equals(this.birthDate(), other.birthDate()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.businessName(), other.businessName()) && Objects.equals(this.businessPhoneNumber(), other.businessPhoneNumber()) && Objects.equals(this.homePhoneNumber(), other.homePhoneNumber()) && Objects.equals(this.mobilePhoneNumber(), other.mobilePhoneNumber()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.personalEmailAddress(), other.personalEmailAddress()) && Objects.equals(this.businessEmailAddress(), other.businessEmailAddress()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.shippingAddress(), other.shippingAddress()) && Objects.equals(this.mailingAddress(), other.mailingAddress()) && Objects.equals(this.billingAddress(), other.billingAddress()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileAttributes").add("AccountNumber", (Object)this.accountNumber()).add("AdditionalInformation", (Object)this.additionalInformation()).add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("MiddleName", (Object)this.middleName()).add("GenderString", (Object)this.genderString()).add("PartyTypeString", (Object)this.partyTypeString()).add("BirthDate", (Object)this.birthDate()).add("PhoneNumber", (Object)this.phoneNumber()).add("BusinessName", (Object)this.businessName()).add("BusinessPhoneNumber", (Object)this.businessPhoneNumber()).add("HomePhoneNumber", (Object)this.homePhoneNumber()).add("MobilePhoneNumber", (Object)this.mobilePhoneNumber()).add("EmailAddress", (Object)this.emailAddress()).add("PersonalEmailAddress", (Object)this.personalEmailAddress()).add("BusinessEmailAddress", (Object)this.businessEmailAddress()).add("Address", (Object)this.address()).add("ShippingAddress", (Object)this.shippingAddress()).add("MailingAddress", (Object)this.mailingAddress()).add("BillingAddress", (Object)this.billingAddress()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountNumber": {
                return Optional.ofNullable(clazz.cast(this.accountNumber()));
            }
            case "AdditionalInformation": {
                return Optional.ofNullable(clazz.cast(this.additionalInformation()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "MiddleName": {
                return Optional.ofNullable(clazz.cast(this.middleName()));
            }
            case "GenderString": {
                return Optional.ofNullable(clazz.cast(this.genderString()));
            }
            case "PartyTypeString": {
                return Optional.ofNullable(clazz.cast(this.partyTypeString()));
            }
            case "BirthDate": {
                return Optional.ofNullable(clazz.cast(this.birthDate()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "BusinessName": {
                return Optional.ofNullable(clazz.cast(this.businessName()));
            }
            case "BusinessPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.businessPhoneNumber()));
            }
            case "HomePhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.homePhoneNumber()));
            }
            case "MobilePhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.mobilePhoneNumber()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "PersonalEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.personalEmailAddress()));
            }
            case "BusinessEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.businessEmailAddress()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "ShippingAddress": {
                return Optional.ofNullable(clazz.cast(this.shippingAddress()));
            }
            case "MailingAddress": {
                return Optional.ofNullable(clazz.cast(this.mailingAddress()));
            }
            case "BillingAddress": {
                return Optional.ofNullable(clazz.cast(this.billingAddress()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProfileAttributes, T> g) {
        return obj -> g.apply((ProfileAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProfileDimension accountNumber;
        private ExtraLengthValueProfileDimension additionalInformation;
        private ProfileDimension firstName;
        private ProfileDimension lastName;
        private ProfileDimension middleName;
        private ProfileDimension genderString;
        private ProfileDimension partyTypeString;
        private DateDimension birthDate;
        private ProfileDimension phoneNumber;
        private ProfileDimension businessName;
        private ProfileDimension businessPhoneNumber;
        private ProfileDimension homePhoneNumber;
        private ProfileDimension mobilePhoneNumber;
        private ProfileDimension emailAddress;
        private ProfileDimension personalEmailAddress;
        private ProfileDimension businessEmailAddress;
        private AddressDimension address;
        private AddressDimension shippingAddress;
        private AddressDimension mailingAddress;
        private AddressDimension billingAddress;
        private Map<String, AttributeDimension> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileAttributes model) {
            this.accountNumber(model.accountNumber);
            this.additionalInformation(model.additionalInformation);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.middleName(model.middleName);
            this.genderString(model.genderString);
            this.partyTypeString(model.partyTypeString);
            this.birthDate(model.birthDate);
            this.phoneNumber(model.phoneNumber);
            this.businessName(model.businessName);
            this.businessPhoneNumber(model.businessPhoneNumber);
            this.homePhoneNumber(model.homePhoneNumber);
            this.mobilePhoneNumber(model.mobilePhoneNumber);
            this.emailAddress(model.emailAddress);
            this.personalEmailAddress(model.personalEmailAddress);
            this.businessEmailAddress(model.businessEmailAddress);
            this.address(model.address);
            this.shippingAddress(model.shippingAddress);
            this.mailingAddress(model.mailingAddress);
            this.billingAddress(model.billingAddress);
            this.attributes(model.attributes);
        }

        public final ProfileDimension.Builder getAccountNumber() {
            return this.accountNumber != null ? this.accountNumber.toBuilder() : null;
        }

        public final void setAccountNumber(ProfileDimension.BuilderImpl accountNumber) {
            this.accountNumber = accountNumber != null ? accountNumber.build() : null;
        }

        @Override
        public final Builder accountNumber(ProfileDimension accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public final ExtraLengthValueProfileDimension.Builder getAdditionalInformation() {
            return this.additionalInformation != null ? this.additionalInformation.toBuilder() : null;
        }

        public final void setAdditionalInformation(ExtraLengthValueProfileDimension.BuilderImpl additionalInformation) {
            this.additionalInformation = additionalInformation != null ? additionalInformation.build() : null;
        }

        @Override
        public final Builder additionalInformation(ExtraLengthValueProfileDimension additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final ProfileDimension.Builder getFirstName() {
            return this.firstName != null ? this.firstName.toBuilder() : null;
        }

        public final void setFirstName(ProfileDimension.BuilderImpl firstName) {
            this.firstName = firstName != null ? firstName.build() : null;
        }

        @Override
        public final Builder firstName(ProfileDimension firstName) {
            this.firstName = firstName;
            return this;
        }

        public final ProfileDimension.Builder getLastName() {
            return this.lastName != null ? this.lastName.toBuilder() : null;
        }

        public final void setLastName(ProfileDimension.BuilderImpl lastName) {
            this.lastName = lastName != null ? lastName.build() : null;
        }

        @Override
        public final Builder lastName(ProfileDimension lastName) {
            this.lastName = lastName;
            return this;
        }

        public final ProfileDimension.Builder getMiddleName() {
            return this.middleName != null ? this.middleName.toBuilder() : null;
        }

        public final void setMiddleName(ProfileDimension.BuilderImpl middleName) {
            this.middleName = middleName != null ? middleName.build() : null;
        }

        @Override
        public final Builder middleName(ProfileDimension middleName) {
            this.middleName = middleName;
            return this;
        }

        public final ProfileDimension.Builder getGenderString() {
            return this.genderString != null ? this.genderString.toBuilder() : null;
        }

        public final void setGenderString(ProfileDimension.BuilderImpl genderString) {
            this.genderString = genderString != null ? genderString.build() : null;
        }

        @Override
        public final Builder genderString(ProfileDimension genderString) {
            this.genderString = genderString;
            return this;
        }

        public final ProfileDimension.Builder getPartyTypeString() {
            return this.partyTypeString != null ? this.partyTypeString.toBuilder() : null;
        }

        public final void setPartyTypeString(ProfileDimension.BuilderImpl partyTypeString) {
            this.partyTypeString = partyTypeString != null ? partyTypeString.build() : null;
        }

        @Override
        public final Builder partyTypeString(ProfileDimension partyTypeString) {
            this.partyTypeString = partyTypeString;
            return this;
        }

        public final DateDimension.Builder getBirthDate() {
            return this.birthDate != null ? this.birthDate.toBuilder() : null;
        }

        public final void setBirthDate(DateDimension.BuilderImpl birthDate) {
            this.birthDate = birthDate != null ? birthDate.build() : null;
        }

        @Override
        public final Builder birthDate(DateDimension birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public final ProfileDimension.Builder getPhoneNumber() {
            return this.phoneNumber != null ? this.phoneNumber.toBuilder() : null;
        }

        public final void setPhoneNumber(ProfileDimension.BuilderImpl phoneNumber) {
            this.phoneNumber = phoneNumber != null ? phoneNumber.build() : null;
        }

        @Override
        public final Builder phoneNumber(ProfileDimension phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getBusinessName() {
            return this.businessName != null ? this.businessName.toBuilder() : null;
        }

        public final void setBusinessName(ProfileDimension.BuilderImpl businessName) {
            this.businessName = businessName != null ? businessName.build() : null;
        }

        @Override
        public final Builder businessName(ProfileDimension businessName) {
            this.businessName = businessName;
            return this;
        }

        public final ProfileDimension.Builder getBusinessPhoneNumber() {
            return this.businessPhoneNumber != null ? this.businessPhoneNumber.toBuilder() : null;
        }

        public final void setBusinessPhoneNumber(ProfileDimension.BuilderImpl businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber != null ? businessPhoneNumber.build() : null;
        }

        @Override
        public final Builder businessPhoneNumber(ProfileDimension businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getHomePhoneNumber() {
            return this.homePhoneNumber != null ? this.homePhoneNumber.toBuilder() : null;
        }

        public final void setHomePhoneNumber(ProfileDimension.BuilderImpl homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber != null ? homePhoneNumber.build() : null;
        }

        @Override
        public final Builder homePhoneNumber(ProfileDimension homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getMobilePhoneNumber() {
            return this.mobilePhoneNumber != null ? this.mobilePhoneNumber.toBuilder() : null;
        }

        public final void setMobilePhoneNumber(ProfileDimension.BuilderImpl mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber != null ? mobilePhoneNumber.build() : null;
        }

        @Override
        public final Builder mobilePhoneNumber(ProfileDimension mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getEmailAddress() {
            return this.emailAddress != null ? this.emailAddress.toBuilder() : null;
        }

        public final void setEmailAddress(ProfileDimension.BuilderImpl emailAddress) {
            this.emailAddress = emailAddress != null ? emailAddress.build() : null;
        }

        @Override
        public final Builder emailAddress(ProfileDimension emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final ProfileDimension.Builder getPersonalEmailAddress() {
            return this.personalEmailAddress != null ? this.personalEmailAddress.toBuilder() : null;
        }

        public final void setPersonalEmailAddress(ProfileDimension.BuilderImpl personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress != null ? personalEmailAddress.build() : null;
        }

        @Override
        public final Builder personalEmailAddress(ProfileDimension personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
            return this;
        }

        public final ProfileDimension.Builder getBusinessEmailAddress() {
            return this.businessEmailAddress != null ? this.businessEmailAddress.toBuilder() : null;
        }

        public final void setBusinessEmailAddress(ProfileDimension.BuilderImpl businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress != null ? businessEmailAddress.build() : null;
        }

        @Override
        public final Builder businessEmailAddress(ProfileDimension businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
            return this;
        }

        public final AddressDimension.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(AddressDimension.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AddressDimension address) {
            this.address = address;
            return this;
        }

        public final AddressDimension.Builder getShippingAddress() {
            return this.shippingAddress != null ? this.shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(AddressDimension.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(AddressDimension shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final AddressDimension.Builder getMailingAddress() {
            return this.mailingAddress != null ? this.mailingAddress.toBuilder() : null;
        }

        public final void setMailingAddress(AddressDimension.BuilderImpl mailingAddress) {
            this.mailingAddress = mailingAddress != null ? mailingAddress.build() : null;
        }

        @Override
        public final Builder mailingAddress(AddressDimension mailingAddress) {
            this.mailingAddress = mailingAddress;
            return this;
        }

        public final AddressDimension.Builder getBillingAddress() {
            return this.billingAddress != null ? this.billingAddress.toBuilder() : null;
        }

        public final void setBillingAddress(AddressDimension.BuilderImpl billingAddress) {
            this.billingAddress = billingAddress != null ? billingAddress.build() : null;
        }

        @Override
        public final Builder billingAddress(AddressDimension billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public final Map<String, AttributeDimension.Builder> getAttributes() {
            Map<String, AttributeDimension.Builder> result = CustomAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, AttributeDimension.BuilderImpl> attributes) {
            this.attributes = CustomAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = CustomAttributesCopier.copy(attributes);
            return this;
        }

        public ProfileAttributes build() {
            return new ProfileAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileAttributes> {
        public Builder accountNumber(ProfileDimension var1);

        default public Builder accountNumber(Consumer<ProfileDimension.Builder> accountNumber) {
            return this.accountNumber((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(accountNumber)).build());
        }

        public Builder additionalInformation(ExtraLengthValueProfileDimension var1);

        default public Builder additionalInformation(Consumer<ExtraLengthValueProfileDimension.Builder> additionalInformation) {
            return this.additionalInformation((ExtraLengthValueProfileDimension)((ExtraLengthValueProfileDimension.Builder)ExtraLengthValueProfileDimension.builder().applyMutation(additionalInformation)).build());
        }

        public Builder firstName(ProfileDimension var1);

        default public Builder firstName(Consumer<ProfileDimension.Builder> firstName) {
            return this.firstName((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(firstName)).build());
        }

        public Builder lastName(ProfileDimension var1);

        default public Builder lastName(Consumer<ProfileDimension.Builder> lastName) {
            return this.lastName((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(lastName)).build());
        }

        public Builder middleName(ProfileDimension var1);

        default public Builder middleName(Consumer<ProfileDimension.Builder> middleName) {
            return this.middleName((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(middleName)).build());
        }

        public Builder genderString(ProfileDimension var1);

        default public Builder genderString(Consumer<ProfileDimension.Builder> genderString) {
            return this.genderString((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(genderString)).build());
        }

        public Builder partyTypeString(ProfileDimension var1);

        default public Builder partyTypeString(Consumer<ProfileDimension.Builder> partyTypeString) {
            return this.partyTypeString((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(partyTypeString)).build());
        }

        public Builder birthDate(DateDimension var1);

        default public Builder birthDate(Consumer<DateDimension.Builder> birthDate) {
            return this.birthDate((DateDimension)((DateDimension.Builder)DateDimension.builder().applyMutation(birthDate)).build());
        }

        public Builder phoneNumber(ProfileDimension var1);

        default public Builder phoneNumber(Consumer<ProfileDimension.Builder> phoneNumber) {
            return this.phoneNumber((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(phoneNumber)).build());
        }

        public Builder businessName(ProfileDimension var1);

        default public Builder businessName(Consumer<ProfileDimension.Builder> businessName) {
            return this.businessName((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(businessName)).build());
        }

        public Builder businessPhoneNumber(ProfileDimension var1);

        default public Builder businessPhoneNumber(Consumer<ProfileDimension.Builder> businessPhoneNumber) {
            return this.businessPhoneNumber((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(businessPhoneNumber)).build());
        }

        public Builder homePhoneNumber(ProfileDimension var1);

        default public Builder homePhoneNumber(Consumer<ProfileDimension.Builder> homePhoneNumber) {
            return this.homePhoneNumber((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(homePhoneNumber)).build());
        }

        public Builder mobilePhoneNumber(ProfileDimension var1);

        default public Builder mobilePhoneNumber(Consumer<ProfileDimension.Builder> mobilePhoneNumber) {
            return this.mobilePhoneNumber((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(mobilePhoneNumber)).build());
        }

        public Builder emailAddress(ProfileDimension var1);

        default public Builder emailAddress(Consumer<ProfileDimension.Builder> emailAddress) {
            return this.emailAddress((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(emailAddress)).build());
        }

        public Builder personalEmailAddress(ProfileDimension var1);

        default public Builder personalEmailAddress(Consumer<ProfileDimension.Builder> personalEmailAddress) {
            return this.personalEmailAddress((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(personalEmailAddress)).build());
        }

        public Builder businessEmailAddress(ProfileDimension var1);

        default public Builder businessEmailAddress(Consumer<ProfileDimension.Builder> businessEmailAddress) {
            return this.businessEmailAddress((ProfileDimension)((ProfileDimension.Builder)ProfileDimension.builder().applyMutation(businessEmailAddress)).build());
        }

        public Builder address(AddressDimension var1);

        default public Builder address(Consumer<AddressDimension.Builder> address) {
            return this.address((AddressDimension)((AddressDimension.Builder)AddressDimension.builder().applyMutation(address)).build());
        }

        public Builder shippingAddress(AddressDimension var1);

        default public Builder shippingAddress(Consumer<AddressDimension.Builder> shippingAddress) {
            return this.shippingAddress((AddressDimension)((AddressDimension.Builder)AddressDimension.builder().applyMutation(shippingAddress)).build());
        }

        public Builder mailingAddress(AddressDimension var1);

        default public Builder mailingAddress(Consumer<AddressDimension.Builder> mailingAddress) {
            return this.mailingAddress((AddressDimension)((AddressDimension.Builder)AddressDimension.builder().applyMutation(mailingAddress)).build());
        }

        public Builder billingAddress(AddressDimension var1);

        default public Builder billingAddress(Consumer<AddressDimension.Builder> billingAddress) {
            return this.billingAddress((AddressDimension)((AddressDimension.Builder)AddressDimension.builder().applyMutation(billingAddress)).build());
        }

        public Builder attributes(Map<String, AttributeDimension> var1);
    }
}

