/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.MatchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSimilarProfilesRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, GetSimilarProfilesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSimilarProfilesRequest.getter(GetSimilarProfilesRequest::nextToken)).setter(GetSimilarProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetSimilarProfilesRequest.getter(GetSimilarProfilesRequest::maxResults)).setter(GetSimilarProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetSimilarProfilesRequest.getter(GetSimilarProfilesRequest::domainName)).setter(GetSimilarProfilesRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchType").getter(GetSimilarProfilesRequest.getter(GetSimilarProfilesRequest::matchTypeAsString)).setter(GetSimilarProfilesRequest.setter(Builder::matchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()}).build();
    private static final SdkField<String> SEARCH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchKey").getter(GetSimilarProfilesRequest.getter(GetSimilarProfilesRequest::searchKey)).setter(GetSimilarProfilesRequest.setter(Builder::searchKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchKey").build()}).build();
    private static final SdkField<String> SEARCH_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchValue").getter(GetSimilarProfilesRequest.getter(GetSimilarProfilesRequest::searchValue)).setter(GetSimilarProfilesRequest.setter(Builder::searchValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, DOMAIN_NAME_FIELD, MATCH_TYPE_FIELD, SEARCH_KEY_FIELD, SEARCH_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSimilarProfilesRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String domainName;
    private final String matchType;
    private final String searchKey;
    private final String searchValue;

    private GetSimilarProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.domainName = builder.domainName;
        this.matchType = builder.matchType;
        this.searchKey = builder.searchKey;
        this.searchValue = builder.searchValue;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final MatchType matchType() {
        return MatchType.fromValue(this.matchType);
    }

    public final String matchTypeAsString() {
        return this.matchType;
    }

    public final String searchKey() {
        return this.searchKey;
    }

    public final String searchValue() {
        return this.searchValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSimilarProfilesRequest)) {
            return false;
        }
        GetSimilarProfilesRequest other = (GetSimilarProfilesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.matchTypeAsString(), other.matchTypeAsString()) && Objects.equals(this.searchKey(), other.searchKey()) && Objects.equals(this.searchValue(), other.searchValue());
    }

    public final String toString() {
        return ToString.builder((String)"GetSimilarProfilesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("DomainName", (Object)this.domainName()).add("MatchType", (Object)this.matchTypeAsString()).add("SearchKey", (Object)this.searchKey()).add("SearchValue", (Object)this.searchValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "MatchType": {
                return Optional.ofNullable(clazz.cast(this.matchTypeAsString()));
            }
            case "SearchKey": {
                return Optional.ofNullable(clazz.cast(this.searchKey()));
            }
            case "SearchValue": {
                return Optional.ofNullable(clazz.cast(this.searchValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("next-token", NEXT_TOKEN_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("MatchType", MATCH_TYPE_FIELD);
        map.put("SearchKey", SEARCH_KEY_FIELD);
        map.put("SearchValue", SEARCH_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSimilarProfilesRequest, T> g) {
        return obj -> g.apply((GetSimilarProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String domainName;
        private String matchType;
        private String searchKey;
        private String searchValue;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSimilarProfilesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.domainName(model.domainName);
            this.matchType(model.matchType);
            this.searchKey(model.searchKey);
            this.searchValue(model.searchValue);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public final String getSearchKey() {
            return this.searchKey;
        }

        public final void setSearchKey(String searchKey) {
            this.searchKey = searchKey;
        }

        @Override
        public final Builder searchKey(String searchKey) {
            this.searchKey = searchKey;
            return this;
        }

        public final String getSearchValue() {
            return this.searchValue;
        }

        public final void setSearchValue(String searchValue) {
            this.searchValue = searchValue;
        }

        @Override
        public final Builder searchValue(String searchValue) {
            this.searchValue = searchValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSimilarProfilesRequest build() {
            return new GetSimilarProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSimilarProfilesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder domainName(String var1);

        public Builder matchType(String var1);

        public Builder matchType(MatchType var1);

        public Builder searchKey(String var1);

        public Builder searchValue(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

