/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that segments on Customer Profile's address object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressDimension implements SdkPojo, Serializable,
        ToCopyableBuilder<AddressDimension.Builder, AddressDimension> {
    private static final SdkField<ProfileDimension> CITY_FIELD = SdkField.<ProfileDimension> builder(MarshallingType.SDK_POJO)
            .memberName("City").getter(getter(AddressDimension::city)).setter(setter(Builder::city))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<ProfileDimension> COUNTRY_FIELD = SdkField.<ProfileDimension> builder(MarshallingType.SDK_POJO)
            .memberName("Country").getter(getter(AddressDimension::country)).setter(setter(Builder::country))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<ProfileDimension> COUNTY_FIELD = SdkField.<ProfileDimension> builder(MarshallingType.SDK_POJO)
            .memberName("County").getter(getter(AddressDimension::county)).setter(setter(Builder::county))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("County").build()).build();

    private static final SdkField<ProfileDimension> POSTAL_CODE_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("PostalCode")
            .getter(getter(AddressDimension::postalCode)).setter(setter(Builder::postalCode))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<ProfileDimension> PROVINCE_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("Province")
            .getter(getter(AddressDimension::province)).setter(setter(Builder::province)).constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Province").build()).build();

    private static final SdkField<ProfileDimension> STATE_FIELD = SdkField.<ProfileDimension> builder(MarshallingType.SDK_POJO)
            .memberName("State").getter(getter(AddressDimension::state)).setter(setter(Builder::state))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_FIELD,
            COUNTY_FIELD, POSTAL_CODE_FIELD, PROVINCE_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProfileDimension city;

    private final ProfileDimension country;

    private final ProfileDimension county;

    private final ProfileDimension postalCode;

    private final ProfileDimension province;

    private final ProfileDimension state;

    private AddressDimension(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.county = builder.county;
        this.postalCode = builder.postalCode;
        this.province = builder.province;
        this.state = builder.state;
    }

    /**
     * <p>
     * The city belonging to the address.
     * </p>
     * 
     * @return The city belonging to the address.
     */
    public final ProfileDimension city() {
        return city;
    }

    /**
     * <p>
     * The country belonging to the address.
     * </p>
     * 
     * @return The country belonging to the address.
     */
    public final ProfileDimension country() {
        return country;
    }

    /**
     * <p>
     * The county belonging to the address.
     * </p>
     * 
     * @return The county belonging to the address.
     */
    public final ProfileDimension county() {
        return county;
    }

    /**
     * <p>
     * The postal code belonging to the address.
     * </p>
     * 
     * @return The postal code belonging to the address.
     */
    public final ProfileDimension postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The province belonging to the address.
     * </p>
     * 
     * @return The province belonging to the address.
     */
    public final ProfileDimension province() {
        return province;
    }

    /**
     * <p>
     * The state belonging to the address.
     * </p>
     * 
     * @return The state belonging to the address.
     */
    public final ProfileDimension state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(county());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(province());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressDimension)) {
            return false;
        }
        AddressDimension other = (AddressDimension) obj;
        return Objects.equals(city(), other.city()) && Objects.equals(country(), other.country())
                && Objects.equals(county(), other.county()) && Objects.equals(postalCode(), other.postalCode())
                && Objects.equals(province(), other.province()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressDimension").add("City", city()).add("Country", country()).add("County", county())
                .add("PostalCode", postalCode()).add("Province", province()).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "County":
            return Optional.ofNullable(clazz.cast(county()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "Province":
            return Optional.ofNullable(clazz.cast(province()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("City", CITY_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("County", COUNTY_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("Province", PROVINCE_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressDimension, T> g) {
        return obj -> g.apply((AddressDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressDimension> {
        /**
         * <p>
         * The city belonging to the address.
         * </p>
         * 
         * @param city
         *        The city belonging to the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(ProfileDimension city);

        /**
         * <p>
         * The city belonging to the address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #city(ProfileDimension)}.
         * 
         * @param city
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #city(ProfileDimension)
         */
        default Builder city(Consumer<ProfileDimension.Builder> city) {
            return city(ProfileDimension.builder().applyMutation(city).build());
        }

        /**
         * <p>
         * The country belonging to the address.
         * </p>
         * 
         * @param country
         *        The country belonging to the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(ProfileDimension country);

        /**
         * <p>
         * The country belonging to the address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #country(ProfileDimension)}.
         * 
         * @param country
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #country(ProfileDimension)
         */
        default Builder country(Consumer<ProfileDimension.Builder> country) {
            return country(ProfileDimension.builder().applyMutation(country).build());
        }

        /**
         * <p>
         * The county belonging to the address.
         * </p>
         * 
         * @param county
         *        The county belonging to the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder county(ProfileDimension county);

        /**
         * <p>
         * The county belonging to the address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #county(ProfileDimension)}.
         * 
         * @param county
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #county(ProfileDimension)
         */
        default Builder county(Consumer<ProfileDimension.Builder> county) {
            return county(ProfileDimension.builder().applyMutation(county).build());
        }

        /**
         * <p>
         * The postal code belonging to the address.
         * </p>
         * 
         * @param postalCode
         *        The postal code belonging to the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(ProfileDimension postalCode);

        /**
         * <p>
         * The postal code belonging to the address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #postalCode(ProfileDimension)}.
         * 
         * @param postalCode
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postalCode(ProfileDimension)
         */
        default Builder postalCode(Consumer<ProfileDimension.Builder> postalCode) {
            return postalCode(ProfileDimension.builder().applyMutation(postalCode).build());
        }

        /**
         * <p>
         * The province belonging to the address.
         * </p>
         * 
         * @param province
         *        The province belonging to the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder province(ProfileDimension province);

        /**
         * <p>
         * The province belonging to the address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #province(ProfileDimension)}.
         * 
         * @param province
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #province(ProfileDimension)
         */
        default Builder province(Consumer<ProfileDimension.Builder> province) {
            return province(ProfileDimension.builder().applyMutation(province).build());
        }

        /**
         * <p>
         * The state belonging to the address.
         * </p>
         * 
         * @param state
         *        The state belonging to the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ProfileDimension state);

        /**
         * <p>
         * The state belonging to the address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #state(ProfileDimension)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ProfileDimension)
         */
        default Builder state(Consumer<ProfileDimension.Builder> state) {
            return state(ProfileDimension.builder().applyMutation(state).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProfileDimension city;

        private ProfileDimension country;

        private ProfileDimension county;

        private ProfileDimension postalCode;

        private ProfileDimension province;

        private ProfileDimension state;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressDimension model) {
            city(model.city);
            country(model.country);
            county(model.county);
            postalCode(model.postalCode);
            province(model.province);
            state(model.state);
        }

        public final ProfileDimension.Builder getCity() {
            return city != null ? city.toBuilder() : null;
        }

        public final void setCity(ProfileDimension.BuilderImpl city) {
            this.city = city != null ? city.build() : null;
        }

        @Override
        public final Builder city(ProfileDimension city) {
            this.city = city;
            return this;
        }

        public final ProfileDimension.Builder getCountry() {
            return country != null ? country.toBuilder() : null;
        }

        public final void setCountry(ProfileDimension.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        @Override
        public final Builder country(ProfileDimension country) {
            this.country = country;
            return this;
        }

        public final ProfileDimension.Builder getCounty() {
            return county != null ? county.toBuilder() : null;
        }

        public final void setCounty(ProfileDimension.BuilderImpl county) {
            this.county = county != null ? county.build() : null;
        }

        @Override
        public final Builder county(ProfileDimension county) {
            this.county = county;
            return this;
        }

        public final ProfileDimension.Builder getPostalCode() {
            return postalCode != null ? postalCode.toBuilder() : null;
        }

        public final void setPostalCode(ProfileDimension.BuilderImpl postalCode) {
            this.postalCode = postalCode != null ? postalCode.build() : null;
        }

        @Override
        public final Builder postalCode(ProfileDimension postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final ProfileDimension.Builder getProvince() {
            return province != null ? province.toBuilder() : null;
        }

        public final void setProvince(ProfileDimension.BuilderImpl province) {
            this.province = province != null ? province.build() : null;
        }

        @Override
        public final Builder province(ProfileDimension province) {
            this.province = province;
            return this;
        }

        public final ProfileDimension.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ProfileDimension.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ProfileDimension state) {
            this.state = state;
            return this;
        }

        @Override
        public AddressDimension build() {
            return new AddressDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
