/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for workflow of type <code>APPFLOW_INTEGRATION</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppflowIntegration implements SdkPojo, Serializable,
        ToCopyableBuilder<AppflowIntegration.Builder, AppflowIntegration> {
    private static final SdkField<FlowDefinition> FLOW_DEFINITION_FIELD = SdkField
            .<FlowDefinition> builder(MarshallingType.SDK_POJO).memberName("FlowDefinition")
            .getter(getter(AppflowIntegration::flowDefinition)).setter(setter(Builder::flowDefinition))
            .constructor(FlowDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinition").build()).build();

    private static final SdkField<List<Batch>> BATCHES_FIELD = SdkField
            .<List<Batch>> builder(MarshallingType.LIST)
            .memberName("Batches")
            .getter(getter(AppflowIntegration::batches))
            .setter(setter(Builder::batches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Batches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Batch> builder(MarshallingType.SDK_POJO)
                                            .constructor(Batch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_FIELD,
            BATCHES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowDefinition flowDefinition;

    private final List<Batch> batches;

    private AppflowIntegration(BuilderImpl builder) {
        this.flowDefinition = builder.flowDefinition;
        this.batches = builder.batches;
    }

    /**
     * Returns the value of the FlowDefinition property for this object.
     * 
     * @return The value of the FlowDefinition property for this object.
     */
    public final FlowDefinition flowDefinition() {
        return flowDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Batches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBatches() {
        return batches != null && !(batches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Batches in workflow of type <code>APPFLOW_INTEGRATION</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatches} method.
     * </p>
     * 
     * @return Batches in workflow of type <code>APPFLOW_INTEGRATION</code>.
     */
    public final List<Batch> batches() {
        return batches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasBatches() ? batches() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppflowIntegration)) {
            return false;
        }
        AppflowIntegration other = (AppflowIntegration) obj;
        return Objects.equals(flowDefinition(), other.flowDefinition()) && hasBatches() == other.hasBatches()
                && Objects.equals(batches(), other.batches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppflowIntegration")
                .add("FlowDefinition", flowDefinition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Batches", hasBatches() ? batches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowDefinition":
            return Optional.ofNullable(clazz.cast(flowDefinition()));
        case "Batches":
            return Optional.ofNullable(clazz.cast(batches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlowDefinition", FLOW_DEFINITION_FIELD);
        map.put("Batches", BATCHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppflowIntegration, T> g) {
        return obj -> g.apply((AppflowIntegration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppflowIntegration> {
        /**
         * Sets the value of the FlowDefinition property for this object.
         *
         * @param flowDefinition
         *        The new value for the FlowDefinition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinition(FlowDefinition flowDefinition);

        /**
         * Sets the value of the FlowDefinition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FlowDefinition.Builder} avoiding the need
         * to create one manually via {@link FlowDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #flowDefinition(FlowDefinition)}.
         * 
         * @param flowDefinition
         *        a consumer that will call methods on {@link FlowDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowDefinition(FlowDefinition)
         */
        default Builder flowDefinition(Consumer<FlowDefinition.Builder> flowDefinition) {
            return flowDefinition(FlowDefinition.builder().applyMutation(flowDefinition).build());
        }

        /**
         * <p>
         * Batches in workflow of type <code>APPFLOW_INTEGRATION</code>.
         * </p>
         * 
         * @param batches
         *        Batches in workflow of type <code>APPFLOW_INTEGRATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batches(Collection<Batch> batches);

        /**
         * <p>
         * Batches in workflow of type <code>APPFLOW_INTEGRATION</code>.
         * </p>
         * 
         * @param batches
         *        Batches in workflow of type <code>APPFLOW_INTEGRATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batches(Batch... batches);

        /**
         * <p>
         * Batches in workflow of type <code>APPFLOW_INTEGRATION</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.Batch.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.customerprofiles.model.Batch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.Batch.Builder#build()} is called immediately
         * and its result is passed to {@link #batches(List<Batch>)}.
         * 
         * @param batches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.Batch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batches(java.util.Collection<Batch>)
         */
        Builder batches(Consumer<Batch.Builder>... batches);
    }

    static final class BuilderImpl implements Builder {
        private FlowDefinition flowDefinition;

        private List<Batch> batches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppflowIntegration model) {
            flowDefinition(model.flowDefinition);
            batches(model.batches);
        }

        public final FlowDefinition.Builder getFlowDefinition() {
            return flowDefinition != null ? flowDefinition.toBuilder() : null;
        }

        public final void setFlowDefinition(FlowDefinition.BuilderImpl flowDefinition) {
            this.flowDefinition = flowDefinition != null ? flowDefinition.build() : null;
        }

        @Override
        public final Builder flowDefinition(FlowDefinition flowDefinition) {
            this.flowDefinition = flowDefinition;
            return this;
        }

        public final List<Batch.Builder> getBatches() {
            List<Batch.Builder> result = BatchesCopier.copyToBuilder(this.batches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatches(Collection<Batch.BuilderImpl> batches) {
            this.batches = BatchesCopier.copyFromBuilder(batches);
        }

        @Override
        public final Builder batches(Collection<Batch> batches) {
            this.batches = BatchesCopier.copy(batches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batches(Batch... batches) {
            batches(Arrays.asList(batches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batches(Consumer<Batch.Builder>... batches) {
            batches(Stream.of(batches).map(c -> Batch.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AppflowIntegration build() {
            return new AppflowIntegration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
