/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for how to perform the auto-merging of profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMerging implements SdkPojo, Serializable, ToCopyableBuilder<AutoMerging.Builder, AutoMerging> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AutoMerging::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Consolidation> CONSOLIDATION_FIELD = SdkField.<Consolidation> builder(MarshallingType.SDK_POJO)
            .memberName("Consolidation").getter(getter(AutoMerging::consolidation)).setter(setter(Builder::consolidation))
            .constructor(Consolidation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Consolidation").build()).build();

    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField
            .<ConflictResolution> builder(MarshallingType.SDK_POJO).memberName("ConflictResolution")
            .getter(getter(AutoMerging::conflictResolution)).setter(setter(Builder::conflictResolution))
            .constructor(ConflictResolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictResolution").build())
            .build();

    private static final SdkField<Double> MIN_ALLOWED_CONFIDENCE_SCORE_FOR_MERGING_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinAllowedConfidenceScoreForMerging")
            .getter(getter(AutoMerging::minAllowedConfidenceScoreForMerging))
            .setter(setter(Builder::minAllowedConfidenceScoreForMerging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MinAllowedConfidenceScoreForMerging").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            CONSOLIDATION_FIELD, CONFLICT_RESOLUTION_FIELD, MIN_ALLOWED_CONFIDENCE_SCORE_FOR_MERGING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Consolidation consolidation;

    private final ConflictResolution conflictResolution;

    private final Double minAllowedConfidenceScoreForMerging;

    private AutoMerging(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.consolidation = builder.consolidation;
        this.conflictResolution = builder.conflictResolution;
        this.minAllowedConfidenceScoreForMerging = builder.minAllowedConfidenceScoreForMerging;
    }

    /**
     * <p>
     * The flag that enables the auto-merging of duplicate profiles.
     * </p>
     * 
     * @return The flag that enables the auto-merging of duplicate profiles.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A list of matching attributes that represent matching criteria. If two profiles meet at least one of the
     * requirements in the matching attributes list, they will be merged.
     * </p>
     * 
     * @return A list of matching attributes that represent matching criteria. If two profiles meet at least one of the
     *         requirements in the matching attributes list, they will be merged.
     */
    public final Consolidation consolidation() {
        return consolidation;
    }

    /**
     * <p>
     * How the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and
     * Profile B have the same <code>FirstName</code> and <code>LastName</code> (and that is the matching criteria),
     * which <code>EmailAddress</code> should be used?
     * </p>
     * 
     * @return How the auto-merging process should resolve conflicts between different profiles. For example, if Profile
     *         A and Profile B have the same <code>FirstName</code> and <code>LastName</code> (and that is the matching
     *         criteria), which <code>EmailAddress</code> should be used?
     */
    public final ConflictResolution conflictResolution() {
        return conflictResolution;
    }

    /**
     * <p>
     * A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching
     * group to be merged during the auto-merge process. A higher score means higher similarity required to merge
     * profiles.
     * </p>
     * 
     * @return A number between 0 and 1 that represents the minimum confidence score required for profiles within a
     *         matching group to be merged during the auto-merge process. A higher score means higher similarity
     *         required to merge profiles.
     */
    public final Double minAllowedConfidenceScoreForMerging() {
        return minAllowedConfidenceScoreForMerging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(consolidation());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolution());
        hashCode = 31 * hashCode + Objects.hashCode(minAllowedConfidenceScoreForMerging());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMerging)) {
            return false;
        }
        AutoMerging other = (AutoMerging) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(consolidation(), other.consolidation())
                && Objects.equals(conflictResolution(), other.conflictResolution())
                && Objects.equals(minAllowedConfidenceScoreForMerging(), other.minAllowedConfidenceScoreForMerging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMerging").add("Enabled", enabled()).add("Consolidation", consolidation())
                .add("ConflictResolution", conflictResolution())
                .add("MinAllowedConfidenceScoreForMerging", minAllowedConfidenceScoreForMerging()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Consolidation":
            return Optional.ofNullable(clazz.cast(consolidation()));
        case "ConflictResolution":
            return Optional.ofNullable(clazz.cast(conflictResolution()));
        case "MinAllowedConfidenceScoreForMerging":
            return Optional.ofNullable(clazz.cast(minAllowedConfidenceScoreForMerging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("Consolidation", CONSOLIDATION_FIELD);
        map.put("ConflictResolution", CONFLICT_RESOLUTION_FIELD);
        map.put("MinAllowedConfidenceScoreForMerging", MIN_ALLOWED_CONFIDENCE_SCORE_FOR_MERGING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMerging, T> g) {
        return obj -> g.apply((AutoMerging) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMerging> {
        /**
         * <p>
         * The flag that enables the auto-merging of duplicate profiles.
         * </p>
         * 
         * @param enabled
         *        The flag that enables the auto-merging of duplicate profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A list of matching attributes that represent matching criteria. If two profiles meet at least one of the
         * requirements in the matching attributes list, they will be merged.
         * </p>
         * 
         * @param consolidation
         *        A list of matching attributes that represent matching criteria. If two profiles meet at least one of
         *        the requirements in the matching attributes list, they will be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consolidation(Consolidation consolidation);

        /**
         * <p>
         * A list of matching attributes that represent matching criteria. If two profiles meet at least one of the
         * requirements in the matching attributes list, they will be merged.
         * </p>
         * This is a convenience method that creates an instance of the {@link Consolidation.Builder} avoiding the need
         * to create one manually via {@link Consolidation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Consolidation.Builder#build()} is called immediately and its
         * result is passed to {@link #consolidation(Consolidation)}.
         * 
         * @param consolidation
         *        a consumer that will call methods on {@link Consolidation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consolidation(Consolidation)
         */
        default Builder consolidation(Consumer<Consolidation.Builder> consolidation) {
            return consolidation(Consolidation.builder().applyMutation(consolidation).build());
        }

        /**
         * <p>
         * How the auto-merging process should resolve conflicts between different profiles. For example, if Profile A
         * and Profile B have the same <code>FirstName</code> and <code>LastName</code> (and that is the matching
         * criteria), which <code>EmailAddress</code> should be used?
         * </p>
         * 
         * @param conflictResolution
         *        How the auto-merging process should resolve conflicts between different profiles. For example, if
         *        Profile A and Profile B have the same <code>FirstName</code> and <code>LastName</code> (and that is
         *        the matching criteria), which <code>EmailAddress</code> should be used?
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictResolution(ConflictResolution conflictResolution);

        /**
         * <p>
         * How the auto-merging process should resolve conflicts between different profiles. For example, if Profile A
         * and Profile B have the same <code>FirstName</code> and <code>LastName</code> (and that is the matching
         * criteria), which <code>EmailAddress</code> should be used?
         * </p>
         * This is a convenience method that creates an instance of the {@link ConflictResolution.Builder} avoiding the
         * need to create one manually via {@link ConflictResolution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConflictResolution.Builder#build()} is called immediately and its
         * result is passed to {@link #conflictResolution(ConflictResolution)}.
         * 
         * @param conflictResolution
         *        a consumer that will call methods on {@link ConflictResolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictResolution(ConflictResolution)
         */
        default Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return conflictResolution(ConflictResolution.builder().applyMutation(conflictResolution).build());
        }

        /**
         * <p>
         * A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching
         * group to be merged during the auto-merge process. A higher score means higher similarity required to merge
         * profiles.
         * </p>
         * 
         * @param minAllowedConfidenceScoreForMerging
         *        A number between 0 and 1 that represents the minimum confidence score required for profiles within a
         *        matching group to be merged during the auto-merge process. A higher score means higher similarity
         *        required to merge profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAllowedConfidenceScoreForMerging(Double minAllowedConfidenceScoreForMerging);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Consolidation consolidation;

        private ConflictResolution conflictResolution;

        private Double minAllowedConfidenceScoreForMerging;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMerging model) {
            enabled(model.enabled);
            consolidation(model.consolidation);
            conflictResolution(model.conflictResolution);
            minAllowedConfidenceScoreForMerging(model.minAllowedConfidenceScoreForMerging);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Consolidation.Builder getConsolidation() {
            return consolidation != null ? consolidation.toBuilder() : null;
        }

        public final void setConsolidation(Consolidation.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(Consolidation consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return conflictResolution != null ? conflictResolution.toBuilder() : null;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final Double getMinAllowedConfidenceScoreForMerging() {
            return minAllowedConfidenceScoreForMerging;
        }

        public final void setMinAllowedConfidenceScoreForMerging(Double minAllowedConfidenceScoreForMerging) {
            this.minAllowedConfidenceScoreForMerging = minAllowedConfidenceScoreForMerging;
        }

        @Override
        public final Builder minAllowedConfidenceScoreForMerging(Double minAllowedConfidenceScoreForMerging) {
            this.minAllowedConfidenceScoreForMerging = minAllowedConfidenceScoreForMerging;
            return this;
        }

        @Override
        public AutoMerging build() {
            return new AutoMerging(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
