/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error object describing why a specific profile and calculated attribute failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCalculatedAttributeForProfileError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetCalculatedAttributeForProfileError.Builder, BatchGetCalculatedAttributeForProfileError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(BatchGetCalculatedAttributeForProfileError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(BatchGetCalculatedAttributeForProfileError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(BatchGetCalculatedAttributeForProfileError::profileId))
            .setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD,
            PROFILE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private final String profileId;

    private BatchGetCalculatedAttributeForProfileError(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.profileId = builder.profileId;
    }

    /**
     * <p>
     * Status code for why a specific profile and calculated attribute failed.
     * </p>
     * 
     * @return Status code for why a specific profile and calculated attribute failed.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * Message describing why a specific profile and calculated attribute failed.
     * </p>
     * 
     * @return Message describing why a specific profile and calculated attribute failed.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The profile id that failed.
     * </p>
     * 
     * @return The profile id that failed.
     */
    public final String profileId() {
        return profileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCalculatedAttributeForProfileError)) {
            return false;
        }
        BatchGetCalculatedAttributeForProfileError other = (BatchGetCalculatedAttributeForProfileError) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(message(), other.message())
                && Objects.equals(profileId(), other.profileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCalculatedAttributeForProfileError").add("Code", code()).add("Message", message())
                .add("ProfileId", profileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCalculatedAttributeForProfileError, T> g) {
        return obj -> g.apply((BatchGetCalculatedAttributeForProfileError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetCalculatedAttributeForProfileError> {
        /**
         * <p>
         * Status code for why a specific profile and calculated attribute failed.
         * </p>
         * 
         * @param code
         *        Status code for why a specific profile and calculated attribute failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Message describing why a specific profile and calculated attribute failed.
         * </p>
         * 
         * @param message
         *        Message describing why a specific profile and calculated attribute failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The profile id that failed.
         * </p>
         * 
         * @param profileId
         *        The profile id that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private String profileId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCalculatedAttributeForProfileError model) {
            code(model.code);
            message(model.message);
            profileId(model.profileId);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        @Override
        public BatchGetCalculatedAttributeForProfileError build() {
            return new BatchGetCalculatedAttributeForProfileError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
