/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetProfileResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<BatchGetProfileResponse.Builder, BatchGetProfileResponse> {
    private static final SdkField<List<BatchGetProfileError>> ERRORS_FIELD = SdkField
            .<List<BatchGetProfileError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetProfileResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetProfileError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetProfileError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Profile>> PROFILES_FIELD = SdkField
            .<List<Profile>> builder(MarshallingType.LIST)
            .memberName("Profiles")
            .getter(getter(BatchGetProfileResponse::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Profile> builder(MarshallingType.SDK_POJO)
                                            .constructor(Profile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, PROFILES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetProfileError> errors;

    private final List<Profile> profiles;

    private BatchGetProfileResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.profiles = builder.profiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For information about the errors that are common to all actions, see <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/CommonErrors.html">Common Errors</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return For information about the errors that are common to all actions, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/CommonErrors.html">Common Errors</a>.
     */
    public final List<BatchGetProfileError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of Profile Objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return Array of Profile Objects.
     */
    public final List<Profile> profiles() {
        return profiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetProfileResponse)) {
            return false;
        }
        BatchGetProfileResponse other = (BatchGetProfileResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasProfiles() == other.hasProfiles() && Objects.equals(profiles(), other.profiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetProfileResponse").add("Errors", hasErrors() ? errors() : null)
                .add("Profiles", hasProfiles() ? profiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Errors", ERRORS_FIELD);
        map.put("Profiles", PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetProfileResponse, T> g) {
        return obj -> g.apply((BatchGetProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetProfileResponse> {
        /**
         * <p>
         * For information about the errors that are common to all actions, see <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * </p>
         * 
         * @param errors
         *        For information about the errors that are common to all actions, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetProfileError> errors);

        /**
         * <p>
         * For information about the errors that are common to all actions, see <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * </p>
         * 
         * @param errors
         *        For information about the errors that are common to all actions, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetProfileError... errors);

        /**
         * <p>
         * For information about the errors that are common to all actions, see <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchGetProfileError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetProfileError>)
         */
        Builder errors(Consumer<BatchGetProfileError.Builder>... errors);

        /**
         * <p>
         * Array of Profile Objects.
         * </p>
         * 
         * @param profiles
         *        Array of Profile Objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<Profile> profiles);

        /**
         * <p>
         * Array of Profile Objects.
         * </p>
         * 
         * @param profiles
         *        Array of Profile Objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Profile... profiles);

        /**
         * <p>
         * Array of Profile Objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.Profile.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.customerprofiles.model.Profile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.Profile.Builder#build()} is called immediately
         * and its result is passed to {@link #profiles(List<Profile>)}.
         * 
         * @param profiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.Profile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profiles(java.util.Collection<Profile>)
         */
        Builder profiles(Consumer<Profile.Builder>... profiles);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private List<BatchGetProfileError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<Profile> profiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetProfileResponse model) {
            super(model);
            errors(model.errors);
            profiles(model.profiles);
        }

        public final List<BatchGetProfileError.Builder> getErrors() {
            List<BatchGetProfileError.Builder> result = BatchGetProfileErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetProfileError.BuilderImpl> errors) {
            this.errors = BatchGetProfileErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetProfileError> errors) {
            this.errors = BatchGetProfileErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetProfileError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetProfileError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetProfileError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Profile.Builder> getProfiles() {
            List<Profile.Builder> result = ProfileListCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<Profile.BuilderImpl> profiles) {
            this.profiles = ProfileListCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<Profile> profiles) {
            this.profiles = ProfileListCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Profile... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<Profile.Builder>... profiles) {
            profiles(Stream.of(profiles).map(c -> Profile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetProfileResponse build() {
            return new BatchGetProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
