/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that segments on Customer Profile's Calculated Attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculatedAttributeDimension implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculatedAttributeDimension.Builder, CalculatedAttributeDimension> {
    private static final SdkField<String> DIMENSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionType").getter(getter(CalculatedAttributeDimension::dimensionTypeAsString))
            .setter(setter(Builder::dimensionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionType").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(CalculatedAttributeDimension::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConditionOverrides> CONDITION_OVERRIDES_FIELD = SdkField
            .<ConditionOverrides> builder(MarshallingType.SDK_POJO).memberName("ConditionOverrides")
            .getter(getter(CalculatedAttributeDimension::conditionOverrides)).setter(setter(Builder::conditionOverrides))
            .constructor(ConditionOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionOverrides").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_TYPE_FIELD,
            VALUES_FIELD, CONDITION_OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimensionType;

    private final List<String> values;

    private final ConditionOverrides conditionOverrides;

    private CalculatedAttributeDimension(BuilderImpl builder) {
        this.dimensionType = builder.dimensionType;
        this.values = builder.values;
        this.conditionOverrides = builder.conditionOverrides;
    }

    /**
     * <p>
     * The action to segment with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimensionType}
     * will return {@link AttributeDimensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dimensionTypeAsString}.
     * </p>
     * 
     * @return The action to segment with.
     * @see AttributeDimensionType
     */
    public final AttributeDimensionType dimensionType() {
        return AttributeDimensionType.fromValue(dimensionType);
    }

    /**
     * <p>
     * The action to segment with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimensionType}
     * will return {@link AttributeDimensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dimensionTypeAsString}.
     * </p>
     * 
     * @return The action to segment with.
     * @see AttributeDimensionType
     */
    public final String dimensionTypeAsString() {
        return dimensionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values to apply the DimensionType with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values to apply the DimensionType with.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * Applies the given condition over the initial Calculated Attribute's definition.
     * </p>
     * 
     * @return Applies the given condition over the initial Calculated Attribute's definition.
     */
    public final ConditionOverrides conditionOverrides() {
        return conditionOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conditionOverrides());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedAttributeDimension)) {
            return false;
        }
        CalculatedAttributeDimension other = (CalculatedAttributeDimension) obj;
        return Objects.equals(dimensionTypeAsString(), other.dimensionTypeAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(conditionOverrides(), other.conditionOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculatedAttributeDimension").add("DimensionType", dimensionTypeAsString())
                .add("Values", hasValues() ? values() : null)
                .add("ConditionOverrides", conditionOverrides() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionType":
            return Optional.ofNullable(clazz.cast(dimensionTypeAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "ConditionOverrides":
            return Optional.ofNullable(clazz.cast(conditionOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DimensionType", DIMENSION_TYPE_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("ConditionOverrides", CONDITION_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculatedAttributeDimension, T> g) {
        return obj -> g.apply((CalculatedAttributeDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculatedAttributeDimension> {
        /**
         * <p>
         * The action to segment with.
         * </p>
         * 
         * @param dimensionType
         *        The action to segment with.
         * @see AttributeDimensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeDimensionType
         */
        Builder dimensionType(String dimensionType);

        /**
         * <p>
         * The action to segment with.
         * </p>
         * 
         * @param dimensionType
         *        The action to segment with.
         * @see AttributeDimensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeDimensionType
         */
        Builder dimensionType(AttributeDimensionType dimensionType);

        /**
         * <p>
         * The values to apply the DimensionType with.
         * </p>
         * 
         * @param values
         *        The values to apply the DimensionType with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values to apply the DimensionType with.
         * </p>
         * 
         * @param values
         *        The values to apply the DimensionType with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * Applies the given condition over the initial Calculated Attribute's definition.
         * </p>
         * 
         * @param conditionOverrides
         *        Applies the given condition over the initial Calculated Attribute's definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionOverrides(ConditionOverrides conditionOverrides);

        /**
         * <p>
         * Applies the given condition over the initial Calculated Attribute's definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionOverrides.Builder} avoiding the
         * need to create one manually via {@link ConditionOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #conditionOverrides(ConditionOverrides)}.
         * 
         * @param conditionOverrides
         *        a consumer that will call methods on {@link ConditionOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionOverrides(ConditionOverrides)
         */
        default Builder conditionOverrides(Consumer<ConditionOverrides.Builder> conditionOverrides) {
            return conditionOverrides(ConditionOverrides.builder().applyMutation(conditionOverrides).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dimensionType;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private ConditionOverrides conditionOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedAttributeDimension model) {
            dimensionType(model.dimensionType);
            values(model.values);
            conditionOverrides(model.conditionOverrides);
        }

        public final String getDimensionType() {
            return dimensionType;
        }

        public final void setDimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
        }

        @Override
        public final Builder dimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
            return this;
        }

        @Override
        public final Builder dimensionType(AttributeDimensionType dimensionType) {
            this.dimensionType(dimensionType == null ? null : dimensionType.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final ConditionOverrides.Builder getConditionOverrides() {
            return conditionOverrides != null ? conditionOverrides.toBuilder() : null;
        }

        public final void setConditionOverrides(ConditionOverrides.BuilderImpl conditionOverrides) {
            this.conditionOverrides = conditionOverrides != null ? conditionOverrides.build() : null;
        }

        @Override
        public final Builder conditionOverrides(ConditionOverrides conditionOverrides) {
            this.conditionOverrides = conditionOverrides;
            return this;
        }

        @Override
        public CalculatedAttributeDimension build() {
            return new CalculatedAttributeDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
