/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditions including range, object count, and threshold for the calculated attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Conditions implements SdkPojo, Serializable, ToCopyableBuilder<Conditions.Builder, Conditions> {
    private static final SdkField<Range> RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO).memberName("Range")
            .getter(getter(Conditions::range)).setter(setter(Builder::range)).constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final SdkField<Integer> OBJECT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ObjectCount").getter(getter(Conditions::objectCount)).setter(setter(Builder::objectCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectCount").build()).build();

    private static final SdkField<Threshold> THRESHOLD_FIELD = SdkField.<Threshold> builder(MarshallingType.SDK_POJO)
            .memberName("Threshold").getter(getter(Conditions::threshold)).setter(setter(Builder::threshold))
            .constructor(Threshold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGE_FIELD,
            OBJECT_COUNT_FIELD, THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Range range;

    private final Integer objectCount;

    private final Threshold threshold;

    private Conditions(BuilderImpl builder) {
        this.range = builder.range;
        this.objectCount = builder.objectCount;
        this.threshold = builder.threshold;
    }

    /**
     * <p>
     * The relative time period over which data is included in the aggregation.
     * </p>
     * 
     * @return The relative time period over which data is included in the aggregation.
     */
    public final Range range() {
        return range;
    }

    /**
     * <p>
     * The number of profile objects used for the calculated attribute.
     * </p>
     * 
     * @return The number of profile objects used for the calculated attribute.
     */
    public final Integer objectCount() {
        return objectCount;
    }

    /**
     * <p>
     * The threshold for the calculated attribute.
     * </p>
     * 
     * @return The threshold for the calculated attribute.
     */
    public final Threshold threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Conditions)) {
            return false;
        }
        Conditions other = (Conditions) obj;
        return Objects.equals(range(), other.range()) && Objects.equals(objectCount(), other.objectCount())
                && Objects.equals(threshold(), other.threshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Conditions").add("Range", range()).add("ObjectCount", objectCount())
                .add("Threshold", threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        case "ObjectCount":
            return Optional.ofNullable(clazz.cast(objectCount()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Range", RANGE_FIELD);
        map.put("ObjectCount", OBJECT_COUNT_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Conditions, T> g) {
        return obj -> g.apply((Conditions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Conditions> {
        /**
         * <p>
         * The relative time period over which data is included in the aggregation.
         * </p>
         * 
         * @param range
         *        The relative time period over which data is included in the aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(Range range);

        /**
         * <p>
         * The relative time period over which data is included in the aggregation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Range.Builder} avoiding the need to
         * create one manually via {@link Range#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #range(Range)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(Range)
         */
        default Builder range(Consumer<Range.Builder> range) {
            return range(Range.builder().applyMutation(range).build());
        }

        /**
         * <p>
         * The number of profile objects used for the calculated attribute.
         * </p>
         * 
         * @param objectCount
         *        The number of profile objects used for the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectCount(Integer objectCount);

        /**
         * <p>
         * The threshold for the calculated attribute.
         * </p>
         * 
         * @param threshold
         *        The threshold for the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Threshold threshold);

        /**
         * <p>
         * The threshold for the calculated attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link Threshold.Builder} avoiding the need to
         * create one manually via {@link Threshold#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Threshold.Builder#build()} is called immediately and its result
         * is passed to {@link #threshold(Threshold)}.
         * 
         * @param threshold
         *        a consumer that will call methods on {@link Threshold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threshold(Threshold)
         */
        default Builder threshold(Consumer<Threshold.Builder> threshold) {
            return threshold(Threshold.builder().applyMutation(threshold).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Range range;

        private Integer objectCount;

        private Threshold threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Conditions model) {
            range(model.range);
            objectCount(model.objectCount);
            threshold(model.threshold);
        }

        public final Range.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(Range.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(Range range) {
            this.range = range;
            return this;
        }

        public final Integer getObjectCount() {
            return objectCount;
        }

        public final void setObjectCount(Integer objectCount) {
            this.objectCount = objectCount;
        }

        @Override
        public final Builder objectCount(Integer objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final Threshold.Builder getThreshold() {
            return threshold != null ? threshold.toBuilder() : null;
        }

        public final void setThreshold(Threshold.BuilderImpl threshold) {
            this.threshold = threshold != null ? threshold.build() : null;
        }

        @Override
        public final Builder threshold(Threshold threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public Conditions build() {
            return new Conditions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
