/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCalculatedAttributeDefinitionRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<CreateCalculatedAttributeDefinitionRequest.Builder, CreateCalculatedAttributeDefinitionRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateCalculatedAttributeDefinitionRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatedAttributeName")
            .getter(getter(CreateCalculatedAttributeDefinitionRequest::calculatedAttributeName))
            .setter(setter(Builder::calculatedAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatedAttributeName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateCalculatedAttributeDefinitionRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCalculatedAttributeDefinitionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<AttributeDetails> ATTRIBUTE_DETAILS_FIELD = SdkField
            .<AttributeDetails> builder(MarshallingType.SDK_POJO).memberName("AttributeDetails")
            .getter(getter(CreateCalculatedAttributeDefinitionRequest::attributeDetails))
            .setter(setter(Builder::attributeDetails)).constructor(AttributeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDetails").build()).build();

    private static final SdkField<Conditions> CONDITIONS_FIELD = SdkField.<Conditions> builder(MarshallingType.SDK_POJO)
            .memberName("Conditions").getter(getter(CreateCalculatedAttributeDefinitionRequest::conditions))
            .setter(setter(Builder::conditions)).constructor(Conditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build()).build();

    private static final SdkField<Filter> FILTER_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(CreateCalculatedAttributeDefinitionRequest::filter)).setter(setter(Builder::filter))
            .constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statistic").getter(getter(CreateCalculatedAttributeDefinitionRequest::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateCalculatedAttributeDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            CALCULATED_ATTRIBUTE_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ATTRIBUTE_DETAILS_FIELD, CONDITIONS_FIELD,
            FILTER_FIELD, STATISTIC_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String calculatedAttributeName;

    private final String displayName;

    private final String description;

    private final AttributeDetails attributeDetails;

    private final Conditions conditions;

    private final Filter filter;

    private final String statistic;

    private final Map<String, String> tags;

    private CreateCalculatedAttributeDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.attributeDetails = builder.attributeDetails;
        this.conditions = builder.conditions;
        this.filter = builder.filter;
        this.statistic = builder.statistic;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique name of the calculated attribute.
     * </p>
     * 
     * @return The unique name of the calculated attribute.
     */
    public final String calculatedAttributeName() {
        return calculatedAttributeName;
    }

    /**
     * <p>
     * The display name of the calculated attribute.
     * </p>
     * 
     * @return The display name of the calculated attribute.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the calculated attribute.
     * </p>
     * 
     * @return The description of the calculated attribute.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Mathematical expression and a list of attribute items specified in that expression.
     * </p>
     * 
     * @return Mathematical expression and a list of attribute items specified in that expression.
     */
    public final AttributeDetails attributeDetails() {
        return attributeDetails;
    }

    /**
     * <p>
     * The conditions including range, object count, and threshold for the calculated attribute.
     * </p>
     * 
     * @return The conditions including range, object count, and threshold for the calculated attribute.
     */
    public final Conditions conditions() {
        return conditions;
    }

    /**
     * <p>
     * Defines how to filter incoming objects to include part of the Calculated Attribute.
     * </p>
     * 
     * @return Defines how to filter incoming objects to include part of the Calculated Attribute.
     */
    public final Filter filter() {
        return filter;
    }

    /**
     * <p>
     * The aggregation operation to perform for the calculated attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The aggregation operation to perform for the calculated attribute.
     * @see Statistic
     */
    public final Statistic statistic() {
        return Statistic.fromValue(statistic);
    }

    /**
     * <p>
     * The aggregation operation to perform for the calculated attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The aggregation operation to perform for the calculated attribute.
     * @see Statistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(attributeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(conditions());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCalculatedAttributeDefinitionRequest)) {
            return false;
        }
        CreateCalculatedAttributeDefinitionRequest other = (CreateCalculatedAttributeDefinitionRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(calculatedAttributeName(), other.calculatedAttributeName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(attributeDetails(), other.attributeDetails())
                && Objects.equals(conditions(), other.conditions()) && Objects.equals(filter(), other.filter())
                && Objects.equals(statisticAsString(), other.statisticAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCalculatedAttributeDefinitionRequest").add("DomainName", domainName())
                .add("CalculatedAttributeName", calculatedAttributeName()).add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AttributeDetails", attributeDetails() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Conditions", conditions() == null ? null : "*** Sensitive Data Redacted ***").add("Filter", filter())
                .add("Statistic", statisticAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "CalculatedAttributeName":
            return Optional.ofNullable(clazz.cast(calculatedAttributeName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AttributeDetails":
            return Optional.ofNullable(clazz.cast(attributeDetails()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("CalculatedAttributeName", CALCULATED_ATTRIBUTE_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AttributeDetails", ATTRIBUTE_DETAILS_FIELD);
        map.put("Conditions", CONDITIONS_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCalculatedAttributeDefinitionRequest, T> g) {
        return obj -> g.apply((CreateCalculatedAttributeDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCalculatedAttributeDefinitionRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique name of the calculated attribute.
         * </p>
         * 
         * @param calculatedAttributeName
         *        The unique name of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedAttributeName(String calculatedAttributeName);

        /**
         * <p>
         * The display name of the calculated attribute.
         * </p>
         * 
         * @param displayName
         *        The display name of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the calculated attribute.
         * </p>
         * 
         * @param description
         *        The description of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Mathematical expression and a list of attribute items specified in that expression.
         * </p>
         * 
         * @param attributeDetails
         *        Mathematical expression and a list of attribute items specified in that expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDetails(AttributeDetails attributeDetails);

        /**
         * <p>
         * Mathematical expression and a list of attribute items specified in that expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeDetails.Builder} avoiding the
         * need to create one manually via {@link AttributeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeDetails(AttributeDetails)}.
         * 
         * @param attributeDetails
         *        a consumer that will call methods on {@link AttributeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDetails(AttributeDetails)
         */
        default Builder attributeDetails(Consumer<AttributeDetails.Builder> attributeDetails) {
            return attributeDetails(AttributeDetails.builder().applyMutation(attributeDetails).build());
        }

        /**
         * <p>
         * The conditions including range, object count, and threshold for the calculated attribute.
         * </p>
         * 
         * @param conditions
         *        The conditions including range, object count, and threshold for the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Conditions conditions);

        /**
         * <p>
         * The conditions including range, object count, and threshold for the calculated attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link Conditions.Builder} avoiding the need to
         * create one manually via {@link Conditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Conditions.Builder#build()} is called immediately and its result
         * is passed to {@link #conditions(Conditions)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link Conditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(Conditions)
         */
        default Builder conditions(Consumer<Conditions.Builder> conditions) {
            return conditions(Conditions.builder().applyMutation(conditions).build());
        }

        /**
         * <p>
         * Defines how to filter incoming objects to include part of the Calculated Attribute.
         * </p>
         * 
         * @param filter
         *        Defines how to filter incoming objects to include part of the Calculated Attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter filter);

        /**
         * <p>
         * Defines how to filter incoming objects to include part of the Calculated Attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filter.Builder} avoiding the need to
         * create one manually via {@link Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filter(Filter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Filter)
         */
        default Builder filter(Consumer<Filter.Builder> filter) {
            return filter(Filter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The aggregation operation to perform for the calculated attribute.
         * </p>
         * 
         * @param statistic
         *        The aggregation operation to perform for the calculated attribute.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The aggregation operation to perform for the calculated attribute.
         * </p>
         * 
         * @param statistic
         *        The aggregation operation to perform for the calculated attribute.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String calculatedAttributeName;

        private String displayName;

        private String description;

        private AttributeDetails attributeDetails;

        private Conditions conditions;

        private Filter filter;

        private String statistic;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCalculatedAttributeDefinitionRequest model) {
            super(model);
            domainName(model.domainName);
            calculatedAttributeName(model.calculatedAttributeName);
            displayName(model.displayName);
            description(model.description);
            attributeDetails(model.attributeDetails);
            conditions(model.conditions);
            filter(model.filter);
            statistic(model.statistic);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getCalculatedAttributeName() {
            return calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AttributeDetails.Builder getAttributeDetails() {
            return attributeDetails != null ? attributeDetails.toBuilder() : null;
        }

        public final void setAttributeDetails(AttributeDetails.BuilderImpl attributeDetails) {
            this.attributeDetails = attributeDetails != null ? attributeDetails.build() : null;
        }

        @Override
        public final Builder attributeDetails(AttributeDetails attributeDetails) {
            this.attributeDetails = attributeDetails;
            return this;
        }

        public final Conditions.Builder getConditions() {
            return conditions != null ? conditions.toBuilder() : null;
        }

        public final void setConditions(Conditions.BuilderImpl conditions) {
            this.conditions = conditions != null ? conditions.build() : null;
        }

        @Override
        public final Builder conditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public final Filter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCalculatedAttributeDefinitionRequest build() {
            return new CreateCalculatedAttributeDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
