/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventTriggerRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<CreateEventTriggerRequest.Builder, CreateEventTriggerRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateEventTriggerRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> EVENT_TRIGGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTriggerName").getter(getter(CreateEventTriggerRequest::eventTriggerName))
            .setter(setter(Builder::eventTriggerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EventTriggerName").build()).build();

    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(CreateEventTriggerRequest::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateEventTriggerRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<EventTriggerCondition>> EVENT_TRIGGER_CONDITIONS_FIELD = SdkField
            .<List<EventTriggerCondition>> builder(MarshallingType.LIST)
            .memberName("EventTriggerConditions")
            .getter(getter(CreateEventTriggerRequest::eventTriggerConditions))
            .setter(setter(Builder::eventTriggerConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTriggerCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTriggerCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEGMENT_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentFilter").getter(getter(CreateEventTriggerRequest::segmentFilter))
            .setter(setter(Builder::segmentFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentFilter").build()).build();

    private static final SdkField<EventTriggerLimits> EVENT_TRIGGER_LIMITS_FIELD = SdkField
            .<EventTriggerLimits> builder(MarshallingType.SDK_POJO).memberName("EventTriggerLimits")
            .getter(getter(CreateEventTriggerRequest::eventTriggerLimits)).setter(setter(Builder::eventTriggerLimits))
            .constructor(EventTriggerLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerLimits").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateEventTriggerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            EVENT_TRIGGER_NAME_FIELD, OBJECT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, EVENT_TRIGGER_CONDITIONS_FIELD,
            SEGMENT_FILTER_FIELD, EVENT_TRIGGER_LIMITS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String eventTriggerName;

    private final String objectTypeName;

    private final String description;

    private final List<EventTriggerCondition> eventTriggerConditions;

    private final String segmentFilter;

    private final EventTriggerLimits eventTriggerLimits;

    private final Map<String, String> tags;

    private CreateEventTriggerRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.eventTriggerName = builder.eventTriggerName;
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.eventTriggerConditions = builder.eventTriggerConditions;
        this.segmentFilter = builder.segmentFilter;
        this.eventTriggerLimits = builder.eventTriggerLimits;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique name of the event trigger.
     * </p>
     * 
     * @return The unique name of the event trigger.
     */
    public final String eventTriggerName() {
        return eventTriggerName;
    }

    /**
     * <p>
     * The unique name of the object type.
     * </p>
     * 
     * @return The unique name of the object type.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The description of the event trigger.
     * </p>
     * 
     * @return The description of the event trigger.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTriggerConditions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEventTriggerConditions() {
        return eventTriggerConditions != null && !(eventTriggerConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions that determine when an event should trigger the destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTriggerConditions} method.
     * </p>
     * 
     * @return A list of conditions that determine when an event should trigger the destination.
     */
    public final List<EventTriggerCondition> eventTriggerConditions() {
        return eventTriggerConditions;
    }

    /**
     * <p>
     * The destination is triggered only for profiles that meet the criteria of a segment definition.
     * </p>
     * 
     * @return The destination is triggered only for profiles that meet the criteria of a segment definition.
     */
    public final String segmentFilter() {
        return segmentFilter;
    }

    /**
     * <p>
     * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number
     * of invocations per profile over specific time periods.
     * </p>
     * 
     * @return Defines limits controlling whether an event triggers the destination, based on ingestion latency and the
     *         number of invocations per profile over specific time periods.
     */
    public final EventTriggerLimits eventTriggerLimits() {
        return eventTriggerLimits;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An array of key-value pairs to apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs to apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTriggerName());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTriggerConditions() ? eventTriggerConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(segmentFilter());
        hashCode = 31 * hashCode + Objects.hashCode(eventTriggerLimits());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventTriggerRequest)) {
            return false;
        }
        CreateEventTriggerRequest other = (CreateEventTriggerRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(eventTriggerName(), other.eventTriggerName())
                && Objects.equals(objectTypeName(), other.objectTypeName()) && Objects.equals(description(), other.description())
                && hasEventTriggerConditions() == other.hasEventTriggerConditions()
                && Objects.equals(eventTriggerConditions(), other.eventTriggerConditions())
                && Objects.equals(segmentFilter(), other.segmentFilter())
                && Objects.equals(eventTriggerLimits(), other.eventTriggerLimits()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventTriggerRequest").add("DomainName", domainName())
                .add("EventTriggerName", eventTriggerName()).add("ObjectTypeName", objectTypeName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventTriggerConditions", eventTriggerConditions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SegmentFilter", segmentFilter()).add("EventTriggerLimits", eventTriggerLimits())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EventTriggerName":
            return Optional.ofNullable(clazz.cast(eventTriggerName()));
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EventTriggerConditions":
            return Optional.ofNullable(clazz.cast(eventTriggerConditions()));
        case "SegmentFilter":
            return Optional.ofNullable(clazz.cast(segmentFilter()));
        case "EventTriggerLimits":
            return Optional.ofNullable(clazz.cast(eventTriggerLimits()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EventTriggerName", EVENT_TRIGGER_NAME_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EventTriggerConditions", EVENT_TRIGGER_CONDITIONS_FIELD);
        map.put("SegmentFilter", SEGMENT_FILTER_FIELD);
        map.put("EventTriggerLimits", EVENT_TRIGGER_LIMITS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEventTriggerRequest, T> g) {
        return obj -> g.apply((CreateEventTriggerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEventTriggerRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique name of the event trigger.
         * </p>
         * 
         * @param eventTriggerName
         *        The unique name of the event trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggerName(String eventTriggerName);

        /**
         * <p>
         * The unique name of the object type.
         * </p>
         * 
         * @param objectTypeName
         *        The unique name of the object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The description of the event trigger.
         * </p>
         * 
         * @param description
         *        The description of the event trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of conditions that determine when an event should trigger the destination.
         * </p>
         * 
         * @param eventTriggerConditions
         *        A list of conditions that determine when an event should trigger the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggerConditions(Collection<EventTriggerCondition> eventTriggerConditions);

        /**
         * <p>
         * A list of conditions that determine when an event should trigger the destination.
         * </p>
         * 
         * @param eventTriggerConditions
         *        A list of conditions that determine when an event should trigger the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggerConditions(EventTriggerCondition... eventTriggerConditions);

        /**
         * <p>
         * A list of conditions that determine when an event should trigger the destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerCondition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerCondition.Builder#build()} is
         * called immediately and its result is passed to {@link #eventTriggerConditions(List<EventTriggerCondition>)}.
         * 
         * @param eventTriggerConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTriggerConditions(java.util.Collection<EventTriggerCondition>)
         */
        Builder eventTriggerConditions(Consumer<EventTriggerCondition.Builder>... eventTriggerConditions);

        /**
         * <p>
         * The destination is triggered only for profiles that meet the criteria of a segment definition.
         * </p>
         * 
         * @param segmentFilter
         *        The destination is triggered only for profiles that meet the criteria of a segment definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentFilter(String segmentFilter);

        /**
         * <p>
         * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the
         * number of invocations per profile over specific time periods.
         * </p>
         * 
         * @param eventTriggerLimits
         *        Defines limits controlling whether an event triggers the destination, based on ingestion latency and
         *        the number of invocations per profile over specific time periods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggerLimits(EventTriggerLimits eventTriggerLimits);

        /**
         * <p>
         * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the
         * number of invocations per profile over specific time periods.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventTriggerLimits.Builder} avoiding the
         * need to create one manually via {@link EventTriggerLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventTriggerLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #eventTriggerLimits(EventTriggerLimits)}.
         * 
         * @param eventTriggerLimits
         *        a consumer that will call methods on {@link EventTriggerLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTriggerLimits(EventTriggerLimits)
         */
        default Builder eventTriggerLimits(Consumer<EventTriggerLimits.Builder> eventTriggerLimits) {
            return eventTriggerLimits(EventTriggerLimits.builder().applyMutation(eventTriggerLimits).build());
        }

        /**
         * <p>
         * An array of key-value pairs to apply to this resource.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs to apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String eventTriggerName;

        private String objectTypeName;

        private String description;

        private List<EventTriggerCondition> eventTriggerConditions = DefaultSdkAutoConstructList.getInstance();

        private String segmentFilter;

        private EventTriggerLimits eventTriggerLimits;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventTriggerRequest model) {
            super(model);
            domainName(model.domainName);
            eventTriggerName(model.eventTriggerName);
            objectTypeName(model.objectTypeName);
            description(model.description);
            eventTriggerConditions(model.eventTriggerConditions);
            segmentFilter(model.segmentFilter);
            eventTriggerLimits(model.eventTriggerLimits);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEventTriggerName() {
            return eventTriggerName;
        }

        public final void setEventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
        }

        @Override
        public final Builder eventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
            return this;
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventTriggerCondition.Builder> getEventTriggerConditions() {
            List<EventTriggerCondition.Builder> result = EventTriggerConditionsCopier.copyToBuilder(this.eventTriggerConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTriggerConditions(Collection<EventTriggerCondition.BuilderImpl> eventTriggerConditions) {
            this.eventTriggerConditions = EventTriggerConditionsCopier.copyFromBuilder(eventTriggerConditions);
        }

        @Override
        public final Builder eventTriggerConditions(Collection<EventTriggerCondition> eventTriggerConditions) {
            this.eventTriggerConditions = EventTriggerConditionsCopier.copy(eventTriggerConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerConditions(EventTriggerCondition... eventTriggerConditions) {
            eventTriggerConditions(Arrays.asList(eventTriggerConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerConditions(Consumer<EventTriggerCondition.Builder>... eventTriggerConditions) {
            eventTriggerConditions(Stream.of(eventTriggerConditions)
                    .map(c -> EventTriggerCondition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSegmentFilter() {
            return segmentFilter;
        }

        public final void setSegmentFilter(String segmentFilter) {
            this.segmentFilter = segmentFilter;
        }

        @Override
        public final Builder segmentFilter(String segmentFilter) {
            this.segmentFilter = segmentFilter;
            return this;
        }

        public final EventTriggerLimits.Builder getEventTriggerLimits() {
            return eventTriggerLimits != null ? eventTriggerLimits.toBuilder() : null;
        }

        public final void setEventTriggerLimits(EventTriggerLimits.BuilderImpl eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits != null ? eventTriggerLimits.build() : null;
        }

        @Override
        public final Builder eventTriggerLimits(EventTriggerLimits eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventTriggerRequest build() {
            return new CreateEventTriggerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
