/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntegrationWorkflowRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<CreateIntegrationWorkflowRequest.Builder, CreateIntegrationWorkflowRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateIntegrationWorkflowRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowType").getter(getter(CreateIntegrationWorkflowRequest::workflowTypeAsString))
            .setter(setter(Builder::workflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowType").build()).build();

    private static final SdkField<IntegrationConfig> INTEGRATION_CONFIG_FIELD = SdkField
            .<IntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("IntegrationConfig")
            .getter(getter(CreateIntegrationWorkflowRequest::integrationConfig)).setter(setter(Builder::integrationConfig))
            .constructor(IntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationConfig").build()).build();

    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(CreateIntegrationWorkflowRequest::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateIntegrationWorkflowRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateIntegrationWorkflowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            WORKFLOW_TYPE_FIELD, INTEGRATION_CONFIG_FIELD, OBJECT_TYPE_NAME_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String workflowType;

    private final IntegrationConfig integrationConfig;

    private final String objectTypeName;

    private final String roleArn;

    private final Map<String, String> tags;

    private CreateIntegrationWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.workflowType = builder.workflowType;
        this.integrationConfig = builder.integrationConfig;
        this.objectTypeName = builder.objectTypeName;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(workflowType);
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final String workflowTypeAsString() {
        return workflowType;
    }

    /**
     * <p>
     * Configuration data for integration workflow.
     * </p>
     * 
     * @return Configuration data for integration workflow.
     */
    public final IntegrationConfig integrationConfig() {
        return integrationConfig;
    }

    /**
     * <p>
     * The name of the profile object type.
     * </p>
     * 
     * @return The name of the profile object type.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your
     * behalf as part of workflow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources
     *         on your behalf as part of workflow execution.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationWorkflowRequest)) {
            return false;
        }
        CreateIntegrationWorkflowRequest other = (CreateIntegrationWorkflowRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(workflowTypeAsString(), other.workflowTypeAsString())
                && Objects.equals(integrationConfig(), other.integrationConfig())
                && Objects.equals(objectTypeName(), other.objectTypeName()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIntegrationWorkflowRequest").add("DomainName", domainName())
                .add("WorkflowType", workflowTypeAsString()).add("IntegrationConfig", integrationConfig())
                .add("ObjectTypeName", objectTypeName()).add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "WorkflowType":
            return Optional.ofNullable(clazz.cast(workflowTypeAsString()));
        case "IntegrationConfig":
            return Optional.ofNullable(clazz.cast(integrationConfig()));
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("WorkflowType", WORKFLOW_TYPE_FIELD);
        map.put("IntegrationConfig", INTEGRATION_CONFIG_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationWorkflowRequest, T> g) {
        return obj -> g.apply((CreateIntegrationWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIntegrationWorkflowRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(String workflowType);

        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * Configuration data for integration workflow.
         * </p>
         * 
         * @param integrationConfig
         *        Configuration data for integration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationConfig(IntegrationConfig integrationConfig);

        /**
         * <p>
         * Configuration data for integration workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegrationConfig.Builder} avoiding the
         * need to create one manually via {@link IntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegrationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #integrationConfig(IntegrationConfig)}.
         * 
         * @param integrationConfig
         *        a consumer that will call methods on {@link IntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationConfig(IntegrationConfig)
         */
        default Builder integrationConfig(Consumer<IntegrationConfig.Builder> integrationConfig) {
            return integrationConfig(IntegrationConfig.builder().applyMutation(integrationConfig).build());
        }

        /**
         * <p>
         * The name of the profile object type.
         * </p>
         * 
         * @param objectTypeName
         *        The name of the profile object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on
         * your behalf as part of workflow execution.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create
         *        resources on your behalf as part of workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String workflowType;

        private IntegrationConfig integrationConfig;

        private String objectTypeName;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationWorkflowRequest model) {
            super(model);
            domainName(model.domainName);
            workflowType(model.workflowType);
            integrationConfig(model.integrationConfig);
            objectTypeName(model.objectTypeName);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getWorkflowType() {
            return workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final IntegrationConfig.Builder getIntegrationConfig() {
            return integrationConfig != null ? integrationConfig.toBuilder() : null;
        }

        public final void setIntegrationConfig(IntegrationConfig.BuilderImpl integrationConfig) {
            this.integrationConfig = integrationConfig != null ? integrationConfig.build() : null;
        }

        @Override
        public final Builder integrationConfig(IntegrationConfig integrationConfig) {
            this.integrationConfig = integrationConfig;
            return this;
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationWorkflowRequest build() {
            return new CreateIntegrationWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
