/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the Kinesis data stream
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationSummary.Builder, DestinationSummary> {
    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uri")
            .getter(getter(DestinationSummary::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DestinationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UNHEALTHY_SINCE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UnhealthySince").getter(getter(DestinationSummary::unhealthySince))
            .setter(setter(Builder::unhealthySince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthySince").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD, STATUS_FIELD,
            UNHEALTHY_SINCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String uri;

    private final String status;

    private final Instant unhealthySince;

    private DestinationSummary(BuilderImpl builder) {
        this.uri = builder.uri;
        this.status = builder.status;
        this.unhealthySince = builder.unhealthySince;
    }

    /**
     * <p>
     * The StreamARN of the destination to deliver profile events to. For example,
     * arn:aws:kinesis:region:account-id:stream/stream-name.
     * </p>
     * 
     * @return The StreamARN of the destination to deliver profile events to. For example,
     *         arn:aws:kinesis:region:account-id:stream/stream-name.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The status of enabling the Kinesis stream as a destination for export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EventStreamDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of enabling the Kinesis stream as a destination for export.
     * @see EventStreamDestinationStatus
     */
    public final EventStreamDestinationStatus status() {
        return EventStreamDestinationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of enabling the Kinesis stream as a destination for export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EventStreamDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of enabling the Kinesis stream as a destination for export.
     * @see EventStreamDestinationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the status last changed to <code>UNHEALHY</code>.
     * </p>
     * 
     * @return The timestamp when the status last changed to <code>UNHEALHY</code>.
     */
    public final Instant unhealthySince() {
        return unhealthySince;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthySince());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationSummary)) {
            return false;
        }
        DestinationSummary other = (DestinationSummary) obj;
        return Objects.equals(uri(), other.uri()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(unhealthySince(), other.unhealthySince());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationSummary").add("Uri", uri()).add("Status", statusAsString())
                .add("UnhealthySince", unhealthySince()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UnhealthySince":
            return Optional.ofNullable(clazz.cast(unhealthySince()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Uri", URI_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("UnhealthySince", UNHEALTHY_SINCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationSummary, T> g) {
        return obj -> g.apply((DestinationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationSummary> {
        /**
         * <p>
         * The StreamARN of the destination to deliver profile events to. For example,
         * arn:aws:kinesis:region:account-id:stream/stream-name.
         * </p>
         * 
         * @param uri
         *        The StreamARN of the destination to deliver profile events to. For example,
         *        arn:aws:kinesis:region:account-id:stream/stream-name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The status of enabling the Kinesis stream as a destination for export.
         * </p>
         * 
         * @param status
         *        The status of enabling the Kinesis stream as a destination for export.
         * @see EventStreamDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStreamDestinationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of enabling the Kinesis stream as a destination for export.
         * </p>
         * 
         * @param status
         *        The status of enabling the Kinesis stream as a destination for export.
         * @see EventStreamDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStreamDestinationStatus
         */
        Builder status(EventStreamDestinationStatus status);

        /**
         * <p>
         * The timestamp when the status last changed to <code>UNHEALHY</code>.
         * </p>
         * 
         * @param unhealthySince
         *        The timestamp when the status last changed to <code>UNHEALHY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthySince(Instant unhealthySince);
    }

    static final class BuilderImpl implements Builder {
        private String uri;

        private String status;

        private Instant unhealthySince;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationSummary model) {
            uri(model.uri);
            status(model.status);
            unhealthySince(model.unhealthySince);
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EventStreamDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUnhealthySince() {
            return unhealthySince;
        }

        public final void setUnhealthySince(Instant unhealthySince) {
            this.unhealthySince = unhealthySince;
        }

        @Override
        public final Builder unhealthySince(Instant unhealthySince) {
            this.unhealthySince = unhealthySince;
            return this;
        }

        @Override
        public DestinationSummary build() {
            return new DestinationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
