/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the circumstances under which the event should trigger the destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTriggerCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<EventTriggerCondition.Builder, EventTriggerCondition> {
    private static final SdkField<List<EventTriggerDimension>> EVENT_TRIGGER_DIMENSIONS_FIELD = SdkField
            .<List<EventTriggerDimension>> builder(MarshallingType.LIST)
            .memberName("EventTriggerDimensions")
            .getter(getter(EventTriggerCondition::eventTriggerDimensions))
            .setter(setter(Builder::eventTriggerDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTriggerDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTriggerDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalOperator").getter(getter(EventTriggerCondition::logicalOperatorAsString))
            .setter(setter(Builder::logicalOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVENT_TRIGGER_DIMENSIONS_FIELD, LOGICAL_OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EventTriggerDimension> eventTriggerDimensions;

    private final String logicalOperator;

    private EventTriggerCondition(BuilderImpl builder) {
        this.eventTriggerDimensions = builder.eventTriggerDimensions;
        this.logicalOperator = builder.logicalOperator;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTriggerDimensions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEventTriggerDimensions() {
        return eventTriggerDimensions != null && !(eventTriggerDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dimensions to be evaluated for the event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTriggerDimensions} method.
     * </p>
     * 
     * @return A list of dimensions to be evaluated for the event.
     */
    public final List<EventTriggerDimension> eventTriggerDimensions() {
        return eventTriggerDimensions;
    }

    /**
     * <p>
     * The operator used to combine multiple dimensions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link EventTriggerLogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return The operator used to combine multiple dimensions.
     * @see EventTriggerLogicalOperator
     */
    public final EventTriggerLogicalOperator logicalOperator() {
        return EventTriggerLogicalOperator.fromValue(logicalOperator);
    }

    /**
     * <p>
     * The operator used to combine multiple dimensions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link EventTriggerLogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return The operator used to combine multiple dimensions.
     * @see EventTriggerLogicalOperator
     */
    public final String logicalOperatorAsString() {
        return logicalOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTriggerDimensions() ? eventTriggerDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logicalOperatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTriggerCondition)) {
            return false;
        }
        EventTriggerCondition other = (EventTriggerCondition) obj;
        return hasEventTriggerDimensions() == other.hasEventTriggerDimensions()
                && Objects.equals(eventTriggerDimensions(), other.eventTriggerDimensions())
                && Objects.equals(logicalOperatorAsString(), other.logicalOperatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTriggerCondition")
                .add("EventTriggerDimensions", hasEventTriggerDimensions() ? eventTriggerDimensions() : null)
                .add("LogicalOperator", logicalOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventTriggerDimensions":
            return Optional.ofNullable(clazz.cast(eventTriggerDimensions()));
        case "LogicalOperator":
            return Optional.ofNullable(clazz.cast(logicalOperatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventTriggerDimensions", EVENT_TRIGGER_DIMENSIONS_FIELD);
        map.put("LogicalOperator", LOGICAL_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTriggerCondition, T> g) {
        return obj -> g.apply((EventTriggerCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTriggerCondition> {
        /**
         * <p>
         * A list of dimensions to be evaluated for the event.
         * </p>
         * 
         * @param eventTriggerDimensions
         *        A list of dimensions to be evaluated for the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggerDimensions(Collection<EventTriggerDimension> eventTriggerDimensions);

        /**
         * <p>
         * A list of dimensions to be evaluated for the event.
         * </p>
         * 
         * @param eventTriggerDimensions
         *        A list of dimensions to be evaluated for the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggerDimensions(EventTriggerDimension... eventTriggerDimensions);

        /**
         * <p>
         * A list of dimensions to be evaluated for the event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerDimension.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerDimension.Builder#build()} is
         * called immediately and its result is passed to {@link #eventTriggerDimensions(List<EventTriggerDimension>)}.
         * 
         * @param eventTriggerDimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.EventTriggerDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTriggerDimensions(java.util.Collection<EventTriggerDimension>)
         */
        Builder eventTriggerDimensions(Consumer<EventTriggerDimension.Builder>... eventTriggerDimensions);

        /**
         * <p>
         * The operator used to combine multiple dimensions.
         * </p>
         * 
         * @param logicalOperator
         *        The operator used to combine multiple dimensions.
         * @see EventTriggerLogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventTriggerLogicalOperator
         */
        Builder logicalOperator(String logicalOperator);

        /**
         * <p>
         * The operator used to combine multiple dimensions.
         * </p>
         * 
         * @param logicalOperator
         *        The operator used to combine multiple dimensions.
         * @see EventTriggerLogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventTriggerLogicalOperator
         */
        Builder logicalOperator(EventTriggerLogicalOperator logicalOperator);
    }

    static final class BuilderImpl implements Builder {
        private List<EventTriggerDimension> eventTriggerDimensions = DefaultSdkAutoConstructList.getInstance();

        private String logicalOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTriggerCondition model) {
            eventTriggerDimensions(model.eventTriggerDimensions);
            logicalOperator(model.logicalOperator);
        }

        public final List<EventTriggerDimension.Builder> getEventTriggerDimensions() {
            List<EventTriggerDimension.Builder> result = EventTriggerDimensionsCopier.copyToBuilder(this.eventTriggerDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTriggerDimensions(Collection<EventTriggerDimension.BuilderImpl> eventTriggerDimensions) {
            this.eventTriggerDimensions = EventTriggerDimensionsCopier.copyFromBuilder(eventTriggerDimensions);
        }

        @Override
        public final Builder eventTriggerDimensions(Collection<EventTriggerDimension> eventTriggerDimensions) {
            this.eventTriggerDimensions = EventTriggerDimensionsCopier.copy(eventTriggerDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerDimensions(EventTriggerDimension... eventTriggerDimensions) {
            eventTriggerDimensions(Arrays.asList(eventTriggerDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerDimensions(Consumer<EventTriggerDimension.Builder>... eventTriggerDimensions) {
            eventTriggerDimensions(Stream.of(eventTriggerDimensions)
                    .map(c -> EventTriggerDimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLogicalOperator() {
            return logicalOperator;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(EventTriggerLogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        @Override
        public EventTriggerCondition build() {
            return new EventTriggerCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
