/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines how to filter the objects coming in for calculated attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> INCLUDE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Include")
            .getter(getter(Filter::includeAsString)).setter(setter(Builder::include))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build()).build();

    private static final SdkField<List<FilterGroup>> GROUPS_FIELD = SdkField
            .<List<FilterGroup>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(Filter::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD, GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String include;

    private final List<FilterGroup> groups;

    private Filter(BuilderImpl builder) {
        this.include = builder.include;
        this.groups = builder.groups;
    }

    /**
     * <p>
     * Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter groups
     * criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #include} will
     * return {@link Include#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includeAsString}.
     * </p>
     * 
     * @return Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter
     *         groups criteria.
     * @see Include
     */
    public final Include include() {
        return Include.fromValue(include);
    }

    /**
     * <p>
     * Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter groups
     * criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #include} will
     * return {@link Include#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includeAsString}.
     * </p>
     * 
     * @return Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter
     *         groups criteria.
     * @see Include
     */
    public final String includeAsString() {
        return include;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Holds the list of Filter groups within the Filter definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Holds the list of Filter groups within the Filter definition.
     */
    public final List<FilterGroup> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(includeAsString(), other.includeAsString()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Include", includeAsString()).add("Groups", hasGroups() ? groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Include":
            return Optional.ofNullable(clazz.cast(includeAsString()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Include", INCLUDE_FIELD);
        map.put("Groups", GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter groups
         * criteria.
         * </p>
         * 
         * @param include
         *        Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter
         *        groups criteria.
         * @see Include
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Include
         */
        Builder include(String include);

        /**
         * <p>
         * Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter groups
         * criteria.
         * </p>
         * 
         * @param include
         *        Define whether to include or exclude objects for Calculated Attributed calculation that fit the filter
         *        groups criteria.
         * @see Include
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Include
         */
        Builder include(Include include);

        /**
         * <p>
         * Holds the list of Filter groups within the Filter definition.
         * </p>
         * 
         * @param groups
         *        Holds the list of Filter groups within the Filter definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<FilterGroup> groups);

        /**
         * <p>
         * Holds the list of Filter groups within the Filter definition.
         * </p>
         * 
         * @param groups
         *        Holds the list of Filter groups within the Filter definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(FilterGroup... groups);

        /**
         * <p>
         * Holds the list of Filter groups within the Filter definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.FilterGroup.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.customerprofiles.model.FilterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.FilterGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #groups(List<FilterGroup>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.FilterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<FilterGroup>)
         */
        Builder groups(Consumer<FilterGroup.Builder>... groups);
    }

    static final class BuilderImpl implements Builder {
        private String include;

        private List<FilterGroup> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            include(model.include);
            groups(model.groups);
        }

        public final String getInclude() {
            return include;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public final Builder include(Include include) {
            this.include(include == null ? null : include.toString());
            return this;
        }

        public final List<FilterGroup.Builder> getGroups() {
            List<FilterGroup.Builder> result = GroupListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<FilterGroup.BuilderImpl> groups) {
            this.groups = GroupListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<FilterGroup> groups) {
            this.groups = GroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(FilterGroup... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<FilterGroup.Builder>... groups) {
            groups(Stream.of(groups).map(c -> FilterGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
