/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentMembershipRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<GetSegmentMembershipRequest.Builder, GetSegmentMembershipRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetSegmentMembershipRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentDefinitionName").getter(getter(GetSegmentMembershipRequest::segmentDefinitionName))
            .setter(setter(Builder::segmentDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SegmentDefinitionName").build())
            .build();

    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProfileIds")
            .getter(getter(GetSegmentMembershipRequest::profileIds))
            .setter(setter(Builder::profileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SEGMENT_DEFINITION_NAME_FIELD, PROFILE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String segmentDefinitionName;

    private final List<String> profileIds;

    private GetSegmentMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.profileIds = builder.profileIds;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The Id of the wanted segment. Needs to be a valid, and existing segment Id.
     * </p>
     * 
     * @return The Id of the wanted segment. Needs to be a valid, and existing segment Id.
     */
    public final String segmentDefinitionName() {
        return segmentDefinitionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfileIds() {
        return profileIds != null && !(profileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of profile IDs to query for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileIds} method.
     * </p>
     * 
     * @return The list of profile IDs to query for.
     */
    public final List<String> profileIds() {
        return profileIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileIds() ? profileIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentMembershipRequest)) {
            return false;
        }
        GetSegmentMembershipRequest other = (GetSegmentMembershipRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(segmentDefinitionName(), other.segmentDefinitionName())
                && hasProfileIds() == other.hasProfileIds() && Objects.equals(profileIds(), other.profileIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSegmentMembershipRequest").add("DomainName", domainName())
                .add("SegmentDefinitionName", segmentDefinitionName()).add("ProfileIds", hasProfileIds() ? profileIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "SegmentDefinitionName":
            return Optional.ofNullable(clazz.cast(segmentDefinitionName()));
        case "ProfileIds":
            return Optional.ofNullable(clazz.cast(profileIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
        map.put("ProfileIds", PROFILE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentMembershipRequest, T> g) {
        return obj -> g.apply((GetSegmentMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSegmentMembershipRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The Id of the wanted segment. Needs to be a valid, and existing segment Id.
         * </p>
         * 
         * @param segmentDefinitionName
         *        The Id of the wanted segment. Needs to be a valid, and existing segment Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDefinitionName(String segmentDefinitionName);

        /**
         * <p>
         * The list of profile IDs to query for.
         * </p>
         * 
         * @param profileIds
         *        The list of profile IDs to query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(Collection<String> profileIds);

        /**
         * <p>
         * The list of profile IDs to query for.
         * </p>
         * 
         * @param profileIds
         *        The list of profile IDs to query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(String... profileIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String segmentDefinitionName;

        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentMembershipRequest model) {
            super(model);
            domainName(model.domainName);
            segmentDefinitionName(model.segmentDefinitionName);
            profileIds(model.profileIds);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getSegmentDefinitionName() {
            return segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final Collection<String> getProfileIds() {
            if (profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return profileIds;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdsCopier.copy(profileIds);
        }

        @Override
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdsCopier.copy(profileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIds(String... profileIds) {
            profileIds(Arrays.asList(profileIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSegmentMembershipRequest build() {
            return new GetSegmentMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
