/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentSnapshotRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<GetSegmentSnapshotRequest.Builder, GetSegmentSnapshotRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetSegmentSnapshotRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentDefinitionName").getter(getter(GetSegmentSnapshotRequest::segmentDefinitionName))
            .setter(setter(Builder::segmentDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SegmentDefinitionName").build())
            .build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(GetSegmentSnapshotRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SnapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SEGMENT_DEFINITION_NAME_FIELD, SNAPSHOT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String segmentDefinitionName;

    private final String snapshotId;

    private GetSegmentSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The unique identifier of the domain.
     * </p>
     * 
     * @return The unique identifier of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique name of the segment definition.
     * </p>
     * 
     * @return The unique name of the segment definition.
     */
    public final String segmentDefinitionName() {
        return segmentDefinitionName;
    }

    /**
     * <p>
     * The unique identifier of the segment snapshot.
     * </p>
     * 
     * @return The unique identifier of the segment snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentSnapshotRequest)) {
            return false;
        }
        GetSegmentSnapshotRequest other = (GetSegmentSnapshotRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(segmentDefinitionName(), other.segmentDefinitionName())
                && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSegmentSnapshotRequest").add("DomainName", domainName())
                .add("SegmentDefinitionName", segmentDefinitionName()).add("SnapshotId", snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "SegmentDefinitionName":
            return Optional.ofNullable(clazz.cast(segmentDefinitionName()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentSnapshotRequest, T> g) {
        return obj -> g.apply((GetSegmentSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSegmentSnapshotRequest> {
        /**
         * <p>
         * The unique identifier of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique identifier of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique name of the segment definition.
         * </p>
         * 
         * @param segmentDefinitionName
         *        The unique name of the segment definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDefinitionName(String segmentDefinitionName);

        /**
         * <p>
         * The unique identifier of the segment snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The unique identifier of the segment snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String segmentDefinitionName;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentSnapshotRequest model) {
            super(model);
            domainName(model.domainName);
            segmentDefinitionName(model.segmentDefinitionName);
            snapshotId(model.snapshotId);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getSegmentDefinitionName() {
            return segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSegmentSnapshotRequest build() {
            return new GetSegmentSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
