/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowStepsResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetWorkflowStepsResponse.Builder, GetWorkflowStepsResponse> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(GetWorkflowStepsResponse::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowType").getter(getter(GetWorkflowStepsResponse::workflowTypeAsString))
            .setter(setter(Builder::workflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowType").build()).build();

    private static final SdkField<List<WorkflowStepItem>> ITEMS_FIELD = SdkField
            .<List<WorkflowStepItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(GetWorkflowStepsResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowStepItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowStepItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetWorkflowStepsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            WORKFLOW_TYPE_FIELD, ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowId;

    private final String workflowType;

    private final List<WorkflowStepItem> items;

    private final String nextToken;

    private GetWorkflowStepsResponse(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Unique identifier for the workflow.
     * </p>
     * 
     * @return Unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(workflowType);
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final String workflowTypeAsString() {
        return workflowType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List containing workflow step details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return List containing workflow step details.
     */
    public final List<WorkflowStepItem> items() {
        return items;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowStepsResponse)) {
            return false;
        }
        GetWorkflowStepsResponse other = (GetWorkflowStepsResponse) obj;
        return Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(workflowTypeAsString(), other.workflowTypeAsString()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowStepsResponse").add("WorkflowId", workflowId())
                .add("WorkflowType", workflowTypeAsString()).add("Items", hasItems() ? items() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "WorkflowType":
            return Optional.ofNullable(clazz.cast(workflowTypeAsString()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("WorkflowType", WORKFLOW_TYPE_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowStepsResponse, T> g) {
        return obj -> g.apply((GetWorkflowStepsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkflowStepsResponse> {
        /**
         * <p>
         * Unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        Unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(String workflowType);

        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * List containing workflow step details.
         * </p>
         * 
         * @param items
         *        List containing workflow step details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<WorkflowStepItem> items);

        /**
         * <p>
         * List containing workflow step details.
         * </p>
         * 
         * @param items
         *        List containing workflow step details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(WorkflowStepItem... items);

        /**
         * <p>
         * List containing workflow step details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.WorkflowStepItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.WorkflowStepItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.WorkflowStepItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<WorkflowStepItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.WorkflowStepItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<WorkflowStepItem>)
         */
        Builder items(Consumer<WorkflowStepItem.Builder>... items);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String workflowId;

        private String workflowType;

        private List<WorkflowStepItem> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowStepsResponse model) {
            super(model);
            workflowId(model.workflowId);
            workflowType(model.workflowType);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final List<WorkflowStepItem.Builder> getItems() {
            List<WorkflowStepItem.Builder> result = WorkflowStepsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<WorkflowStepItem.BuilderImpl> items) {
            this.items = WorkflowStepsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<WorkflowStepItem> items) {
            this.items = WorkflowStepsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(WorkflowStepItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<WorkflowStepItem.Builder>... items) {
            items(Stream.of(items).map(c -> WorkflowStepItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetWorkflowStepsResponse build() {
            return new GetWorkflowStepsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
