/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration used when importing incremental records from the source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncrementalPullConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IncrementalPullConfig.Builder, IncrementalPullConfig> {
    private static final SdkField<String> DATETIME_TYPE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatetimeTypeFieldName").getter(getter(IncrementalPullConfig::datetimeTypeFieldName))
            .setter(setter(Builder::datetimeTypeFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatetimeTypeFieldName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATETIME_TYPE_FIELD_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datetimeTypeFieldName;

    private IncrementalPullConfig(BuilderImpl builder) {
        this.datetimeTypeFieldName = builder.datetimeTypeFieldName;
    }

    /**
     * <p>
     * A field that specifies the date time or timestamp field as the criteria to use when importing incremental records
     * from the source.
     * </p>
     * 
     * @return A field that specifies the date time or timestamp field as the criteria to use when importing incremental
     *         records from the source.
     */
    public final String datetimeTypeFieldName() {
        return datetimeTypeFieldName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datetimeTypeFieldName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncrementalPullConfig)) {
            return false;
        }
        IncrementalPullConfig other = (IncrementalPullConfig) obj;
        return Objects.equals(datetimeTypeFieldName(), other.datetimeTypeFieldName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncrementalPullConfig").add("DatetimeTypeFieldName", datetimeTypeFieldName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatetimeTypeFieldName":
            return Optional.ofNullable(clazz.cast(datetimeTypeFieldName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatetimeTypeFieldName", DATETIME_TYPE_FIELD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncrementalPullConfig, T> g) {
        return obj -> g.apply((IncrementalPullConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncrementalPullConfig> {
        /**
         * <p>
         * A field that specifies the date time or timestamp field as the criteria to use when importing incremental
         * records from the source.
         * </p>
         * 
         * @param datetimeTypeFieldName
         *        A field that specifies the date time or timestamp field as the criteria to use when importing
         *        incremental records from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datetimeTypeFieldName(String datetimeTypeFieldName);
    }

    static final class BuilderImpl implements Builder {
        private String datetimeTypeFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(IncrementalPullConfig model) {
            datetimeTypeFieldName(model.datetimeTypeFieldName);
        }

        public final String getDatetimeTypeFieldName() {
            return datetimeTypeFieldName;
        }

        public final void setDatetimeTypeFieldName(String datetimeTypeFieldName) {
            this.datetimeTypeFieldName = datetimeTypeFieldName;
        }

        @Override
        public final Builder datetimeTypeFieldName(String datetimeTypeFieldName) {
            this.datetimeTypeFieldName = datetimeTypeFieldName;
            return this;
        }

        @Override
        public IncrementalPullConfig build() {
            return new IncrementalPullConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
