/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfileAttributeValuesResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<ListProfileAttributeValuesResponse.Builder, ListProfileAttributeValuesResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(ListProfileAttributeValuesResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(ListProfileAttributeValuesResponse::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<List<AttributeValueItem>> ITEMS_FIELD = SdkField
            .<List<AttributeValueItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(ListProfileAttributeValuesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeValueItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValueItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(ListProfileAttributeValuesResponse::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ATTRIBUTE_NAME_FIELD, ITEMS_FIELD, STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String attributeName;

    private final List<AttributeValueItem> items;

    private final Integer statusCode;

    private ListProfileAttributeValuesResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.attributeName = builder.attributeName;
        this.items = builder.items;
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The attribute name.
     * </p>
     * 
     * @return The attribute name.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The items returned as part of the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The items returned as part of the response.
     */
    public final List<AttributeValueItem> items() {
        return items;
    }

    /**
     * <p>
     * The status code for the response.
     * </p>
     * 
     * @return The status code for the response.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileAttributeValuesResponse)) {
            return false;
        }
        ListProfileAttributeValuesResponse other = (ListProfileAttributeValuesResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(attributeName(), other.attributeName())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfileAttributeValuesResponse").add("DomainName", domainName())
                .add("AttributeName", attributeName()).add("Items", hasItems() ? items() : null).add("StatusCode", statusCode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileAttributeValuesResponse, T> g) {
        return obj -> g.apply((ListProfileAttributeValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProfileAttributeValuesResponse> {
        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The attribute name.
         * </p>
         * 
         * @param attributeName
         *        The attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The items returned as part of the response.
         * </p>
         * 
         * @param items
         *        The items returned as part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<AttributeValueItem> items);

        /**
         * <p>
         * The items returned as part of the response.
         * </p>
         * 
         * @param items
         *        The items returned as part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(AttributeValueItem... items);

        /**
         * <p>
         * The items returned as part of the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.AttributeValueItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.AttributeValueItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.AttributeValueItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<AttributeValueItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.AttributeValueItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<AttributeValueItem>)
         */
        Builder items(Consumer<AttributeValueItem.Builder>... items);

        /**
         * <p>
         * The status code for the response.
         * </p>
         * 
         * @param statusCode
         *        The status code for the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String domainName;

        private String attributeName;

        private List<AttributeValueItem> items = DefaultSdkAutoConstructList.getInstance();

        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileAttributeValuesResponse model) {
            super(model);
            domainName(model.domainName);
            attributeName(model.attributeName);
            items(model.items);
            statusCode(model.statusCode);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final List<AttributeValueItem.Builder> getItems() {
            List<AttributeValueItem.Builder> result = AttributeValueItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AttributeValueItem.BuilderImpl> items) {
            this.items = AttributeValueItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AttributeValueItem> items) {
            this.items = AttributeValueItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AttributeValueItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AttributeValueItem.Builder>... items) {
            items(Stream.of(items).map(c -> AttributeValueItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public ListProfileAttributeValuesResponse build() {
            return new ListProfileAttributeValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
