/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workflow in list of workflows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowsItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ListWorkflowsItem.Builder, ListWorkflowsItem> {
    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowType").getter(getter(ListWorkflowsItem::workflowTypeAsString))
            .setter(setter(Builder::workflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowType").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(ListWorkflowsItem::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListWorkflowsItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDescription").getter(getter(ListWorkflowsItem::statusDescription))
            .setter(setter(Builder::statusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ListWorkflowsItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(ListWorkflowsItem::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TYPE_FIELD,
            WORKFLOW_ID_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workflowType;

    private final String workflowId;

    private final String status;

    private final String statusDescription;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private ListWorkflowsItem(BuilderImpl builder) {
        this.workflowType = builder.workflowType;
        this.workflowId = builder.workflowId;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(workflowType);
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final String workflowTypeAsString() {
        return workflowType;
    }

    /**
     * <p>
     * Unique identifier for the workflow.
     * </p>
     * 
     * @return Unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * Status of workflow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of workflow execution.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Status of workflow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of workflow execution.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Description for workflow execution status.
     * </p>
     * 
     * @return Description for workflow execution status.
     */
    public final String statusDescription() {
        return statusDescription;
    }

    /**
     * <p>
     * Creation timestamp for workflow.
     * </p>
     * 
     * @return Creation timestamp for workflow.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Last updated timestamp for workflow.
     * </p>
     * 
     * @return Last updated timestamp for workflow.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsItem)) {
            return false;
        }
        ListWorkflowsItem other = (ListWorkflowsItem) obj;
        return Objects.equals(workflowTypeAsString(), other.workflowTypeAsString())
                && Objects.equals(workflowId(), other.workflowId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDescription(), other.statusDescription())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkflowsItem").add("WorkflowType", workflowTypeAsString()).add("WorkflowId", workflowId())
                .add("Status", statusAsString()).add("StatusDescription", statusDescription()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowType":
            return Optional.ofNullable(clazz.cast(workflowTypeAsString()));
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDescription":
            return Optional.ofNullable(clazz.cast(statusDescription()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowType", WORKFLOW_TYPE_FIELD);
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusDescription", STATUS_DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowsItem, T> g) {
        return obj -> g.apply((ListWorkflowsItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListWorkflowsItem> {
        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(String workflowType);

        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * Unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        Unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * Status of workflow execution.
         * </p>
         * 
         * @param status
         *        Status of workflow execution.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Status of workflow execution.
         * </p>
         * 
         * @param status
         *        Status of workflow execution.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Description for workflow execution status.
         * </p>
         * 
         * @param statusDescription
         *        Description for workflow execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDescription(String statusDescription);

        /**
         * <p>
         * Creation timestamp for workflow.
         * </p>
         * 
         * @param createdAt
         *        Creation timestamp for workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Last updated timestamp for workflow.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Last updated timestamp for workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String workflowType;

        private String workflowId;

        private String status;

        private String statusDescription;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowsItem model) {
            workflowType(model.workflowType);
            workflowId(model.workflowId);
            status(model.status);
            statusDescription(model.statusDescription);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getWorkflowType() {
            return workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDescription() {
            return statusDescription;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public ListWorkflowsItem build() {
            return new ListWorkflowsItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
