/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that holds the results for membership.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileQueryResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileQueryResult.Builder, ProfileQueryResult> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(ProfileQueryResult::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> QUERY_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryResult").getter(getter(ProfileQueryResult::queryResultAsString))
            .setter(setter(Builder::queryResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResult").build()).build();

    private static final SdkField<Profile> PROFILE_FIELD = SdkField.<Profile> builder(MarshallingType.SDK_POJO)
            .memberName("Profile").getter(getter(ProfileQueryResult::profile)).setter(setter(Builder::profile))
            .constructor(Profile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD,
            QUERY_RESULT_FIELD, PROFILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String profileId;

    private final String queryResult;

    private final Profile profile;

    private ProfileQueryResult(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.queryResult = builder.queryResult;
        this.profile = builder.profile;
    }

    /**
     * <p>
     * The profile id the result belongs to.
     * </p>
     * 
     * @return The profile id the result belongs to.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Describes whether the profile was absent or present in the segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryResult} will
     * return {@link QueryResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryResultAsString}.
     * </p>
     * 
     * @return Describes whether the profile was absent or present in the segment.
     * @see QueryResult
     */
    public final QueryResult queryResult() {
        return QueryResult.fromValue(queryResult);
    }

    /**
     * <p>
     * Describes whether the profile was absent or present in the segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryResult} will
     * return {@link QueryResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryResultAsString}.
     * </p>
     * 
     * @return Describes whether the profile was absent or present in the segment.
     * @see QueryResult
     */
    public final String queryResultAsString() {
        return queryResult;
    }

    /**
     * Returns the value of the Profile property for this object.
     * 
     * @return The value of the Profile property for this object.
     */
    public final Profile profile() {
        return profile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(queryResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileQueryResult)) {
            return false;
        }
        ProfileQueryResult other = (ProfileQueryResult) obj;
        return Objects.equals(profileId(), other.profileId())
                && Objects.equals(queryResultAsString(), other.queryResultAsString())
                && Objects.equals(profile(), other.profile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileQueryResult").add("ProfileId", profileId()).add("QueryResult", queryResultAsString())
                .add("Profile", profile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "QueryResult":
            return Optional.ofNullable(clazz.cast(queryResultAsString()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("QueryResult", QUERY_RESULT_FIELD);
        map.put("Profile", PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileQueryResult, T> g) {
        return obj -> g.apply((ProfileQueryResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileQueryResult> {
        /**
         * <p>
         * The profile id the result belongs to.
         * </p>
         * 
         * @param profileId
         *        The profile id the result belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Describes whether the profile was absent or present in the segment.
         * </p>
         * 
         * @param queryResult
         *        Describes whether the profile was absent or present in the segment.
         * @see QueryResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResult
         */
        Builder queryResult(String queryResult);

        /**
         * <p>
         * Describes whether the profile was absent or present in the segment.
         * </p>
         * 
         * @param queryResult
         *        Describes whether the profile was absent or present in the segment.
         * @see QueryResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResult
         */
        Builder queryResult(QueryResult queryResult);

        /**
         * Sets the value of the Profile property for this object.
         *
         * @param profile
         *        The new value for the Profile property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profile(Profile profile);

        /**
         * Sets the value of the Profile property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Profile.Builder} avoiding the need to
         * create one manually via {@link Profile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Profile.Builder#build()} is called immediately and its result is
         * passed to {@link #profile(Profile)}.
         * 
         * @param profile
         *        a consumer that will call methods on {@link Profile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profile(Profile)
         */
        default Builder profile(Consumer<Profile.Builder> profile) {
            return profile(Profile.builder().applyMutation(profile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String profileId;

        private String queryResult;

        private Profile profile;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileQueryResult model) {
            profileId(model.profileId);
            queryResult(model.queryResult);
            profile(model.profile);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getQueryResult() {
            return queryResult;
        }

        public final void setQueryResult(String queryResult) {
            this.queryResult = queryResult;
        }

        @Override
        public final Builder queryResult(String queryResult) {
            this.queryResult = queryResult;
            return this;
        }

        @Override
        public final Builder queryResult(QueryResult queryResult) {
            this.queryResult(queryResult == null ? null : queryResult.toString());
            return this;
        }

        public final Profile.Builder getProfile() {
            return profile != null ? profile.toBuilder() : null;
        }

        public final void setProfile(Profile.BuilderImpl profile) {
            this.profile = profile != null ? profile.build() : null;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public ProfileQueryResult build() {
            return new ProfileQueryResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
