/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Overrides the original range on a calculated attribute definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RangeOverride implements SdkPojo, Serializable, ToCopyableBuilder<RangeOverride.Builder, RangeOverride> {
    private static final SdkField<Integer> START_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Start")
            .getter(getter(RangeOverride::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<Integer> END_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("End")
            .getter(getter(RangeOverride::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(RangeOverride::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD,
            UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer start;

    private final Integer end;

    private final String unit;

    private RangeOverride(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The start time of when to include objects.
     * </p>
     * 
     * @return The start time of when to include objects.
     */
    public final Integer start() {
        return start;
    }

    /**
     * <p>
     * The end time of when to include objects.
     * </p>
     * 
     * @return The end time of when to include objects.
     */
    public final Integer end() {
        return end;
    }

    /**
     * <p>
     * The unit for start and end.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link RangeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for start and end.
     * @see RangeUnit
     */
    public final RangeUnit unit() {
        return RangeUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit for start and end.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link RangeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for start and end.
     * @see RangeUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RangeOverride)) {
            return false;
        }
        RangeOverride other = (RangeOverride) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RangeOverride").add("Start", start()).add("End", end()).add("Unit", unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Start", START_FIELD);
        map.put("End", END_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RangeOverride, T> g) {
        return obj -> g.apply((RangeOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RangeOverride> {
        /**
         * <p>
         * The start time of when to include objects.
         * </p>
         * 
         * @param start
         *        The start time of when to include objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Integer start);

        /**
         * <p>
         * The end time of when to include objects.
         * </p>
         * 
         * @param end
         *        The end time of when to include objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Integer end);

        /**
         * <p>
         * The unit for start and end.
         * </p>
         * 
         * @param unit
         *        The unit for start and end.
         * @see RangeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RangeUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit for start and end.
         * </p>
         * 
         * @param unit
         *        The unit for start and end.
         * @see RangeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RangeUnit
         */
        Builder unit(RangeUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Integer start;

        private Integer end;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(RangeOverride model) {
            start(model.start);
            end(model.end);
            unit(model.unit);
        }

        public final Integer getStart() {
            return start;
        }

        public final void setStart(Integer start) {
            this.start = start;
        }

        @Override
        public final Builder start(Integer start) {
            this.start = start;
            return this;
        }

        public final Integer getEnd() {
            return end;
        }

        public final void setEnd(Integer end) {
            this.end = end;
        }

        @Override
        public final Builder end(Integer end) {
            this.end = end;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(RangeUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public RangeOverride build() {
            return new RangeOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
