/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.PeriodUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Period
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Period> {
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(Period.getter(Period::unitAsString)).setter(Period.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Integer> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Value").getter(Period.getter(Period::value)).setter(Period.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Integer> MAX_INVOCATIONS_PER_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInvocationsPerProfile").getter(Period.getter(Period::maxInvocationsPerProfile)).setter(Period.setter(Builder::maxInvocationsPerProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocationsPerProfile").build()}).build();
    private static final SdkField<Boolean> UNLIMITED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Unlimited").getter(Period.getter(Period::unlimited)).setter(Period.setter(Builder::unlimited)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unlimited").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, VALUE_FIELD, MAX_INVOCATIONS_PER_PROFILE_FIELD, UNLIMITED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Period.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String unit;
    private final Integer value;
    private final Integer maxInvocationsPerProfile;
    private final Boolean unlimited;

    private Period(BuilderImpl builder) {
        this.unit = builder.unit;
        this.value = builder.value;
        this.maxInvocationsPerProfile = builder.maxInvocationsPerProfile;
        this.unlimited = builder.unlimited;
    }

    public final PeriodUnit unit() {
        return PeriodUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Integer value() {
        return this.value;
    }

    public final Integer maxInvocationsPerProfile() {
        return this.maxInvocationsPerProfile;
    }

    public final Boolean unlimited() {
        return this.unlimited;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInvocationsPerProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.unlimited());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Period)) {
            return false;
        }
        Period other = (Period)obj;
        return Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.maxInvocationsPerProfile(), other.maxInvocationsPerProfile()) && Objects.equals(this.unlimited(), other.unlimited());
    }

    public final String toString() {
        return ToString.builder((String)"Period").add("Unit", (Object)this.unitAsString()).add("Value", (Object)this.value()).add("MaxInvocationsPerProfile", (Object)this.maxInvocationsPerProfile()).add("Unlimited", (Object)this.unlimited()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "MaxInvocationsPerProfile": {
                return Optional.ofNullable(clazz.cast(this.maxInvocationsPerProfile()));
            }
            case "Unlimited": {
                return Optional.ofNullable(clazz.cast(this.unlimited()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Unit", UNIT_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("MaxInvocationsPerProfile", MAX_INVOCATIONS_PER_PROFILE_FIELD);
        map.put("Unlimited", UNLIMITED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Period, T> g) {
        return obj -> g.apply((Period)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String unit;
        private Integer value;
        private Integer maxInvocationsPerProfile;
        private Boolean unlimited;

        private BuilderImpl() {
        }

        private BuilderImpl(Period model) {
            this.unit(model.unit);
            this.value(model.value);
            this.maxInvocationsPerProfile(model.maxInvocationsPerProfile);
            this.unlimited(model.unlimited);
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(PeriodUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Integer getValue() {
            return this.value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final Integer getMaxInvocationsPerProfile() {
            return this.maxInvocationsPerProfile;
        }

        public final void setMaxInvocationsPerProfile(Integer maxInvocationsPerProfile) {
            this.maxInvocationsPerProfile = maxInvocationsPerProfile;
        }

        @Override
        public final Builder maxInvocationsPerProfile(Integer maxInvocationsPerProfile) {
            this.maxInvocationsPerProfile = maxInvocationsPerProfile;
            return this;
        }

        public final Boolean getUnlimited() {
            return this.unlimited;
        }

        public final void setUnlimited(Boolean unlimited) {
            this.unlimited = unlimited;
        }

        @Override
        public final Builder unlimited(Boolean unlimited) {
            this.unlimited = unlimited;
            return this;
        }

        public Period build() {
            return new Period(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Period> {
        public Builder unit(String var1);

        public Builder unit(PeriodUnit var1);

        public Builder value(Integer var1);

        public Builder maxInvocationsPerProfile(Integer var1);

        public Builder unlimited(Boolean var1);
    }
}

