/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CalculatedAttributeDimension;
import software.amazon.awssdk.services.customerprofiles.model.CalculatedCustomAttributesCopier;
import software.amazon.awssdk.services.customerprofiles.model.ProfileAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Dimension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Dimension> {
    private static final SdkField<ProfileAttributes> PROFILE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProfileAttributes").getter(Dimension.getter(Dimension::profileAttributes)).setter(Dimension.setter(Builder::profileAttributes)).constructor(ProfileAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileAttributes").build()}).build();
    private static final SdkField<Map<String, CalculatedAttributeDimension>> CALCULATED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CalculatedAttributes").getter(Dimension.getter(Dimension::calculatedAttributes)).setter(Dimension.setter(Builder::calculatedAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CalculatedAttributeDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ATTRIBUTES_FIELD, CALCULATED_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Dimension.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ProfileAttributes profileAttributes;
    private final Map<String, CalculatedAttributeDimension> calculatedAttributes;
    private final Type type;

    private Dimension(BuilderImpl builder) {
        this.profileAttributes = builder.profileAttributes;
        this.calculatedAttributes = builder.calculatedAttributes;
        this.type = builder.type;
    }

    public final ProfileAttributes profileAttributes() {
        return this.profileAttributes;
    }

    public final boolean hasCalculatedAttributes() {
        return this.calculatedAttributes != null && !(this.calculatedAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, CalculatedAttributeDimension> calculatedAttributes() {
        return this.calculatedAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculatedAttributes() ? this.calculatedAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension)obj;
        return Objects.equals(this.profileAttributes(), other.profileAttributes()) && this.hasCalculatedAttributes() == other.hasCalculatedAttributes() && Objects.equals(this.calculatedAttributes(), other.calculatedAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"Dimension").add("ProfileAttributes", (Object)(this.profileAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("CalculatedAttributes", this.hasCalculatedAttributes() ? this.calculatedAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileAttributes": {
                return Optional.ofNullable(clazz.cast(this.profileAttributes()));
            }
            case "CalculatedAttributes": {
                return Optional.ofNullable(clazz.cast(this.calculatedAttributes()));
            }
        }
        return Optional.empty();
    }

    public static Dimension fromProfileAttributes(ProfileAttributes profileAttributes) {
        return (Dimension)Dimension.builder().profileAttributes(profileAttributes).build();
    }

    public static Dimension fromProfileAttributes(Consumer<ProfileAttributes.Builder> profileAttributes) {
        ProfileAttributes.Builder builder = ProfileAttributes.builder();
        profileAttributes.accept(builder);
        return Dimension.fromProfileAttributes((ProfileAttributes)builder.build());
    }

    public static Dimension fromCalculatedAttributes(Map<String, CalculatedAttributeDimension> calculatedAttributes) {
        return (Dimension)Dimension.builder().calculatedAttributes(calculatedAttributes).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProfileAttributes", PROFILE_ATTRIBUTES_FIELD);
        map.put("CalculatedAttributes", CALCULATED_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Dimension, T> g) {
        return obj -> g.apply((Dimension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROFILE_ATTRIBUTES,
        CALCULATED_ATTRIBUTES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ProfileAttributes profileAttributes;
        private Map<String, CalculatedAttributeDimension> calculatedAttributes = DefaultSdkAutoConstructMap.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Dimension model) {
            this.profileAttributes(model.profileAttributes);
            this.calculatedAttributes(model.calculatedAttributes);
        }

        public final ProfileAttributes.Builder getProfileAttributes() {
            return this.profileAttributes != null ? this.profileAttributes.toBuilder() : null;
        }

        public final void setProfileAttributes(ProfileAttributes.BuilderImpl profileAttributes) {
            ProfileAttributes oldValue = this.profileAttributes;
            this.profileAttributes = profileAttributes != null ? profileAttributes.build() : null;
            this.handleUnionValueChange(Type.PROFILE_ATTRIBUTES, oldValue, this.profileAttributes);
        }

        @Override
        public final Builder profileAttributes(ProfileAttributes profileAttributes) {
            ProfileAttributes oldValue = this.profileAttributes;
            this.profileAttributes = profileAttributes;
            this.handleUnionValueChange(Type.PROFILE_ATTRIBUTES, oldValue, this.profileAttributes);
            return this;
        }

        public final Map<String, CalculatedAttributeDimension.Builder> getCalculatedAttributes() {
            Map<String, CalculatedAttributeDimension.Builder> result = CalculatedCustomAttributesCopier.copyToBuilder(this.calculatedAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCalculatedAttributes(Map<String, CalculatedAttributeDimension.BuilderImpl> calculatedAttributes) {
            Map<String, CalculatedAttributeDimension> oldValue = this.calculatedAttributes;
            this.calculatedAttributes = CalculatedCustomAttributesCopier.copyFromBuilder(calculatedAttributes);
            this.handleUnionValueChange(Type.CALCULATED_ATTRIBUTES, oldValue, this.calculatedAttributes);
        }

        @Override
        public final Builder calculatedAttributes(Map<String, CalculatedAttributeDimension> calculatedAttributes) {
            Map<String, CalculatedAttributeDimension> oldValue = this.calculatedAttributes;
            this.calculatedAttributes = CalculatedCustomAttributesCopier.copy(calculatedAttributes);
            this.handleUnionValueChange(Type.CALCULATED_ATTRIBUTES, oldValue, this.calculatedAttributes);
            return this;
        }

        public Dimension build() {
            return new Dimension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Dimension> {
        public Builder profileAttributes(ProfileAttributes var1);

        default public Builder profileAttributes(Consumer<ProfileAttributes.Builder> profileAttributes) {
            return this.profileAttributes((ProfileAttributes)((ProfileAttributes.Builder)ProfileAttributes.builder().applyMutation(profileAttributes)).build());
        }

        public Builder calculatedAttributes(Map<String, CalculatedAttributeDimension> var1);
    }
}

