/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.AttributeDetails;
import software.amazon.awssdk.services.customerprofiles.model.Conditions;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.Filter;
import software.amazon.awssdk.services.customerprofiles.model.Statistic;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCalculatedAttributeDefinitionRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, CreateCalculatedAttributeDefinitionRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::domainName)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedAttributeName").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::calculatedAttributeName)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::calculatedAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatedAttributeName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::displayName)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::description)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AttributeDetails> ATTRIBUTE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeDetails").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::attributeDetails)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::attributeDetails)).constructor(AttributeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDetails").build()}).build();
    private static final SdkField<Conditions> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Conditions").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::conditions)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::conditions)).constructor(Conditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build()}).build();
    private static final SdkField<Filter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::filter)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::filter)).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::statisticAsString)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCalculatedAttributeDefinitionRequest.getter(CreateCalculatedAttributeDefinitionRequest::tags)).setter(CreateCalculatedAttributeDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, CALCULATED_ATTRIBUTE_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ATTRIBUTE_DETAILS_FIELD, CONDITIONS_FIELD, FILTER_FIELD, STATISTIC_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCalculatedAttributeDefinitionRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String calculatedAttributeName;
    private final String displayName;
    private final String description;
    private final AttributeDetails attributeDetails;
    private final Conditions conditions;
    private final Filter filter;
    private final String statistic;
    private final Map<String, String> tags;

    private CreateCalculatedAttributeDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.attributeDetails = builder.attributeDetails;
        this.conditions = builder.conditions;
        this.filter = builder.filter;
        this.statistic = builder.statistic;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String calculatedAttributeName() {
        return this.calculatedAttributeName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final AttributeDetails attributeDetails() {
        return this.attributeDetails;
    }

    public final Conditions conditions() {
        return this.conditions;
    }

    public final Filter filter() {
        return this.filter;
    }

    public final Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCalculatedAttributeDefinitionRequest)) {
            return false;
        }
        CreateCalculatedAttributeDefinitionRequest other = (CreateCalculatedAttributeDefinitionRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.calculatedAttributeName(), other.calculatedAttributeName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.attributeDetails(), other.attributeDetails()) && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCalculatedAttributeDefinitionRequest").add("DomainName", (Object)this.domainName()).add("CalculatedAttributeName", (Object)this.calculatedAttributeName()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("AttributeDetails", (Object)(this.attributeDetails() == null ? null : "*** Sensitive Data Redacted ***")).add("Conditions", (Object)(this.conditions() == null ? null : "*** Sensitive Data Redacted ***")).add("Filter", (Object)this.filter()).add("Statistic", (Object)(this.statisticAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "CalculatedAttributeName": {
                return Optional.ofNullable(clazz.cast(this.calculatedAttributeName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AttributeDetails": {
                return Optional.ofNullable(clazz.cast(this.attributeDetails()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("CalculatedAttributeName", CALCULATED_ATTRIBUTE_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AttributeDetails", ATTRIBUTE_DETAILS_FIELD);
        map.put("Conditions", CONDITIONS_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCalculatedAttributeDefinitionRequest, T> g) {
        return obj -> g.apply((CreateCalculatedAttributeDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String calculatedAttributeName;
        private String displayName;
        private String description;
        private AttributeDetails attributeDetails;
        private Conditions conditions;
        private Filter filter;
        private String statistic;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCalculatedAttributeDefinitionRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.calculatedAttributeName(model.calculatedAttributeName);
            this.displayName(model.displayName);
            this.description(model.description);
            this.attributeDetails(model.attributeDetails);
            this.conditions(model.conditions);
            this.filter(model.filter);
            this.statistic(model.statistic);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getCalculatedAttributeName() {
            return this.calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AttributeDetails.Builder getAttributeDetails() {
            return this.attributeDetails != null ? this.attributeDetails.toBuilder() : null;
        }

        public final void setAttributeDetails(AttributeDetails.BuilderImpl attributeDetails) {
            this.attributeDetails = attributeDetails != null ? attributeDetails.build() : null;
        }

        @Override
        public final Builder attributeDetails(AttributeDetails attributeDetails) {
            this.attributeDetails = attributeDetails;
            return this;
        }

        public final Conditions.Builder getConditions() {
            return this.conditions != null ? this.conditions.toBuilder() : null;
        }

        public final void setConditions(Conditions.BuilderImpl conditions) {
            this.conditions = conditions != null ? conditions.build() : null;
        }

        @Override
        public final Builder conditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public final Filter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCalculatedAttributeDefinitionRequest build() {
            return new CreateCalculatedAttributeDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCalculatedAttributeDefinitionRequest> {
        public Builder domainName(String var1);

        public Builder calculatedAttributeName(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder attributeDetails(AttributeDetails var1);

        default public Builder attributeDetails(Consumer<AttributeDetails.Builder> attributeDetails) {
            return this.attributeDetails((AttributeDetails)((AttributeDetails.Builder)AttributeDetails.builder().applyMutation(attributeDetails)).build());
        }

        public Builder conditions(Conditions var1);

        default public Builder conditions(Consumer<Conditions.Builder> conditions) {
            return this.conditions((Conditions)((Conditions.Builder)Conditions.builder().applyMutation(conditions)).build());
        }

        public Builder filter(Filter var1);

        default public Builder filter(Consumer<Filter.Builder> filter) {
            return this.filter((Filter)((Filter.Builder)Filter.builder().applyMutation(filter)).build());
        }

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

