/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.Group;
import software.amazon.awssdk.services.customerprofiles.model.IncludeOptions;
import software.amazon.awssdk.services.customerprofiles.model.SegmentGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentGroup> {
    private static final SdkField<List<Group>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(SegmentGroup.getter(SegmentGroup::groups)).setter(SegmentGroup.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Include").getter(SegmentGroup.getter(SegmentGroup::includeAsString)).setter(SegmentGroup.setter(Builder::include)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, INCLUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SegmentGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Group> groups;
    private final String include;

    private SegmentGroup(BuilderImpl builder) {
        this.groups = builder.groups;
        this.include = builder.include;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<Group> groups() {
        return this.groups;
    }

    public final IncludeOptions include() {
        return IncludeOptions.fromValue(this.include);
    }

    public final String includeAsString() {
        return this.include;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroup)) {
            return false;
        }
        SegmentGroup other = (SegmentGroup)obj;
        return this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.includeAsString(), other.includeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentGroup").add("Groups", this.hasGroups() ? this.groups() : null).add("Include", (Object)this.includeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.includeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Groups", GROUPS_FIELD);
        map.put("Include", INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SegmentGroup, T> g) {
        return obj -> g.apply((SegmentGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Group> groups = DefaultSdkAutoConstructList.getInstance();
        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentGroup model) {
            this.groups(model.groups);
            this.include(model.include);
        }

        public final List<Group.Builder> getGroups() {
            List<Group.Builder> result = SegmentGroupListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<Group.BuilderImpl> groups) {
            this.groups = SegmentGroupListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<Group> groups) {
            this.groups = SegmentGroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Group ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<Group.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (Group)((Group.Builder)Group.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInclude() {
            return this.include;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public final Builder include(IncludeOptions include) {
            this.include(include == null ? null : include.toString());
            return this;
        }

        public SegmentGroup build() {
            return new SegmentGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentGroup> {
        public Builder groups(Collection<Group> var1);

        public Builder groups(Group ... var1);

        public Builder groups(Consumer<Group.Builder> ... var1);

        public Builder include(String var1);

        public Builder include(IncludeOptions var1);
    }
}

