/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.SegmentGroup;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSegmentDefinitionResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetSegmentDefinitionResponse> {
    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentDefinitionName").getter(GetSegmentDefinitionResponse.getter(GetSegmentDefinitionResponse::segmentDefinitionName)).setter(GetSegmentDefinitionResponse.setter(Builder::segmentDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(GetSegmentDefinitionResponse.getter(GetSegmentDefinitionResponse::displayName)).setter(GetSegmentDefinitionResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetSegmentDefinitionResponse.getter(GetSegmentDefinitionResponse::description)).setter(GetSegmentDefinitionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<SegmentGroup> SEGMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SegmentGroups").getter(GetSegmentDefinitionResponse.getter(GetSegmentDefinitionResponse::segmentGroups)).setter(GetSegmentDefinitionResponse.setter(Builder::segmentGroups)).constructor(SegmentGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentGroups").build()}).build();
    private static final SdkField<String> SEGMENT_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentDefinitionArn").getter(GetSegmentDefinitionResponse.getter(GetSegmentDefinitionResponse::segmentDefinitionArn)).setter(GetSegmentDefinitionResponse.setter(Builder::segmentDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetSegmentDefinitionResponse.getter(GetSegmentDefinitionResponse::createdAt)).setter(GetSegmentDefinitionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetSegmentDefinitionResponse.getter(GetSegmentDefinitionResponse::tags)).setter(GetSegmentDefinitionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_DEFINITION_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, SEGMENT_GROUPS_FIELD, SEGMENT_DEFINITION_ARN_FIELD, CREATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSegmentDefinitionResponse.memberNameToFieldInitializer();
    private final String segmentDefinitionName;
    private final String displayName;
    private final String description;
    private final SegmentGroup segmentGroups;
    private final String segmentDefinitionArn;
    private final Instant createdAt;
    private final Map<String, String> tags;

    private GetSegmentDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.segmentGroups = builder.segmentGroups;
        this.segmentDefinitionArn = builder.segmentDefinitionArn;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
    }

    public final String segmentDefinitionName() {
        return this.segmentDefinitionName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final SegmentGroup segmentGroups() {
        return this.segmentGroups;
    }

    public final String segmentDefinitionArn() {
        return this.segmentDefinitionArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentDefinitionResponse)) {
            return false;
        }
        GetSegmentDefinitionResponse other = (GetSegmentDefinitionResponse)((Object)obj);
        return Objects.equals(this.segmentDefinitionName(), other.segmentDefinitionName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.segmentGroups(), other.segmentGroups()) && Objects.equals(this.segmentDefinitionArn(), other.segmentDefinitionArn()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetSegmentDefinitionResponse").add("SegmentDefinitionName", (Object)this.segmentDefinitionName()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("SegmentGroups", (Object)(this.segmentGroups() == null ? null : "*** Sensitive Data Redacted ***")).add("SegmentDefinitionArn", (Object)this.segmentDefinitionArn()).add("CreatedAt", (Object)this.createdAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.segmentDefinitionName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SegmentGroups": {
                return Optional.ofNullable(clazz.cast(this.segmentGroups()));
            }
            case "SegmentDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.segmentDefinitionArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SegmentGroups", SEGMENT_GROUPS_FIELD);
        map.put("SegmentDefinitionArn", SEGMENT_DEFINITION_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentDefinitionResponse, T> g) {
        return obj -> g.apply((GetSegmentDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String segmentDefinitionName;
        private String displayName;
        private String description;
        private SegmentGroup segmentGroups;
        private String segmentDefinitionArn;
        private Instant createdAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentDefinitionResponse model) {
            super(model);
            this.segmentDefinitionName(model.segmentDefinitionName);
            this.displayName(model.displayName);
            this.description(model.description);
            this.segmentGroups(model.segmentGroups);
            this.segmentDefinitionArn(model.segmentDefinitionArn);
            this.createdAt(model.createdAt);
            this.tags(model.tags);
        }

        public final String getSegmentDefinitionName() {
            return this.segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SegmentGroup.Builder getSegmentGroups() {
            return this.segmentGroups != null ? this.segmentGroups.toBuilder() : null;
        }

        public final void setSegmentGroups(SegmentGroup.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroup segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final String getSegmentDefinitionArn() {
            return this.segmentDefinitionArn;
        }

        public final void setSegmentDefinitionArn(String segmentDefinitionArn) {
            this.segmentDefinitionArn = segmentDefinitionArn;
        }

        @Override
        public final Builder segmentDefinitionArn(String segmentDefinitionArn) {
            this.segmentDefinitionArn = segmentDefinitionArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSegmentDefinitionResponse build() {
            return new GetSegmentDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSegmentDefinitionResponse> {
        public Builder segmentDefinitionName(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder segmentGroups(SegmentGroup var1);

        default public Builder segmentGroups(Consumer<SegmentGroup.Builder> segmentGroups) {
            return this.segmentGroups((SegmentGroup)((SegmentGroup.Builder)SegmentGroup.builder().applyMutation(segmentGroups)).build());
        }

        public Builder segmentDefinitionArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

