/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.FailuresCopier;
import software.amazon.awssdk.services.customerprofiles.model.ProfileQueryFailures;
import software.amazon.awssdk.services.customerprofiles.model.ProfileQueryResult;
import software.amazon.awssdk.services.customerprofiles.model.ProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSegmentMembershipResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetSegmentMembershipResponse> {
    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentDefinitionName").getter(GetSegmentMembershipResponse.getter(GetSegmentMembershipResponse::segmentDefinitionName)).setter(GetSegmentMembershipResponse.setter(Builder::segmentDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionName").build()}).build();
    private static final SdkField<List<ProfileQueryResult>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Profiles").getter(GetSegmentMembershipResponse.getter(GetSegmentMembershipResponse::profiles)).setter(GetSegmentMembershipResponse.setter(Builder::profiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileQueryResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProfileQueryFailures>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failures").getter(GetSegmentMembershipResponse.getter(GetSegmentMembershipResponse::failures)).setter(GetSegmentMembershipResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileQueryFailures::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_DEFINITION_NAME_FIELD, PROFILES_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSegmentMembershipResponse.memberNameToFieldInitializer();
    private final String segmentDefinitionName;
    private final List<ProfileQueryResult> profiles;
    private final List<ProfileQueryFailures> failures;

    private GetSegmentMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.profiles = builder.profiles;
        this.failures = builder.failures;
    }

    public final String segmentDefinitionName() {
        return this.segmentDefinitionName;
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructList);
    }

    public final List<ProfileQueryResult> profiles() {
        return this.profiles;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<ProfileQueryFailures> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentMembershipResponse)) {
            return false;
        }
        GetSegmentMembershipResponse other = (GetSegmentMembershipResponse)((Object)obj);
        return Objects.equals(this.segmentDefinitionName(), other.segmentDefinitionName()) && this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profiles(), other.profiles()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"GetSegmentMembershipResponse").add("SegmentDefinitionName", (Object)this.segmentDefinitionName()).add("Profiles", this.hasProfiles() ? this.profiles() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.segmentDefinitionName()));
            }
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
            case "Failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
        map.put("Profiles", PROFILES_FIELD);
        map.put("Failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentMembershipResponse, T> g) {
        return obj -> g.apply((GetSegmentMembershipResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String segmentDefinitionName;
        private List<ProfileQueryResult> profiles = DefaultSdkAutoConstructList.getInstance();
        private List<ProfileQueryFailures> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentMembershipResponse model) {
            super(model);
            this.segmentDefinitionName(model.segmentDefinitionName);
            this.profiles(model.profiles);
            this.failures(model.failures);
        }

        public final String getSegmentDefinitionName() {
            return this.segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final List<ProfileQueryResult.Builder> getProfiles() {
            List<ProfileQueryResult.Builder> result = ProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<ProfileQueryResult.BuilderImpl> profiles) {
            this.profiles = ProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<ProfileQueryResult> profiles) {
            this.profiles = ProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(ProfileQueryResult ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<ProfileQueryResult.Builder> ... profiles) {
            this.profiles(Stream.of(profiles).map(c -> (ProfileQueryResult)((ProfileQueryResult.Builder)ProfileQueryResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProfileQueryFailures.Builder> getFailures() {
            List<ProfileQueryFailures.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<ProfileQueryFailures.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<ProfileQueryFailures> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ProfileQueryFailures ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<ProfileQueryFailures.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (ProfileQueryFailures)((ProfileQueryFailures.Builder)ProfileQueryFailures.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSegmentMembershipResponse build() {
            return new GetSegmentMembershipResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSegmentMembershipResponse> {
        public Builder segmentDefinitionName(String var1);

        public Builder profiles(Collection<ProfileQueryResult> var1);

        public Builder profiles(ProfileQueryResult ... var1);

        public Builder profiles(Consumer<ProfileQueryResult.Builder> ... var1);

        public Builder failures(Collection<ProfileQueryFailures> var1);

        public Builder failures(ProfileQueryFailures ... var1);

        public Builder failures(Consumer<ProfileQueryFailures.Builder> ... var1);
    }
}

