/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerNamesCopier;
import software.amazon.awssdk.services.customerprofiles.model.FlowDefinition;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeNamesCopier;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, PutIntegrationRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(PutIntegrationRequest.getter(PutIntegrationRequest::domainName)).setter(PutIntegrationRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uri").getter(PutIntegrationRequest.getter(PutIntegrationRequest::uri)).setter(PutIntegrationRequest.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(PutIntegrationRequest.getter(PutIntegrationRequest::objectTypeName)).setter(PutIntegrationRequest.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(PutIntegrationRequest.getter(PutIntegrationRequest::tags)).setter(PutIntegrationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<FlowDefinition> FLOW_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowDefinition").getter(PutIntegrationRequest.getter(PutIntegrationRequest::flowDefinition)).setter(PutIntegrationRequest.setter(Builder::flowDefinition)).constructor(FlowDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinition").build()}).build();
    private static final SdkField<Map<String, String>> OBJECT_TYPE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ObjectTypeNames").getter(PutIntegrationRequest.getter(PutIntegrationRequest::objectTypeNames)).setter(PutIntegrationRequest.setter(Builder::objectTypeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(PutIntegrationRequest.getter(PutIntegrationRequest::roleArn)).setter(PutIntegrationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> EVENT_TRIGGER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTriggerNames").getter(PutIntegrationRequest.getter(PutIntegrationRequest::eventTriggerNames)).setter(PutIntegrationRequest.setter(Builder::eventTriggerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, URI_FIELD, OBJECT_TYPE_NAME_FIELD, TAGS_FIELD, FLOW_DEFINITION_FIELD, OBJECT_TYPE_NAMES_FIELD, ROLE_ARN_FIELD, EVENT_TRIGGER_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutIntegrationRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String uri;
    private final String objectTypeName;
    private final Map<String, String> tags;
    private final FlowDefinition flowDefinition;
    private final Map<String, String> objectTypeNames;
    private final String roleArn;
    private final List<String> eventTriggerNames;

    private PutIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.uri = builder.uri;
        this.objectTypeName = builder.objectTypeName;
        this.tags = builder.tags;
        this.flowDefinition = builder.flowDefinition;
        this.objectTypeNames = builder.objectTypeNames;
        this.roleArn = builder.roleArn;
        this.eventTriggerNames = builder.eventTriggerNames;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String uri() {
        return this.uri;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final FlowDefinition flowDefinition() {
        return this.flowDefinition;
    }

    public final boolean hasObjectTypeNames() {
        return this.objectTypeNames != null && !(this.objectTypeNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> objectTypeNames() {
        return this.objectTypeNames;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasEventTriggerNames() {
        return this.eventTriggerNames != null && !(this.eventTriggerNames instanceof SdkAutoConstructList);
    }

    public final List<String> eventTriggerNames() {
        return this.eventTriggerNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectTypeNames() ? this.objectTypeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTriggerNames() ? this.eventTriggerNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationRequest)) {
            return false;
        }
        PutIntegrationRequest other = (PutIntegrationRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.flowDefinition(), other.flowDefinition()) && this.hasObjectTypeNames() == other.hasObjectTypeNames() && Objects.equals(this.objectTypeNames(), other.objectTypeNames()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasEventTriggerNames() == other.hasEventTriggerNames() && Objects.equals(this.eventTriggerNames(), other.eventTriggerNames());
    }

    public final String toString() {
        return ToString.builder((String)"PutIntegrationRequest").add("DomainName", (Object)this.domainName()).add("Uri", (Object)this.uri()).add("ObjectTypeName", (Object)this.objectTypeName()).add("Tags", this.hasTags() ? this.tags() : null).add("FlowDefinition", (Object)(this.flowDefinition() == null ? null : "*** Sensitive Data Redacted ***")).add("ObjectTypeNames", this.hasObjectTypeNames() ? this.objectTypeNames() : null).add("RoleArn", (Object)this.roleArn()).add("EventTriggerNames", this.hasEventTriggerNames() ? this.eventTriggerNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FlowDefinition": {
                return Optional.ofNullable(clazz.cast(this.flowDefinition()));
            }
            case "ObjectTypeNames": {
                return Optional.ofNullable(clazz.cast(this.objectTypeNames()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "EventTriggerNames": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Uri", URI_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("FlowDefinition", FLOW_DEFINITION_FIELD);
        map.put("ObjectTypeNames", OBJECT_TYPE_NAMES_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("EventTriggerNames", EVENT_TRIGGER_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationRequest, T> g) {
        return obj -> g.apply((PutIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String uri;
        private String objectTypeName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private FlowDefinition flowDefinition;
        private Map<String, String> objectTypeNames = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;
        private List<String> eventTriggerNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.uri(model.uri);
            this.objectTypeName(model.objectTypeName);
            this.tags(model.tags);
            this.flowDefinition(model.flowDefinition);
            this.objectTypeNames(model.objectTypeNames);
            this.roleArn(model.roleArn);
            this.eventTriggerNames(model.eventTriggerNames);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final FlowDefinition.Builder getFlowDefinition() {
            return this.flowDefinition != null ? this.flowDefinition.toBuilder() : null;
        }

        public final void setFlowDefinition(FlowDefinition.BuilderImpl flowDefinition) {
            this.flowDefinition = flowDefinition != null ? flowDefinition.build() : null;
        }

        @Override
        public final Builder flowDefinition(FlowDefinition flowDefinition) {
            this.flowDefinition = flowDefinition;
            return this;
        }

        public final Map<String, String> getObjectTypeNames() {
            if (this.objectTypeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.objectTypeNames;
        }

        public final void setObjectTypeNames(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesCopier.copy(objectTypeNames);
        }

        @Override
        public final Builder objectTypeNames(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesCopier.copy(objectTypeNames);
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getEventTriggerNames() {
            if (this.eventTriggerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTriggerNames;
        }

        public final void setEventTriggerNames(Collection<String> eventTriggerNames) {
            this.eventTriggerNames = EventTriggerNamesCopier.copy(eventTriggerNames);
        }

        @Override
        public final Builder eventTriggerNames(Collection<String> eventTriggerNames) {
            this.eventTriggerNames = EventTriggerNamesCopier.copy(eventTriggerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerNames(String ... eventTriggerNames) {
            this.eventTriggerNames(Arrays.asList(eventTriggerNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntegrationRequest build() {
            return new PutIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntegrationRequest> {
        public Builder domainName(String var1);

        public Builder uri(String var1);

        public Builder objectTypeName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder flowDefinition(FlowDefinition var1);

        default public Builder flowDefinition(Consumer<FlowDefinition.Builder> flowDefinition) {
            return this.flowDefinition((FlowDefinition)((FlowDefinition.Builder)FlowDefinition.builder().applyMutation(flowDefinition)).build());
        }

        public Builder objectTypeNames(Map<String, String> var1);

        public Builder roleArn(String var1);

        public Builder eventTriggerNames(Collection<String> var1);

        public Builder eventTriggerNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

