/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LayoutType {
    PROFILE_EXPLORER("PROFILE_EXPLORER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LayoutType> VALUE_MAP;
    private final String value;

    private LayoutType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LayoutType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LayoutType> knownValues() {
        EnumSet<LayoutType> knownValues = EnumSet.allOf(LayoutType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LayoutType.class, LayoutType::toString);
    }
}

