/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.ContactPreference;
import software.amazon.awssdk.services.customerprofiles.model.EmailPreferenceListCopier;
import software.amazon.awssdk.services.customerprofiles.model.PhonePreferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngagementPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngagementPreferences> {
    private static final SdkField<List<ContactPreference>> PHONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phone").getter(EngagementPreferences.getter(EngagementPreferences::phone)).setter(EngagementPreferences.setter(Builder::phone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phone").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContactPreference>> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Email").getter(EngagementPreferences.getter(EngagementPreferences::email)).setter(EngagementPreferences.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_FIELD, EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EngagementPreferences.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ContactPreference> phone;
    private final List<ContactPreference> email;

    private EngagementPreferences(BuilderImpl builder) {
        this.phone = builder.phone;
        this.email = builder.email;
    }

    public final boolean hasPhone() {
        return this.phone != null && !(this.phone instanceof SdkAutoConstructList);
    }

    public final List<ContactPreference> phone() {
        return this.phone;
    }

    public final boolean hasEmail() {
        return this.email != null && !(this.email instanceof SdkAutoConstructList);
    }

    public final List<ContactPreference> email() {
        return this.email;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhone() ? this.phone() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmail() ? this.email() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementPreferences)) {
            return false;
        }
        EngagementPreferences other = (EngagementPreferences)obj;
        return this.hasPhone() == other.hasPhone() && Objects.equals(this.phone(), other.phone()) && this.hasEmail() == other.hasEmail() && Objects.equals(this.email(), other.email());
    }

    public final String toString() {
        return ToString.builder((String)"EngagementPreferences").add("Phone", this.hasPhone() ? this.phone() : null).add("Email", this.hasEmail() ? this.email() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Phone": {
                return Optional.ofNullable(clazz.cast(this.phone()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ContactPreference>>> map = new HashMap<String, SdkField<List<ContactPreference>>>();
        map.put("Phone", PHONE_FIELD);
        map.put("Email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementPreferences, T> g) {
        return obj -> g.apply((EngagementPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContactPreference> phone = DefaultSdkAutoConstructList.getInstance();
        private List<ContactPreference> email = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementPreferences model) {
            this.phone(model.phone);
            this.email(model.email);
        }

        public final List<ContactPreference.Builder> getPhone() {
            List<ContactPreference.Builder> result = PhonePreferenceListCopier.copyToBuilder(this.phone);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhone(Collection<ContactPreference.BuilderImpl> phone) {
            this.phone = PhonePreferenceListCopier.copyFromBuilder(phone);
        }

        @Override
        public final Builder phone(Collection<ContactPreference> phone) {
            this.phone = PhonePreferenceListCopier.copy(phone);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phone(ContactPreference ... phone) {
            this.phone(Arrays.asList(phone));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phone(Consumer<ContactPreference.Builder> ... phone) {
            this.phone(Stream.of(phone).map(c -> (ContactPreference)((ContactPreference.Builder)ContactPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactPreference.Builder> getEmail() {
            List<ContactPreference.Builder> result = EmailPreferenceListCopier.copyToBuilder(this.email);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmail(Collection<ContactPreference.BuilderImpl> email) {
            this.email = EmailPreferenceListCopier.copyFromBuilder(email);
        }

        @Override
        public final Builder email(Collection<ContactPreference> email) {
            this.email = EmailPreferenceListCopier.copy(email);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder email(ContactPreference ... email) {
            this.email(Arrays.asList(email));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder email(Consumer<ContactPreference.Builder> ... email) {
            this.email(Stream.of(email).map(c -> (ContactPreference)((ContactPreference.Builder)ContactPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EngagementPreferences build() {
            return new EngagementPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngagementPreferences> {
        public Builder phone(Collection<ContactPreference> var1);

        public Builder phone(ContactPreference ... var1);

        public Builder phone(Consumer<ContactPreference.Builder> ... var1);

        public Builder email(Collection<ContactPreference> var1);

        public Builder email(ContactPreference ... var1);

        public Builder email(Consumer<ContactPreference.Builder> ... var1);
    }
}

