/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.customerprofiles.model.AccessDeniedException;
import software.amazon.awssdk.services.customerprofiles.model.AddProfileKeyRequest;
import software.amazon.awssdk.services.customerprofiles.model.AddProfileKeyResponse;
import software.amazon.awssdk.services.customerprofiles.model.BadRequestException;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateDomainLayoutRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateDomainLayoutResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateEventStreamRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateEventStreamResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateEventTriggerRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateEventTriggerResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateIntegrationWorkflowRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateIntegrationWorkflowResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateSegmentDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateSegmentDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateSegmentEstimateRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateSegmentEstimateResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateSegmentSnapshotRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateSegmentSnapshotResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateUploadJobRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateUploadJobResponse;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesException;
import software.amazon.awssdk.services.customerprofiles.model.DeleteCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteDomainLayoutRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteDomainLayoutResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteEventTriggerRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteEventTriggerResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileKeyRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileKeyResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectTypeRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectTypeResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteSegmentDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteSegmentDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.customerprofiles.model.DetectProfileObjectTypeRequest;
import software.amazon.awssdk.services.customerprofiles.model.DetectProfileObjectTypeResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetAutoMergingPreviewRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetAutoMergingPreviewResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeForProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeForProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetDomainLayoutRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetDomainLayoutResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetEventStreamRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetEventStreamResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetEventTriggerRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetEventTriggerResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetIdentityResolutionJobRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetIdentityResolutionJobResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetIntegrationRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetIntegrationResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetMatchesRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetMatchesResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileHistoryRecordRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileHistoryRecordResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeTemplateRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeTemplateResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentEstimateRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentEstimateResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentMembershipRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentMembershipResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentSnapshotRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetSegmentSnapshotResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetUploadJobPathRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetUploadJobPathResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetUploadJobRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetUploadJobResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowStepsRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowStepsResponse;
import software.amazon.awssdk.services.customerprofiles.model.InternalServerException;
import software.amazon.awssdk.services.customerprofiles.model.ListAccountIntegrationsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListAccountIntegrationsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributeDefinitionsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributeDefinitionsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributesForProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributesForProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListIdentityResolutionJobsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListIdentityResolutionJobsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListIntegrationsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListIntegrationsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileAttributeValuesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileAttributeValuesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileHistoryRecordsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileHistoryRecordsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypeTemplatesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypeTemplatesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.customerprofiles.model.MergeProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.MergeProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.PutIntegrationRequest;
import software.amazon.awssdk.services.customerprofiles.model.PutIntegrationResponse;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectRequest;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectResponse;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectTypeRequest;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectTypeResponse;
import software.amazon.awssdk.services.customerprofiles.model.ResourceNotFoundException;
import software.amazon.awssdk.services.customerprofiles.model.SearchProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.SearchProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.StartUploadJobRequest;
import software.amazon.awssdk.services.customerprofiles.model.StartUploadJobResponse;
import software.amazon.awssdk.services.customerprofiles.model.StopUploadJobRequest;
import software.amazon.awssdk.services.customerprofiles.model.StopUploadJobResponse;
import software.amazon.awssdk.services.customerprofiles.model.TagResourceRequest;
import software.amazon.awssdk.services.customerprofiles.model.TagResourceResponse;
import software.amazon.awssdk.services.customerprofiles.model.ThrottlingException;
import software.amazon.awssdk.services.customerprofiles.model.UntagResourceRequest;
import software.amazon.awssdk.services.customerprofiles.model.UntagResourceResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateDomainLayoutRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateDomainLayoutResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateEventTriggerRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateEventTriggerResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateProfileResponse;
import software.amazon.awssdk.services.customerprofiles.paginators.GetSimilarProfilesIterable;
import software.amazon.awssdk.services.customerprofiles.paginators.ListDomainLayoutsIterable;
import software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable;
import software.amazon.awssdk.services.customerprofiles.paginators.ListEventTriggersIterable;
import software.amazon.awssdk.services.customerprofiles.paginators.ListObjectTypeAttributesIterable;
import software.amazon.awssdk.services.customerprofiles.paginators.ListRuleBasedMatchesIterable;
import software.amazon.awssdk.services.customerprofiles.paginators.ListSegmentDefinitionsIterable;
import software.amazon.awssdk.services.customerprofiles.paginators.ListUploadJobsIterable;

/**
 * Service client for accessing Customer Profiles. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Connect Customer Profiles</fullname>
 * <ul>
 * <li>
 * <p>
 * <a
 * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Connect_Customer_Profiles.html"
 * >Customer Profiles actions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Connect_Customer_Profiles.html">
 * Customer Profiles data types</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * Amazon Connect Customer Profiles is a unified customer profile for your contact center that has pre-built connectors
 * powered by AppFlow that make it easy to combine customer information from third party applications, such as
 * Salesforce (CRM), ServiceNow (ITSM), and your enterprise resource planning (ERP), with contact history from your
 * Amazon Connect contact center.
 * </p>
 * <p>
 * For more information about the Amazon Connect Customer Profiles feature, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/customer-profiles.html">Use Customer Profiles</a> in the
 * <i>Amazon Connect Administrator's Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CustomerProfilesClient extends AwsClient {
    String SERVICE_NAME = "profile";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "profile";

    /**
     * <p>
     * Associates a new key value with a specific profile, such as a Contact Record ContactId.
     * </p>
     * <p>
     * A profile object can have a single unique key and any number of additional keys that can be used to identify the
     * profile that it belongs to.
     * </p>
     *
     * @param addProfileKeyRequest
     * @return Result of the AddProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.AddProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default AddProfileKeyResponse addProfileKey(AddProfileKeyRequest addProfileKeyRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a new key value with a specific profile, such as a Contact Record ContactId.
     * </p>
     * <p>
     * A profile object can have a single unique key and any number of additional keys that can be used to identify the
     * profile that it belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddProfileKeyRequest.Builder} avoiding the need to
     * create one manually via {@link AddProfileKeyRequest#builder()}
     * </p>
     *
     * @param addProfileKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.AddProfileKeyRequest.Builder} to create a
     *        request.
     * @return Result of the AddProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.AddProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default AddProfileKeyResponse addProfileKey(Consumer<AddProfileKeyRequest.Builder> addProfileKeyRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return addProfileKey(AddProfileKeyRequest.builder().applyMutation(addProfileKeyRequest).build());
    }

    /**
     * <p>
     * Fetch the possible attribute values given the attribute name.
     * </p>
     *
     * @param batchGetCalculatedAttributeForProfileRequest
     * @return Result of the BatchGetCalculatedAttributeForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.BatchGetCalculatedAttributeForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/BatchGetCalculatedAttributeForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCalculatedAttributeForProfileResponse batchGetCalculatedAttributeForProfile(
            BatchGetCalculatedAttributeForProfileRequest batchGetCalculatedAttributeForProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch the possible attribute values given the attribute name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetCalculatedAttributeForProfileRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetCalculatedAttributeForProfileRequest#builder()}
     * </p>
     *
     * @param batchGetCalculatedAttributeForProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetCalculatedAttributeForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.BatchGetCalculatedAttributeForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/BatchGetCalculatedAttributeForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCalculatedAttributeForProfileResponse batchGetCalculatedAttributeForProfile(
            Consumer<BatchGetCalculatedAttributeForProfileRequest.Builder> batchGetCalculatedAttributeForProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return batchGetCalculatedAttributeForProfile(BatchGetCalculatedAttributeForProfileRequest.builder()
                .applyMutation(batchGetCalculatedAttributeForProfileRequest).build());
    }

    /**
     * <p>
     * Get a batch of profiles.
     * </p>
     *
     * @param batchGetProfileRequest
     * @return Result of the BatchGetProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.BatchGetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/BatchGetProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetProfileResponse batchGetProfile(BatchGetProfileRequest batchGetProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a batch of profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetProfileRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetProfileRequest#builder()}
     * </p>
     *
     * @param batchGetProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.BatchGetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/BatchGetProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetProfileResponse batchGetProfile(Consumer<BatchGetProfileRequest.Builder> batchGetProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return batchGetProfile(BatchGetProfileRequest.builder().applyMutation(batchGetProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles
     * will be included in the calculated attribute, which can be retrieved for a profile using the <a href=
     * "https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html"
     * >GetCalculatedAttributeForProfile</a> API. Defining a calculated attribute makes it available for all profiles
     * within a domain. Each calculated attribute can only reference one <code>ObjectType</code> and at most, two fields
     * from that <code>ObjectType</code>.
     * </p>
     *
     * @param createCalculatedAttributeDefinitionRequest
     * @return Result of the CreateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCalculatedAttributeDefinitionResponse createCalculatedAttributeDefinition(
            CreateCalculatedAttributeDefinitionRequest createCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles
     * will be included in the calculated attribute, which can be retrieved for a profile using the <a href=
     * "https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html"
     * >GetCalculatedAttributeForProfile</a> API. Defining a calculated attribute makes it available for all profiles
     * within a domain. Each calculated attribute can only reference one <code>ObjectType</code> and at most, two fields
     * from that <code>ObjectType</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param createCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateCalculatedAttributeDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCalculatedAttributeDefinitionResponse createCalculatedAttributeDefinition(
            Consumer<CreateCalculatedAttributeDefinitionRequest.Builder> createCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createCalculatedAttributeDefinition(CreateCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(createCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types,
     * profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party
     * integrations.
     * </p>
     * <p>
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be
     * associated with one domain.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     * <note>
     * <p>
     * It is not possible to associate a Customer Profiles domain with an Amazon Connect Instance directly from the API.
     * If you would like to create a domain and associate a Customer Profiles domain, use the Amazon Connect admin
     * website. For more information, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/enable-customer-profiles.html#enable-customer-profiles-step1"
     * >Enable Customer Profiles</a>.
     * </p>
     * <p>
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be
     * associated with one domain.
     * </p>
     * </note>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types,
     * profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party
     * integrations.
     * </p>
     * <p>
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be
     * associated with one domain.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     * <note>
     * <p>
     * It is not possible to associate a Customer Profiles domain with an Amazon Connect Instance directly from the API.
     * If you would like to create a domain and associate a Customer Profiles domain, use the Amazon Connect admin
     * website. For more information, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/enable-customer-profiles.html#enable-customer-profiles-step1"
     * >Enable Customer Profiles</a>.
     * </p>
     * <p>
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be
     * associated with one domain.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateDomainRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainResponse createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin
     * website.
     * </p>
     *
     * @param createDomainLayoutRequest
     * @return Result of the CreateDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainLayoutResponse createDomainLayout(CreateDomainLayoutRequest createDomainLayoutRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin
     * website.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainLayoutRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDomainLayoutRequest#builder()}
     * </p>
     *
     * @param createDomainLayoutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateDomainLayoutRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainLayoutResponse createDomainLayout(Consumer<CreateDomainLayoutRequest.Builder> createDomainLayoutRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createDomainLayout(CreateDomainLayoutRequest.builder().applyMutation(createDomainLayoutRequest).build());
    }

    /**
     * <p>
     * Creates an event stream, which is a subscription to real-time events, such as when profiles are created and
     * updated through Amazon Connect Customer Profiles.
     * </p>
     * <p>
     * Each event stream can be associated with only one Kinesis Data Stream destination in the same region and Amazon
     * Web Services account as the customer profiles domain
     * </p>
     *
     * @param createEventStreamRequest
     * @return Result of the CreateEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventStreamResponse createEventStream(CreateEventStreamRequest createEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event stream, which is a subscription to real-time events, such as when profiles are created and
     * updated through Amazon Connect Customer Profiles.
     * </p>
     * <p>
     * Each event stream can be associated with only one Kinesis Data Stream destination in the same region and Amazon
     * Web Services account as the customer profiles domain
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventStreamRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEventStreamRequest#builder()}
     * </p>
     *
     * @param createEventStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateEventStreamRequest.Builder} to create
     *        a request.
     * @return Result of the CreateEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventStreamResponse createEventStream(Consumer<CreateEventStreamRequest.Builder> createEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createEventStream(CreateEventStreamRequest.builder().applyMutation(createEventStreamRequest).build());
    }

    /**
     * <p>
     * Creates an event trigger, which specifies the rules when to perform action based on customer's ingested data.
     * </p>
     * <p>
     * Each event stream can be associated with only one integration in the same region and AWS account as the event
     * stream.
     * </p>
     *
     * @param createEventTriggerRequest
     * @return Result of the CreateEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventTriggerResponse createEventTrigger(CreateEventTriggerRequest createEventTriggerRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event trigger, which specifies the rules when to perform action based on customer's ingested data.
     * </p>
     * <p>
     * Each event stream can be associated with only one integration in the same region and AWS account as the event
     * stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventTriggerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventTriggerRequest#builder()}
     * </p>
     *
     * @param createEventTriggerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateEventTriggerRequest.Builder} to create
     *        a request.
     * @return Result of the CreateEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventTriggerResponse createEventTrigger(Consumer<CreateEventTriggerRequest.Builder> createEventTriggerRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createEventTrigger(CreateEventTriggerRequest.builder().applyMutation(createEventTriggerRequest).build());
    }

    /**
     * <p>
     * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets
     * up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and
     * Marketo.
     * </p>
     *
     * @param createIntegrationWorkflowRequest
     * @return Result of the CreateIntegrationWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateIntegrationWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateIntegrationWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationWorkflowResponse createIntegrationWorkflow(
            CreateIntegrationWorkflowRequest createIntegrationWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets
     * up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and
     * Marketo.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationWorkflowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIntegrationWorkflowRequest#builder()}
     * </p>
     *
     * @param createIntegrationWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateIntegrationWorkflowRequest.Builder} to
     *        create a request.
     * @return Result of the CreateIntegrationWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateIntegrationWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateIntegrationWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationWorkflowResponse createIntegrationWorkflow(
            Consumer<CreateIntegrationWorkflowRequest.Builder> createIntegrationWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return createIntegrationWorkflow(CreateIntegrationWorkflowRequest.builder()
                .applyMutation(createIntegrationWorkflowRequest).build());
    }

    /**
     * <p>
     * Creates a standard profile.
     * </p>
     * <p>
     * A standard profile represents the following attributes for a customer profile in a domain.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a standard profile.
     * </p>
     * <p>
     * A standard profile represents the following attributes for a customer profile in a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfileResponse createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Creates a segment definition associated to the given domain.
     * </p>
     *
     * @param createSegmentDefinitionRequest
     * @return Result of the CreateSegmentDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateSegmentDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateSegmentDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSegmentDefinitionResponse createSegmentDefinition(CreateSegmentDefinitionRequest createSegmentDefinitionRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a segment definition associated to the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSegmentDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSegmentDefinitionRequest#builder()}
     * </p>
     *
     * @param createSegmentDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateSegmentDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSegmentDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateSegmentDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateSegmentDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSegmentDefinitionResponse createSegmentDefinition(
            Consumer<CreateSegmentDefinitionRequest.Builder> createSegmentDefinitionRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return createSegmentDefinition(CreateSegmentDefinitionRequest.builder().applyMutation(createSegmentDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a segment estimate query.
     * </p>
     *
     * @param createSegmentEstimateRequest
     * @return Result of the CreateSegmentEstimate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateSegmentEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateSegmentEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSegmentEstimateResponse createSegmentEstimate(CreateSegmentEstimateRequest createSegmentEstimateRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a segment estimate query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSegmentEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSegmentEstimateRequest#builder()}
     * </p>
     *
     * @param createSegmentEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateSegmentEstimateRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSegmentEstimate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateSegmentEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateSegmentEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSegmentEstimateResponse createSegmentEstimate(
            Consumer<CreateSegmentEstimateRequest.Builder> createSegmentEstimateRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return createSegmentEstimate(CreateSegmentEstimateRequest.builder().applyMutation(createSegmentEstimateRequest).build());
    }

    /**
     * <p>
     * Triggers a job to export a segment to a specified destination.
     * </p>
     *
     * @param createSegmentSnapshotRequest
     * @return Result of the CreateSegmentSnapshot operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateSegmentSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateSegmentSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSegmentSnapshotResponse createSegmentSnapshot(CreateSegmentSnapshotRequest createSegmentSnapshotRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Triggers a job to export a segment to a specified destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSegmentSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSegmentSnapshotRequest#builder()}
     * </p>
     *
     * @param createSegmentSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateSegmentSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSegmentSnapshot operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateSegmentSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateSegmentSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSegmentSnapshotResponse createSegmentSnapshot(
            Consumer<CreateSegmentSnapshotRequest.Builder> createSegmentSnapshotRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return createSegmentSnapshot(CreateSegmentSnapshotRequest.builder().applyMutation(createSegmentSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an Upload job to ingest data for segment imports. The metadata is created for the job with the provided
     * field mapping and unique key.
     * </p>
     *
     * @param createUploadJobRequest
     * @return Result of the CreateUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUploadJobResponse createUploadJob(CreateUploadJobRequest createUploadJobRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Upload job to ingest data for segment imports. The metadata is created for the job with the provided
     * field mapping and unique key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUploadJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUploadJobRequest#builder()}
     * </p>
     *
     * @param createUploadJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.CreateUploadJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUploadJobResponse createUploadJob(Consumer<CreateUploadJobRequest.Builder> createUploadJobRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createUploadJob(CreateUploadJobRequest.builder().applyMutation(createUploadJobRequest).build());
    }

    /**
     * <p>
     * Deletes an existing calculated attribute definition. Note that deleting a default calculated attribute is
     * possible, however once deleted, you will be unable to undo that action and will need to recreate it on your own
     * using the CreateCalculatedAttributeDefinition API if you want it back.
     * </p>
     *
     * @param deleteCalculatedAttributeDefinitionRequest
     * @return Result of the DeleteCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCalculatedAttributeDefinitionResponse deleteCalculatedAttributeDefinition(
            DeleteCalculatedAttributeDefinitionRequest deleteCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing calculated attribute definition. Note that deleting a default calculated attribute is
     * possible, however once deleted, you will be unable to undo that action and will need to recreate it on your own
     * using the CreateCalculatedAttributeDefinition API if you want it back.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteCalculatedAttributeDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCalculatedAttributeDefinitionResponse deleteCalculatedAttributeDefinition(
            Consumer<DeleteCalculatedAttributeDefinitionRequest.Builder> deleteCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteCalculatedAttributeDefinition(DeleteCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(deleteCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related
     * objects.
     * </p>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related
     * objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteDomainRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect
     * admin website.
     * </p>
     *
     * @param deleteDomainLayoutRequest
     * @return Result of the DeleteDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainLayoutResponse deleteDomainLayout(DeleteDomainLayoutRequest deleteDomainLayoutRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect
     * admin website.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainLayoutRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDomainLayoutRequest#builder()}
     * </p>
     *
     * @param deleteDomainLayoutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteDomainLayoutRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainLayoutResponse deleteDomainLayout(Consumer<DeleteDomainLayoutRequest.Builder> deleteDomainLayoutRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteDomainLayout(DeleteDomainLayoutRequest.builder().applyMutation(deleteDomainLayoutRequest).build());
    }

    /**
     * <p>
     * Disables and deletes the specified event stream.
     * </p>
     *
     * @param deleteEventStreamRequest
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventStreamResponse deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables and deletes the specified event stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventStreamRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventStreamRequest#builder()}
     * </p>
     *
     * @param deleteEventStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteEventStreamRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventStreamResponse deleteEventStream(Consumer<DeleteEventStreamRequest.Builder> deleteEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteEventStream(DeleteEventStreamRequest.builder().applyMutation(deleteEventStreamRequest).build());
    }

    /**
     * <p>
     * Disable and deletes the Event Trigger.
     * </p>
     * <note>
     * <p>
     * You cannot delete an Event Trigger with an active Integration associated.
     * </p>
     * </note>
     *
     * @param deleteEventTriggerRequest
     * @return Result of the DeleteEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventTriggerResponse deleteEventTrigger(DeleteEventTriggerRequest deleteEventTriggerRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disable and deletes the Event Trigger.
     * </p>
     * <note>
     * <p>
     * You cannot delete an Event Trigger with an active Integration associated.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventTriggerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventTriggerRequest#builder()}
     * </p>
     *
     * @param deleteEventTriggerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteEventTriggerRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventTriggerResponse deleteEventTrigger(Consumer<DeleteEventTriggerRequest.Builder> deleteEventTriggerRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteEventTrigger(DeleteEventTriggerRequest.builder().applyMutation(deleteEventTriggerRequest).build());
    }

    /**
     * <p>
     * Removes an integration from a specific domain.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an integration from a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteIntegrationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationResponse deleteIntegration(Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes the standard customer profile and all data pertaining to the profile.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the standard customer profile and all data pertaining to the profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Removes a searchable key from a customer profile.
     * </p>
     *
     * @param deleteProfileKeyRequest
     * @return Result of the DeleteProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileKeyResponse deleteProfileKey(DeleteProfileKeyRequest deleteProfileKeyRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a searchable key from a customer profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteProfileKeyRequest#builder()}
     * </p>
     *
     * @param deleteProfileKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteProfileKeyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileKeyResponse deleteProfileKey(Consumer<DeleteProfileKeyRequest.Builder> deleteProfileKeyRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteProfileKey(DeleteProfileKeyRequest.builder().applyMutation(deleteProfileKeyRequest).build());
    }

    /**
     * <p>
     * Removes an object associated with a profile of a given ProfileObjectType.
     * </p>
     *
     * @param deleteProfileObjectRequest
     * @return Result of the DeleteProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectResponse deleteProfileObject(DeleteProfileObjectRequest deleteProfileObjectRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an object associated with a profile of a given ProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileObjectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProfileObjectRequest#builder()}
     * </p>
     *
     * @param deleteProfileObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectResponse deleteProfileObject(
            Consumer<DeleteProfileObjectRequest.Builder> deleteProfileObjectRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return deleteProfileObject(DeleteProfileObjectRequest.builder().applyMutation(deleteProfileObjectRequest).build());
    }

    /**
     * <p>
     * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It
     * also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the
     * standard profile that were populated from this ProfileObjectType.
     * </p>
     *
     * @param deleteProfileObjectTypeRequest
     * @return Result of the DeleteProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectTypeResponse deleteProfileObjectType(DeleteProfileObjectTypeRequest deleteProfileObjectTypeRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It
     * also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the
     * standard profile that were populated from this ProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileObjectTypeRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProfileObjectTypeRequest#builder()}
     * </p>
     *
     * @param deleteProfileObjectTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectTypeRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectTypeResponse deleteProfileObjectType(
            Consumer<DeleteProfileObjectTypeRequest.Builder> deleteProfileObjectTypeRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return deleteProfileObjectType(DeleteProfileObjectTypeRequest.builder().applyMutation(deleteProfileObjectTypeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a segment definition from the domain.
     * </p>
     *
     * @param deleteSegmentDefinitionRequest
     * @return Result of the DeleteSegmentDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteSegmentDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteSegmentDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSegmentDefinitionResponse deleteSegmentDefinition(DeleteSegmentDefinitionRequest deleteSegmentDefinitionRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a segment definition from the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSegmentDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSegmentDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteSegmentDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteSegmentDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSegmentDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteSegmentDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteSegmentDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSegmentDefinitionResponse deleteSegmentDefinition(
            Consumer<DeleteSegmentDefinitionRequest.Builder> deleteSegmentDefinitionRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return deleteSegmentDefinition(DeleteSegmentDefinitionRequest.builder().applyMutation(deleteSegmentDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified workflow and all its corresponding resources. This is an async process.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified workflow and all its corresponding resources. This is an async process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DeleteWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * The process of detecting profile object type mapping by using given objects.
     * </p>
     *
     * @param detectProfileObjectTypeRequest
     * @return Result of the DetectProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DetectProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DetectProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectProfileObjectTypeResponse detectProfileObjectType(DetectProfileObjectTypeRequest detectProfileObjectTypeRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The process of detecting profile object type mapping by using given objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectProfileObjectTypeRequest.Builder} avoiding
     * the need to create one manually via {@link DetectProfileObjectTypeRequest#builder()}
     * </p>
     *
     * @param detectProfileObjectTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.DetectProfileObjectTypeRequest.Builder} to
     *        create a request.
     * @return Result of the DetectProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DetectProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DetectProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectProfileObjectTypeResponse detectProfileObjectType(
            Consumer<DetectProfileObjectTypeRequest.Builder> detectProfileObjectTypeRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return detectProfileObjectType(DetectProfileObjectTypeRequest.builder().applyMutation(detectProfileObjectTypeRequest)
                .build());
    }

    /**
     * <p>
     * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a
     * sample of matching groups from the existing matching results, and applies the automerging settings that you
     * provided. You can then view the number of profiles in the sample, the number of matches, and the number of
     * profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching
     * list.
     * </p>
     * <p>
     * You can't view which profiles are matched and would be merged.
     * </p>
     * <important>
     * <p>
     * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity
     * Resolution Job. Include <b>at least</b> two matching attributes. If your matching list includes too few
     * attributes (such as only <code>FirstName</code> or only <code>LastName</code>), there may be a large number of
     * matches. This increases the chances of erroneous merges.
     * </p>
     * </important>
     *
     * @param getAutoMergingPreviewRequest
     * @return Result of the GetAutoMergingPreview operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetAutoMergingPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetAutoMergingPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAutoMergingPreviewResponse getAutoMergingPreview(GetAutoMergingPreviewRequest getAutoMergingPreviewRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a
     * sample of matching groups from the existing matching results, and applies the automerging settings that you
     * provided. You can then view the number of profiles in the sample, the number of matches, and the number of
     * profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching
     * list.
     * </p>
     * <p>
     * You can't view which profiles are matched and would be merged.
     * </p>
     * <important>
     * <p>
     * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity
     * Resolution Job. Include <b>at least</b> two matching attributes. If your matching list includes too few
     * attributes (such as only <code>FirstName</code> or only <code>LastName</code>), there may be a large number of
     * matches. This increases the chances of erroneous merges.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutoMergingPreviewRequest.Builder} avoiding the
     * need to create one manually via {@link GetAutoMergingPreviewRequest#builder()}
     * </p>
     *
     * @param getAutoMergingPreviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetAutoMergingPreviewRequest.Builder} to
     *        create a request.
     * @return Result of the GetAutoMergingPreview operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetAutoMergingPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetAutoMergingPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAutoMergingPreviewResponse getAutoMergingPreview(
            Consumer<GetAutoMergingPreviewRequest.Builder> getAutoMergingPreviewRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getAutoMergingPreview(GetAutoMergingPreviewRequest.builder().applyMutation(getAutoMergingPreviewRequest).build());
    }

    /**
     * <p>
     * Provides more information on a calculated attribute definition for Customer Profiles.
     * </p>
     *
     * @param getCalculatedAttributeDefinitionRequest
     * @return Result of the GetCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeDefinitionResponse getCalculatedAttributeDefinition(
            GetCalculatedAttributeDefinitionRequest getCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information on a calculated attribute definition for Customer Profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param getCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the GetCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeDefinitionResponse getCalculatedAttributeDefinition(
            Consumer<GetCalculatedAttributeDefinitionRequest.Builder> getCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getCalculatedAttributeDefinition(GetCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(getCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Retrieve a calculated attribute for a customer profile.
     * </p>
     *
     * @param getCalculatedAttributeForProfileRequest
     * @return Result of the GetCalculatedAttributeForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeForProfileResponse getCalculatedAttributeForProfile(
            GetCalculatedAttributeForProfileRequest getCalculatedAttributeForProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a calculated attribute for a customer profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalculatedAttributeForProfileRequest.Builder}
     * avoiding the need to create one manually via {@link GetCalculatedAttributeForProfileRequest#builder()}
     * </p>
     *
     * @param getCalculatedAttributeForProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeForProfileRequest.Builder}
     *        to create a request.
     * @return Result of the GetCalculatedAttributeForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeForProfileResponse getCalculatedAttributeForProfile(
            Consumer<GetCalculatedAttributeForProfileRequest.Builder> getCalculatedAttributeForProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getCalculatedAttributeForProfile(GetCalculatedAttributeForProfileRequest.builder()
                .applyMutation(getCalculatedAttributeForProfileRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific domain.
     * </p>
     *
     * @param getDomainRequest
     * @return Result of the GetDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDomainResponse getDomain(GetDomainRequest getDomainRequest) throws BadRequestException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetDomainRequest.Builder} to create a
     *        request.
     * @return Result of the GetDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDomainResponse getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Gets the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin
     * website.
     * </p>
     *
     * @param getDomainLayoutRequest
     * @return Result of the GetDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainLayoutResponse getDomainLayout(GetDomainLayoutRequest getDomainLayoutRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin
     * website.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainLayoutRequest.Builder} avoiding the need
     * to create one manually via {@link GetDomainLayoutRequest#builder()}
     * </p>
     *
     * @param getDomainLayoutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetDomainLayoutRequest.Builder} to create a
     *        request.
     * @return Result of the GetDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainLayoutResponse getDomainLayout(Consumer<GetDomainLayoutRequest.Builder> getDomainLayoutRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getDomainLayout(GetDomainLayoutRequest.builder().applyMutation(getDomainLayoutRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified event stream in a specific domain.
     * </p>
     *
     * @param getEventStreamRequest
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventStreamResponse getEventStream(GetEventStreamRequest getEventStreamRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified event stream in a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventStreamRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventStreamRequest#builder()}
     * </p>
     *
     * @param getEventStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetEventStreamRequest.Builder} to create a
     *        request.
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventStreamResponse getEventStream(Consumer<GetEventStreamRequest.Builder> getEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getEventStream(GetEventStreamRequest.builder().applyMutation(getEventStreamRequest).build());
    }

    /**
     * <p>
     * Get a specific Event Trigger from the domain.
     * </p>
     *
     * @param getEventTriggerRequest
     * @return Result of the GetEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventTriggerResponse getEventTrigger(GetEventTriggerRequest getEventTriggerRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a specific Event Trigger from the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventTriggerRequest.Builder} avoiding the need
     * to create one manually via {@link GetEventTriggerRequest#builder()}
     * </p>
     *
     * @param getEventTriggerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetEventTriggerRequest.Builder} to create a
     *        request.
     * @return Result of the GetEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventTriggerResponse getEventTrigger(Consumer<GetEventTriggerRequest.Builder> getEventTriggerRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getEventTrigger(GetEventTriggerRequest.builder().applyMutation(getEventTriggerRequest).build());
    }

    /**
     * <p>
     * Returns information about an Identity Resolution Job in a specific domain.
     * </p>
     * <p>
     * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html">Use Identity Resolution
     * to consolidate similar profiles</a>.
     * </p>
     *
     * @param getIdentityResolutionJobRequest
     * @return Result of the GetIdentityResolutionJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIdentityResolutionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIdentityResolutionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityResolutionJobResponse getIdentityResolutionJob(
            GetIdentityResolutionJobRequest getIdentityResolutionJobRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an Identity Resolution Job in a specific domain.
     * </p>
     * <p>
     * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html">Use Identity Resolution
     * to consolidate similar profiles</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityResolutionJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetIdentityResolutionJobRequest#builder()}
     * </p>
     *
     * @param getIdentityResolutionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetIdentityResolutionJobRequest.Builder} to
     *        create a request.
     * @return Result of the GetIdentityResolutionJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIdentityResolutionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIdentityResolutionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityResolutionJobResponse getIdentityResolutionJob(
            Consumer<GetIdentityResolutionJobRequest.Builder> getIdentityResolutionJobRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getIdentityResolutionJob(GetIdentityResolutionJobRequest.builder().applyMutation(getIdentityResolutionJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns an integration for a domain.
     * </p>
     *
     * @param getIntegrationRequest
     * @return Result of the GetIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an integration for a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link GetIntegrationRequest#builder()}
     * </p>
     *
     * @param getIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetIntegrationRequest.Builder} to create a
     *        request.
     * @return Result of the GetIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIntegrationResponse getIntegration(Consumer<GetIntegrationRequest.Builder> getIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getIntegration(GetIntegrationRequest.builder().applyMutation(getIntegrationRequest).build());
    }

    /**
     * <p>
     * Before calling this API, use <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or
     * <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a>
     * to enable identity resolution: set <code>Matching</code> to true.
     * </p>
     * <p>
     * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning
     * process.
     * </p>
     * <important>
     * <p>
     * The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer
     * Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for
     * Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in
     * your domains.
     * </p>
     * <p>
     * After the Identity Resolution Job completes, use the <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to
     * return and review the results. Or, if you have configured <code>ExportingConfig</code> in the
     * <code>MatchingRequest</code>, you can download the results from S3.
     * </p>
     * </important>
     * <p>
     * Amazon Connect uses the following profile attributes to identify matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * HomePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessPhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * MobilePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * EmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * PersonalEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * FullName
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, two or more profiles—with spelling mistakes such as <b>John Doe</b> and <b>Jhn Doe</b>, or different
     * casing email addresses such as <b>JOHN_DOE@ANYCOMPANY.COM</b> and <b>johndoe@anycompany.com</b>, or different
     * phone number formats such as <b>555-010-0000</b> and <b>+1-555-010-0000</b>—can be detected as belonging to the
     * same customer <b>John Doe</b> and merged into a unified profile.
     * </p>
     *
     * @param getMatchesRequest
     * @return Result of the GetMatches operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMatchesResponse getMatches(GetMatchesRequest getMatchesRequest) throws BadRequestException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Before calling this API, use <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or
     * <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a>
     * to enable identity resolution: set <code>Matching</code> to true.
     * </p>
     * <p>
     * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning
     * process.
     * </p>
     * <important>
     * <p>
     * The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer
     * Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for
     * Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in
     * your domains.
     * </p>
     * <p>
     * After the Identity Resolution Job completes, use the <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to
     * return and review the results. Or, if you have configured <code>ExportingConfig</code> in the
     * <code>MatchingRequest</code>, you can download the results from S3.
     * </p>
     * </important>
     * <p>
     * Amazon Connect uses the following profile attributes to identify matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * HomePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessPhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * MobilePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * EmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * PersonalEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * FullName
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, two or more profiles—with spelling mistakes such as <b>John Doe</b> and <b>Jhn Doe</b>, or different
     * casing email addresses such as <b>JOHN_DOE@ANYCOMPANY.COM</b> and <b>johndoe@anycompany.com</b>, or different
     * phone number formats such as <b>555-010-0000</b> and <b>+1-555-010-0000</b>—can be detected as belonging to the
     * same customer <b>John Doe</b> and merged into a unified profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchesRequest.Builder} avoiding the need to
     * create one manually via {@link GetMatchesRequest#builder()}
     * </p>
     *
     * @param getMatchesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetMatchesRequest.Builder} to create a
     *        request.
     * @return Result of the GetMatches operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMatchesResponse getMatches(Consumer<GetMatchesRequest.Builder> getMatchesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getMatches(GetMatchesRequest.builder().applyMutation(getMatchesRequest).build());
    }

    /**
     * <p>
     * Returns a history record for a specific profile, for a specific domain.
     * </p>
     *
     * @param getProfileHistoryRecordRequest
     * @return Result of the GetProfileHistoryRecord operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileHistoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileHistoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileHistoryRecordResponse getProfileHistoryRecord(GetProfileHistoryRecordRequest getProfileHistoryRecordRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a history record for a specific profile, for a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileHistoryRecordRequest.Builder} avoiding
     * the need to create one manually via {@link GetProfileHistoryRecordRequest#builder()}
     * </p>
     *
     * @param getProfileHistoryRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetProfileHistoryRecordRequest.Builder} to
     *        create a request.
     * @return Result of the GetProfileHistoryRecord operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileHistoryRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileHistoryRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileHistoryRecordResponse getProfileHistoryRecord(
            Consumer<GetProfileHistoryRecordRequest.Builder> getProfileHistoryRecordRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getProfileHistoryRecord(GetProfileHistoryRecordRequest.builder().applyMutation(getProfileHistoryRecordRequest)
                .build());
    }

    /**
     * <p>
     * Returns the object types for a specific domain.
     * </p>
     *
     * @param getProfileObjectTypeRequest
     * @return Result of the GetProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeResponse getProfileObjectType(GetProfileObjectTypeRequest getProfileObjectTypeRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the object types for a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileObjectTypeRequest.Builder} avoiding the
     * need to create one manually via {@link GetProfileObjectTypeRequest#builder()}
     * </p>
     *
     * @param getProfileObjectTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeRequest.Builder} to
     *        create a request.
     * @return Result of the GetProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeResponse getProfileObjectType(
            Consumer<GetProfileObjectTypeRequest.Builder> getProfileObjectTypeRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getProfileObjectType(GetProfileObjectTypeRequest.builder().applyMutation(getProfileObjectTypeRequest).build());
    }

    /**
     * <p>
     * Returns the template information for a specific object type.
     * </p>
     * <p>
     * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user
     * sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the
     * TemplateIds, it uses the mappings from the template.
     * </p>
     *
     * @param getProfileObjectTypeTemplateRequest
     * @return Result of the GetProfileObjectTypeTemplate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectTypeTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeTemplateResponse getProfileObjectTypeTemplate(
            GetProfileObjectTypeTemplateRequest getProfileObjectTypeTemplateRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template information for a specific object type.
     * </p>
     * <p>
     * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user
     * sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the
     * TemplateIds, it uses the mappings from the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileObjectTypeTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link GetProfileObjectTypeTemplateRequest#builder()}
     * </p>
     *
     * @param getProfileObjectTypeTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the GetProfileObjectTypeTemplate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectTypeTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeTemplateResponse getProfileObjectTypeTemplate(
            Consumer<GetProfileObjectTypeTemplateRequest.Builder> getProfileObjectTypeTemplateRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getProfileObjectTypeTemplate(GetProfileObjectTypeTemplateRequest.builder()
                .applyMutation(getProfileObjectTypeTemplateRequest).build());
    }

    /**
     * <p>
     * Gets a segment definition from the domain.
     * </p>
     *
     * @param getSegmentDefinitionRequest
     * @return Result of the GetSegmentDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentDefinitionResponse getSegmentDefinition(GetSegmentDefinitionRequest getSegmentDefinitionRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a segment definition from the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentDefinitionRequest#builder()}
     * </p>
     *
     * @param getSegmentDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetSegmentDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the GetSegmentDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentDefinitionResponse getSegmentDefinition(
            Consumer<GetSegmentDefinitionRequest.Builder> getSegmentDefinitionRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getSegmentDefinition(GetSegmentDefinitionRequest.builder().applyMutation(getSegmentDefinitionRequest).build());
    }

    /**
     * <p>
     * Gets the result of a segment estimate query.
     * </p>
     *
     * @param getSegmentEstimateRequest
     * @return Result of the GetSegmentEstimate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentEstimateResponse getSegmentEstimate(GetSegmentEstimateRequest getSegmentEstimateRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the result of a segment estimate query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentEstimateRequest#builder()}
     * </p>
     *
     * @param getSegmentEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetSegmentEstimateRequest.Builder} to create
     *        a request.
     * @return Result of the GetSegmentEstimate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentEstimateResponse getSegmentEstimate(Consumer<GetSegmentEstimateRequest.Builder> getSegmentEstimateRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getSegmentEstimate(GetSegmentEstimateRequest.builder().applyMutation(getSegmentEstimateRequest).build());
    }

    /**
     * <p>
     * Determines if the given profiles are within a segment.
     * </p>
     *
     * @param getSegmentMembershipRequest
     * @return Result of the GetSegmentMembership operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentMembershipResponse getSegmentMembership(GetSegmentMembershipRequest getSegmentMembershipRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines if the given profiles are within a segment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentMembershipRequest#builder()}
     * </p>
     *
     * @param getSegmentMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetSegmentMembershipRequest.Builder} to
     *        create a request.
     * @return Result of the GetSegmentMembership operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentMembershipResponse getSegmentMembership(
            Consumer<GetSegmentMembershipRequest.Builder> getSegmentMembershipRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getSegmentMembership(GetSegmentMembershipRequest.builder().applyMutation(getSegmentMembershipRequest).build());
    }

    /**
     * <p>
     * Retrieve the latest status of a segment snapshot.
     * </p>
     *
     * @param getSegmentSnapshotRequest
     * @return Result of the GetSegmentSnapshot operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentSnapshotResponse getSegmentSnapshot(GetSegmentSnapshotRequest getSegmentSnapshotRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the latest status of a segment snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentSnapshotRequest#builder()}
     * </p>
     *
     * @param getSegmentSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetSegmentSnapshotRequest.Builder} to create
     *        a request.
     * @return Result of the GetSegmentSnapshot operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSegmentSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSegmentSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSegmentSnapshotResponse getSegmentSnapshot(Consumer<GetSegmentSnapshotRequest.Builder> getSegmentSnapshotRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getSegmentSnapshot(GetSegmentSnapshotRequest.builder().applyMutation(getSegmentSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns a set of profiles that belong to the same matching group using the <code>matchId</code> or
     * <code>profileId</code>. You can also specify the type of matching that you want for finding similar profiles
     * using either <code>RULE_BASED_MATCHING</code> or <code>ML_BASED_MATCHING</code>.
     * </p>
     *
     * @param getSimilarProfilesRequest
     * @return Result of the GetSimilarProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSimilarProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSimilarProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSimilarProfilesResponse getSimilarProfiles(GetSimilarProfilesRequest getSimilarProfilesRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a set of profiles that belong to the same matching group using the <code>matchId</code> or
     * <code>profileId</code>. You can also specify the type of matching that you want for finding similar profiles
     * using either <code>RULE_BASED_MATCHING</code> or <code>ML_BASED_MATCHING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSimilarProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link GetSimilarProfilesRequest#builder()}
     * </p>
     *
     * @param getSimilarProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest.Builder} to create
     *        a request.
     * @return Result of the GetSimilarProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSimilarProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSimilarProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSimilarProfilesResponse getSimilarProfiles(Consumer<GetSimilarProfilesRequest.Builder> getSimilarProfilesRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getSimilarProfiles(GetSimilarProfilesRequest.builder().applyMutation(getSimilarProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSimilarProfiles(software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.GetSimilarProfilesIterable responses = client.getSimilarProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.GetSimilarProfilesIterable responses = client
     *             .getSimilarProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.GetSimilarProfilesIterable responses = client.getSimilarProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSimilarProfiles(software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSimilarProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSimilarProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSimilarProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSimilarProfilesIterable getSimilarProfilesPaginator(GetSimilarProfilesRequest getSimilarProfilesRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return new GetSimilarProfilesIterable(this, getSimilarProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSimilarProfiles(software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.GetSimilarProfilesIterable responses = client.getSimilarProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.GetSimilarProfilesIterable responses = client
     *             .getSimilarProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.GetSimilarProfilesIterable responses = client.getSimilarProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSimilarProfiles(software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSimilarProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link GetSimilarProfilesRequest#builder()}
     * </p>
     *
     * @param getSimilarProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetSimilarProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetSimilarProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSimilarProfilesIterable getSimilarProfilesPaginator(
            Consumer<GetSimilarProfilesRequest.Builder> getSimilarProfilesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getSimilarProfilesPaginator(GetSimilarProfilesRequest.builder().applyMutation(getSimilarProfilesRequest).build());
    }

    /**
     * <p>
     * This API retrieves the details of a specific upload job.
     * </p>
     *
     * @param getUploadJobRequest
     * @return Result of the GetUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUploadJobResponse getUploadJob(GetUploadJobRequest getUploadJobRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API retrieves the details of a specific upload job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUploadJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetUploadJobRequest#builder()}
     * </p>
     *
     * @param getUploadJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetUploadJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUploadJobResponse getUploadJob(Consumer<GetUploadJobRequest.Builder> getUploadJobRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getUploadJob(GetUploadJobRequest.builder().applyMutation(getUploadJobRequest).build());
    }

    /**
     * <p>
     * This API retrieves the pre-signed URL and client token for uploading the file associated with the upload job.
     * </p>
     *
     * @param getUploadJobPathRequest
     * @return Result of the GetUploadJobPath operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetUploadJobPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetUploadJobPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUploadJobPathResponse getUploadJobPath(GetUploadJobPathRequest getUploadJobPathRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API retrieves the pre-signed URL and client token for uploading the file associated with the upload job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUploadJobPathRequest.Builder} avoiding the need
     * to create one manually via {@link GetUploadJobPathRequest#builder()}
     * </p>
     *
     * @param getUploadJobPathRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetUploadJobPathRequest.Builder} to create a
     *        request.
     * @return Result of the GetUploadJobPath operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetUploadJobPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetUploadJobPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUploadJobPathResponse getUploadJobPath(Consumer<GetUploadJobPathRequest.Builder> getUploadJobPathRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getUploadJobPath(GetUploadJobPathRequest.builder().applyMutation(getUploadJobPathRequest).build());
    }

    /**
     * <p>
     * Get details of specified workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details of specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Get granular list of steps in workflow.
     * </p>
     *
     * @param getWorkflowStepsRequest
     * @return Result of the GetWorkflowSteps operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepsResponse getWorkflowSteps(GetWorkflowStepsRequest getWorkflowStepsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get granular list of steps in workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowStepsRequest.Builder} avoiding the need
     * to create one manually via {@link GetWorkflowStepsRequest#builder()}
     * </p>
     *
     * @param getWorkflowStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.GetWorkflowStepsRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkflowSteps operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepsResponse getWorkflowSteps(Consumer<GetWorkflowStepsRequest.Builder> getWorkflowStepsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getWorkflowSteps(GetWorkflowStepsRequest.builder().applyMutation(getWorkflowStepsRequest).build());
    }

    /**
     * <p>
     * Lists all of the integrations associated to a specific URI in the AWS account.
     * </p>
     *
     * @param listAccountIntegrationsRequest
     * @return Result of the ListAccountIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListAccountIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountIntegrationsResponse listAccountIntegrations(ListAccountIntegrationsRequest listAccountIntegrationsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the integrations associated to a specific URI in the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountIntegrationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountIntegrationsRequest#builder()}
     * </p>
     *
     * @param listAccountIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListAccountIntegrationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccountIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListAccountIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountIntegrationsResponse listAccountIntegrations(
            Consumer<ListAccountIntegrationsRequest.Builder> listAccountIntegrationsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listAccountIntegrations(ListAccountIntegrationsRequest.builder().applyMutation(listAccountIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists calculated attribute definitions for Customer Profiles
     * </p>
     *
     * @param listCalculatedAttributeDefinitionsRequest
     * @return Result of the ListCalculatedAttributeDefinitions operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributeDefinitionsResponse listCalculatedAttributeDefinitions(
            ListCalculatedAttributeDefinitionsRequest listCalculatedAttributeDefinitionsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists calculated attribute definitions for Customer Profiles
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCalculatedAttributeDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCalculatedAttributeDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCalculatedAttributeDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributeDefinitionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCalculatedAttributeDefinitions operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributeDefinitionsResponse listCalculatedAttributeDefinitions(
            Consumer<ListCalculatedAttributeDefinitionsRequest.Builder> listCalculatedAttributeDefinitionsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listCalculatedAttributeDefinitions(ListCalculatedAttributeDefinitionsRequest.builder()
                .applyMutation(listCalculatedAttributeDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of calculated attributes for a customer profile.
     * </p>
     *
     * @param listCalculatedAttributesForProfileRequest
     * @return Result of the ListCalculatedAttributesForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributesForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributesForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributesForProfileResponse listCalculatedAttributesForProfile(
            ListCalculatedAttributesForProfileRequest listCalculatedAttributesForProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of calculated attributes for a customer profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCalculatedAttributesForProfileRequest.Builder}
     * avoiding the need to create one manually via {@link ListCalculatedAttributesForProfileRequest#builder()}
     * </p>
     *
     * @param listCalculatedAttributesForProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributesForProfileRequest.Builder}
     *        to create a request.
     * @return Result of the ListCalculatedAttributesForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributesForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributesForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributesForProfileResponse listCalculatedAttributesForProfile(
            Consumer<ListCalculatedAttributesForProfileRequest.Builder> listCalculatedAttributesForProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listCalculatedAttributesForProfile(ListCalculatedAttributesForProfileRequest.builder()
                .applyMutation(listCalculatedAttributesForProfileRequest).build());
    }

    /**
     * <p>
     * Lists the existing layouts that can be used to view data for a specific domain. This API can only be invoked from
     * the Amazon Connect admin website.
     * </p>
     *
     * @param listDomainLayoutsRequest
     * @return Result of the ListDomainLayouts operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomainLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomainLayouts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainLayoutsResponse listDomainLayouts(ListDomainLayoutsRequest listDomainLayoutsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing layouts that can be used to view data for a specific domain. This API can only be invoked from
     * the Amazon Connect admin website.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainLayoutsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainLayoutsRequest#builder()}
     * </p>
     *
     * @param listDomainLayoutsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest.Builder} to create
     *        a request.
     * @return Result of the ListDomainLayouts operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomainLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomainLayouts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainLayoutsResponse listDomainLayouts(Consumer<ListDomainLayoutsRequest.Builder> listDomainLayoutsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listDomainLayouts(ListDomainLayoutsRequest.builder().applyMutation(listDomainLayoutsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainLayouts(software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListDomainLayoutsIterable responses = client.listDomainLayoutsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListDomainLayoutsIterable responses = client
     *             .listDomainLayoutsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListDomainLayoutsIterable responses = client.listDomainLayoutsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainLayouts(software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainLayoutsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomainLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomainLayouts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainLayoutsIterable listDomainLayoutsPaginator(ListDomainLayoutsRequest listDomainLayoutsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return new ListDomainLayoutsIterable(this, listDomainLayoutsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainLayouts(software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListDomainLayoutsIterable responses = client.listDomainLayoutsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListDomainLayoutsIterable responses = client
     *             .listDomainLayoutsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListDomainLayoutsIterable responses = client.listDomainLayoutsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainLayouts(software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainLayoutsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainLayoutsRequest#builder()}
     * </p>
     *
     * @param listDomainLayoutsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomainLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomainLayouts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainLayoutsIterable listDomainLayoutsPaginator(
            Consumer<ListDomainLayoutsRequest.Builder> listDomainLayoutsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listDomainLayoutsPaginator(ListDomainLayoutsRequest.builder().applyMutation(listDomainLayoutsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the domains for an AWS account that have been created.
     * </p>
     *
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the domains for an AWS account that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListDomainsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDomains operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the event streams in a specific domain.
     * </p>
     *
     * @param listEventStreamsRequest
     * @return Result of the ListEventStreams operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsResponse listEventStreams(ListEventStreamsRequest listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the event streams in a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventStreamsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventStreamsRequest#builder()}
     * </p>
     *
     * @param listEventStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEventStreams operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsResponse listEventStreams(Consumer<ListEventStreamsRequest.Builder> listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listEventStreams(ListEventStreamsRequest.builder().applyMutation(listEventStreamsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client
     *             .listEventStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventStreamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsIterable listEventStreamsPaginator(ListEventStreamsRequest listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return new ListEventStreamsIterable(this, listEventStreamsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client
     *             .listEventStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventStreamsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventStreamsRequest#builder()}
     * </p>
     *
     * @param listEventStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsIterable listEventStreamsPaginator(Consumer<ListEventStreamsRequest.Builder> listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listEventStreamsPaginator(ListEventStreamsRequest.builder().applyMutation(listEventStreamsRequest).build());
    }

    /**
     * <p>
     * List all Event Triggers under a domain.
     * </p>
     *
     * @param listEventTriggersRequest
     * @return Result of the ListEventTriggers operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventTriggersResponse listEventTriggers(ListEventTriggersRequest listEventTriggersRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all Event Triggers under a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventTriggersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventTriggersRequest#builder()}
     * </p>
     *
     * @param listEventTriggersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest.Builder} to create
     *        a request.
     * @return Result of the ListEventTriggers operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventTriggersResponse listEventTriggers(Consumer<ListEventTriggersRequest.Builder> listEventTriggersRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listEventTriggers(ListEventTriggersRequest.builder().applyMutation(listEventTriggersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventTriggers(software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventTriggersIterable responses = client.listEventTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListEventTriggersIterable responses = client
     *             .listEventTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventTriggersIterable responses = client.listEventTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventTriggers(software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventTriggersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventTriggersIterable listEventTriggersPaginator(ListEventTriggersRequest listEventTriggersRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return new ListEventTriggersIterable(this, listEventTriggersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventTriggers(software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventTriggersIterable responses = client.listEventTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListEventTriggersIterable responses = client
     *             .listEventTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventTriggersIterable responses = client.listEventTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventTriggers(software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventTriggersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventTriggersRequest#builder()}
     * </p>
     *
     * @param listEventTriggersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventTriggersIterable listEventTriggersPaginator(
            Consumer<ListEventTriggersRequest.Builder> listEventTriggersRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listEventTriggersPaginator(ListEventTriggersRequest.builder().applyMutation(listEventTriggersRequest).build());
    }

    /**
     * <p>
     * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by
     * <code>JobStartTime</code>.
     * </p>
     *
     * @param listIdentityResolutionJobsRequest
     * @return Result of the ListIdentityResolutionJobs operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIdentityResolutionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIdentityResolutionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityResolutionJobsResponse listIdentityResolutionJobs(
            ListIdentityResolutionJobsRequest listIdentityResolutionJobsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by
     * <code>JobStartTime</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityResolutionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIdentityResolutionJobsRequest#builder()}
     * </p>
     *
     * @param listIdentityResolutionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListIdentityResolutionJobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListIdentityResolutionJobs operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIdentityResolutionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIdentityResolutionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityResolutionJobsResponse listIdentityResolutionJobs(
            Consumer<ListIdentityResolutionJobsRequest.Builder> listIdentityResolutionJobsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listIdentityResolutionJobs(ListIdentityResolutionJobsRequest.builder()
                .applyMutation(listIdentityResolutionJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the integrations in your domain.
     * </p>
     *
     * @param listIntegrationsRequest
     * @return Result of the ListIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationsResponse listIntegrations(ListIntegrationsRequest listIntegrationsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the integrations in your domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntegrationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIntegrationsRequest#builder()}
     * </p>
     *
     * @param listIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListIntegrationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationsResponse listIntegrations(Consumer<ListIntegrationsRequest.Builder> listIntegrationsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listIntegrations(ListIntegrationsRequest.builder().applyMutation(listIntegrationsRequest).build());
    }

    /**
     * <p>
     * Fetch the possible attribute values given the attribute name.
     * </p>
     *
     * @param listObjectTypeAttributesRequest
     * @return Result of the ListObjectTypeAttributes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListObjectTypeAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListObjectTypeAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectTypeAttributesResponse listObjectTypeAttributes(
            ListObjectTypeAttributesRequest listObjectTypeAttributesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch the possible attribute values given the attribute name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectTypeAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link ListObjectTypeAttributesRequest#builder()}
     * </p>
     *
     * @param listObjectTypeAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest.Builder} to
     *        create a request.
     * @return Result of the ListObjectTypeAttributes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListObjectTypeAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListObjectTypeAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectTypeAttributesResponse listObjectTypeAttributes(
            Consumer<ListObjectTypeAttributesRequest.Builder> listObjectTypeAttributesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listObjectTypeAttributes(ListObjectTypeAttributesRequest.builder().applyMutation(listObjectTypeAttributesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listObjectTypeAttributes(software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListObjectTypeAttributesIterable responses = client.listObjectTypeAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListObjectTypeAttributesIterable responses = client
     *             .listObjectTypeAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListObjectTypeAttributesIterable responses = client.listObjectTypeAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectTypeAttributes(software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listObjectTypeAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListObjectTypeAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListObjectTypeAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectTypeAttributesIterable listObjectTypeAttributesPaginator(
            ListObjectTypeAttributesRequest listObjectTypeAttributesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return new ListObjectTypeAttributesIterable(this, listObjectTypeAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listObjectTypeAttributes(software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListObjectTypeAttributesIterable responses = client.listObjectTypeAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListObjectTypeAttributesIterable responses = client
     *             .listObjectTypeAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListObjectTypeAttributesIterable responses = client.listObjectTypeAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectTypeAttributes(software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectTypeAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link ListObjectTypeAttributesRequest#builder()}
     * </p>
     *
     * @param listObjectTypeAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListObjectTypeAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListObjectTypeAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectTypeAttributesIterable listObjectTypeAttributesPaginator(
            Consumer<ListObjectTypeAttributesRequest.Builder> listObjectTypeAttributesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listObjectTypeAttributesPaginator(ListObjectTypeAttributesRequest.builder()
                .applyMutation(listObjectTypeAttributesRequest).build());
    }

    /**
     * <p>
     * Fetch the possible attribute values given the attribute name.
     * </p>
     *
     * @param listProfileAttributeValuesRequest
     * @return Result of the ListProfileAttributeValues operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileAttributeValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileAttributeValues"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileAttributeValuesResponse listProfileAttributeValues(
            ListProfileAttributeValuesRequest listProfileAttributeValuesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch the possible attribute values given the attribute name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileAttributeValuesRequest.Builder} avoiding
     * the need to create one manually via {@link ListProfileAttributeValuesRequest#builder()}
     * </p>
     *
     * @param listProfileAttributeValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListProfileAttributeValuesRequest.Builder}
     *        to create a request.
     * @return Result of the ListProfileAttributeValues operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileAttributeValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileAttributeValues"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileAttributeValuesResponse listProfileAttributeValues(
            Consumer<ListProfileAttributeValuesRequest.Builder> listProfileAttributeValuesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listProfileAttributeValues(ListProfileAttributeValuesRequest.builder()
                .applyMutation(listProfileAttributeValuesRequest).build());
    }

    /**
     * <p>
     * Returns a list of history records for a specific profile, for a specific domain.
     * </p>
     *
     * @param listProfileHistoryRecordsRequest
     * @return Result of the ListProfileHistoryRecords operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileHistoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileHistoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileHistoryRecordsResponse listProfileHistoryRecords(
            ListProfileHistoryRecordsRequest listProfileHistoryRecordsRequest) throws BadRequestException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of history records for a specific profile, for a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileHistoryRecordsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProfileHistoryRecordsRequest#builder()}
     * </p>
     *
     * @param listProfileHistoryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListProfileHistoryRecordsRequest.Builder} to
     *        create a request.
     * @return Result of the ListProfileHistoryRecords operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileHistoryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileHistoryRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileHistoryRecordsResponse listProfileHistoryRecords(
            Consumer<ListProfileHistoryRecordsRequest.Builder> listProfileHistoryRecordsRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listProfileHistoryRecords(ListProfileHistoryRecordsRequest.builder()
                .applyMutation(listProfileHistoryRecordsRequest).build());
    }

    /**
     * <p>
     * Lists all of the template information for object types.
     * </p>
     *
     * @param listProfileObjectTypeTemplatesRequest
     * @return Result of the ListProfileObjectTypeTemplates operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypeTemplates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypeTemplatesResponse listProfileObjectTypeTemplates(
            ListProfileObjectTypeTemplatesRequest listProfileObjectTypeTemplatesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the template information for object types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileObjectTypeTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListProfileObjectTypeTemplatesRequest#builder()}
     * </p>
     *
     * @param listProfileObjectTypeTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypeTemplatesRequest.Builder}
     *        to create a request.
     * @return Result of the ListProfileObjectTypeTemplates operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypeTemplates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypeTemplatesResponse listProfileObjectTypeTemplates(
            Consumer<ListProfileObjectTypeTemplatesRequest.Builder> listProfileObjectTypeTemplatesRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listProfileObjectTypeTemplates(ListProfileObjectTypeTemplatesRequest.builder()
                .applyMutation(listProfileObjectTypeTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all of the templates available within the service.
     * </p>
     *
     * @param listProfileObjectTypesRequest
     * @return Result of the ListProfileObjectTypes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypesResponse listProfileObjectTypes(ListProfileObjectTypesRequest listProfileObjectTypesRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the templates available within the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileObjectTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfileObjectTypesRequest#builder()}
     * </p>
     *
     * @param listProfileObjectTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypesRequest.Builder} to
     *        create a request.
     * @return Result of the ListProfileObjectTypes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypesResponse listProfileObjectTypes(
            Consumer<ListProfileObjectTypesRequest.Builder> listProfileObjectTypesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listProfileObjectTypes(ListProfileObjectTypesRequest.builder().applyMutation(listProfileObjectTypesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of objects associated with a profile of a given ProfileObjectType.
     * </p>
     *
     * @param listProfileObjectsRequest
     * @return Result of the ListProfileObjects operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectsResponse listProfileObjects(ListProfileObjectsRequest listProfileObjectsRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of objects associated with a profile of a given ProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileObjectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfileObjectsRequest#builder()}
     * </p>
     *
     * @param listProfileObjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectsRequest.Builder} to create
     *        a request.
     * @return Result of the ListProfileObjects operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectsResponse listProfileObjects(Consumer<ListProfileObjectsRequest.Builder> listProfileObjectsRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listProfileObjects(ListProfileObjectsRequest.builder().applyMutation(listProfileObjectsRequest).build());
    }

    /**
     * <p>
     * Returns a set of <code>MatchIds</code> that belong to the given domain.
     * </p>
     *
     * @param listRuleBasedMatchesRequest
     * @return Result of the ListRuleBasedMatches operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListRuleBasedMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListRuleBasedMatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleBasedMatchesResponse listRuleBasedMatches(ListRuleBasedMatchesRequest listRuleBasedMatchesRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a set of <code>MatchIds</code> that belong to the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleBasedMatchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListRuleBasedMatchesRequest#builder()}
     * </p>
     *
     * @param listRuleBasedMatchesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest.Builder} to
     *        create a request.
     * @return Result of the ListRuleBasedMatches operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListRuleBasedMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListRuleBasedMatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleBasedMatchesResponse listRuleBasedMatches(
            Consumer<ListRuleBasedMatchesRequest.Builder> listRuleBasedMatchesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listRuleBasedMatches(ListRuleBasedMatchesRequest.builder().applyMutation(listRuleBasedMatchesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRuleBasedMatches(software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListRuleBasedMatchesIterable responses = client.listRuleBasedMatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListRuleBasedMatchesIterable responses = client
     *             .listRuleBasedMatchesPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListRuleBasedMatchesIterable responses = client.listRuleBasedMatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleBasedMatches(software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRuleBasedMatchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListRuleBasedMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListRuleBasedMatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleBasedMatchesIterable listRuleBasedMatchesPaginator(ListRuleBasedMatchesRequest listRuleBasedMatchesRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return new ListRuleBasedMatchesIterable(this, listRuleBasedMatchesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRuleBasedMatches(software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListRuleBasedMatchesIterable responses = client.listRuleBasedMatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListRuleBasedMatchesIterable responses = client
     *             .listRuleBasedMatchesPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListRuleBasedMatchesIterable responses = client.listRuleBasedMatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleBasedMatches(software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleBasedMatchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListRuleBasedMatchesRequest#builder()}
     * </p>
     *
     * @param listRuleBasedMatchesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListRuleBasedMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListRuleBasedMatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleBasedMatchesIterable listRuleBasedMatchesPaginator(
            Consumer<ListRuleBasedMatchesRequest.Builder> listRuleBasedMatchesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listRuleBasedMatchesPaginator(ListRuleBasedMatchesRequest.builder().applyMutation(listRuleBasedMatchesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all segment definitions under a domain.
     * </p>
     *
     * @param listSegmentDefinitionsRequest
     * @return Result of the ListSegmentDefinitions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListSegmentDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListSegmentDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSegmentDefinitionsResponse listSegmentDefinitions(ListSegmentDefinitionsRequest listSegmentDefinitionsRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all segment definitions under a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSegmentDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSegmentDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSegmentDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSegmentDefinitions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListSegmentDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListSegmentDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSegmentDefinitionsResponse listSegmentDefinitions(
            Consumer<ListSegmentDefinitionsRequest.Builder> listSegmentDefinitionsRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listSegmentDefinitions(ListSegmentDefinitionsRequest.builder().applyMutation(listSegmentDefinitionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSegmentDefinitions(software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListSegmentDefinitionsIterable responses = client.listSegmentDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListSegmentDefinitionsIterable responses = client
     *             .listSegmentDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListSegmentDefinitionsIterable responses = client.listSegmentDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSegmentDefinitions(software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSegmentDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListSegmentDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListSegmentDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSegmentDefinitionsIterable listSegmentDefinitionsPaginator(
            ListSegmentDefinitionsRequest listSegmentDefinitionsRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return new ListSegmentDefinitionsIterable(this, listSegmentDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSegmentDefinitions(software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListSegmentDefinitionsIterable responses = client.listSegmentDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListSegmentDefinitionsIterable responses = client
     *             .listSegmentDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListSegmentDefinitionsIterable responses = client.listSegmentDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSegmentDefinitions(software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSegmentDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSegmentDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSegmentDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListSegmentDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListSegmentDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSegmentDefinitionsIterable listSegmentDefinitionsPaginator(
            Consumer<ListSegmentDefinitionsRequest.Builder> listSegmentDefinitionsRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listSegmentDefinitionsPaginator(ListSegmentDefinitionsRequest.builder()
                .applyMutation(listSegmentDefinitionsRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This API retrieves a list of upload jobs for the specified domain.
     * </p>
     *
     * @param listUploadJobsRequest
     * @return Result of the ListUploadJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListUploadJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListUploadJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUploadJobsResponse listUploadJobs(ListUploadJobsRequest listUploadJobsRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API retrieves a list of upload jobs for the specified domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUploadJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUploadJobsRequest#builder()}
     * </p>
     *
     * @param listUploadJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListUploadJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListUploadJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListUploadJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUploadJobsResponse listUploadJobs(Consumer<ListUploadJobsRequest.Builder> listUploadJobsRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listUploadJobs(ListUploadJobsRequest.builder().applyMutation(listUploadJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUploadJobs(software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListUploadJobsIterable responses = client.listUploadJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListUploadJobsIterable responses = client
     *             .listUploadJobsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListUploadJobsIterable responses = client.listUploadJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploadJobs(software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUploadJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListUploadJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListUploadJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUploadJobsIterable listUploadJobsPaginator(ListUploadJobsRequest listUploadJobsRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return new ListUploadJobsIterable(this, listUploadJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUploadJobs(software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListUploadJobsIterable responses = client.listUploadJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListUploadJobsIterable responses = client
     *             .listUploadJobsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListUploadJobsIterable responses = client.listUploadJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploadJobs(software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUploadJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUploadJobsRequest#builder()}
     * </p>
     *
     * @param listUploadJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListUploadJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListUploadJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUploadJobsIterable listUploadJobsPaginator(Consumer<ListUploadJobsRequest.Builder> listUploadJobsRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listUploadJobsPaginator(ListUploadJobsRequest.builder().applyMutation(listUploadJobsRequest).build());
    }

    /**
     * <p>
     * Query to list all workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query to list all workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.ListWorkflowsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Runs an AWS Lambda job that does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the objects in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the <code>ProfileToBeMerged</code> will be deleted at the end.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileIdsToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * Standard fields are merged as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
     * </p>
     * </li>
     * <li>
     * <p>
     * When there are conflicting fields:
     * </p>
     * <ol>
     * <li>
     * <p>
     * If no <code>SourceProfileIds</code> entry is specified, the main Profile value is always taken.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a <code>SourceProfileIds</code> entry is specified, the specified profileId is always taken, even if it is a
     * NULL value.
     * </p>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * <p>
     * You can use MergeProfiles together with <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>, which
     * returns potentially matching profiles, or use it with the results of another matching system. After profiles have
     * been merged, they cannot be separated (unmerged).
     * </p>
     *
     * @param mergeProfilesRequest
     * @return Result of the MergeProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.MergeProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default MergeProfilesResponse mergeProfiles(MergeProfilesRequest mergeProfilesRequest) throws BadRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs an AWS Lambda job that does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the objects in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the <code>ProfileToBeMerged</code> will be deleted at the end.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileIdsToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * Standard fields are merged as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
     * </p>
     * </li>
     * <li>
     * <p>
     * When there are conflicting fields:
     * </p>
     * <ol>
     * <li>
     * <p>
     * If no <code>SourceProfileIds</code> entry is specified, the main Profile value is always taken.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a <code>SourceProfileIds</code> entry is specified, the specified profileId is always taken, even if it is a
     * NULL value.
     * </p>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * <p>
     * You can use MergeProfiles together with <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>, which
     * returns potentially matching profiles, or use it with the results of another matching system. After profiles have
     * been merged, they cannot be separated (unmerged).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergeProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link MergeProfilesRequest#builder()}
     * </p>
     *
     * @param mergeProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.MergeProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the MergeProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.MergeProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default MergeProfilesResponse mergeProfiles(Consumer<MergeProfilesRequest.Builder> mergeProfilesRequest)
            throws BadRequestException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, CustomerProfilesException {
        return mergeProfiles(MergeProfilesRequest.builder().applyMutation(mergeProfilesRequest).build());
    }

    /**
     * <p>
     * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon
     * Connect.
     * </p>
     * <p>
     * An integration can belong to only one domain.
     * </p>
     * <p>
     * To add or remove tags on an existing Integration, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource </a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">
     * UntagResource</a>.
     * </p>
     *
     * @param putIntegrationRequest
     * @return Result of the PutIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutIntegrationResponse putIntegration(PutIntegrationRequest putIntegrationRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon
     * Connect.
     * </p>
     * <p>
     * An integration can belong to only one domain.
     * </p>
     * <p>
     * To add or remove tags on an existing Integration, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource </a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">
     * UntagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link PutIntegrationRequest#builder()}
     * </p>
     *
     * @param putIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.PutIntegrationRequest.Builder} to create a
     *        request.
     * @return Result of the PutIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutIntegrationResponse putIntegration(Consumer<PutIntegrationRequest.Builder> putIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return putIntegration(PutIntegrationRequest.builder().applyMutation(putIntegrationRequest).build());
    }

    /**
     * <p>
     * Adds additional objects to customer profiles of a given ObjectType.
     * </p>
     * <p>
     * When adding a specific profile object, like a Contact Record, an inferred profile can get created if it is not
     * mapped to an existing profile. The resulting profile will only have a phone number populated in the standard
     * ProfileObject. Any additional Contact Records with the same phone number will be mapped to the same inferred
     * profile.
     * </p>
     * <p>
     * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide
     * data to a standard profile depending on the ProfileObjectType definition.
     * </p>
     * <p>
     * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
     * </p>
     *
     * @param putProfileObjectRequest
     * @return Result of the PutProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectResponse putProfileObject(PutProfileObjectRequest putProfileObjectRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds additional objects to customer profiles of a given ObjectType.
     * </p>
     * <p>
     * When adding a specific profile object, like a Contact Record, an inferred profile can get created if it is not
     * mapped to an existing profile. The resulting profile will only have a phone number populated in the standard
     * ProfileObject. Any additional Contact Records with the same phone number will be mapped to the same inferred
     * profile.
     * </p>
     * <p>
     * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide
     * data to a standard profile depending on the ProfileObjectType definition.
     * </p>
     * <p>
     * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProfileObjectRequest.Builder} avoiding the need
     * to create one manually via {@link PutProfileObjectRequest#builder()}
     * </p>
     *
     * @param putProfileObjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectRequest.Builder} to create a
     *        request.
     * @return Result of the PutProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectResponse putProfileObject(Consumer<PutProfileObjectRequest.Builder> putProfileObjectRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return putProfileObject(PutProfileObjectRequest.builder().applyMutation(putProfileObjectRequest).build());
    }

    /**
     * <p>
     * Defines a ProfileObjectType.
     * </p>
     * <p>
     * To add or remove tags on an existing ObjectType, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     *
     * @param putProfileObjectTypeRequest
     * @return Result of the PutProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectTypeResponse putProfileObjectType(PutProfileObjectTypeRequest putProfileObjectTypeRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines a ProfileObjectType.
     * </p>
     * <p>
     * To add or remove tags on an existing ObjectType, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProfileObjectTypeRequest.Builder} avoiding the
     * need to create one manually via {@link PutProfileObjectTypeRequest#builder()}
     * </p>
     *
     * @param putProfileObjectTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectTypeRequest.Builder} to
     *        create a request.
     * @return Result of the PutProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectTypeResponse putProfileObjectType(
            Consumer<PutProfileObjectTypeRequest.Builder> putProfileObjectTypeRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return putProfileObjectType(PutProfileObjectTypeRequest.builder().applyMutation(putProfileObjectTypeRequest).build());
    }

    /**
     * <p>
     * Searches for profiles within a specific domain using one or more predefined search keys (e.g., _fullName, _phone,
     * _email, _account, etc.) and/or custom-defined search keys. A search key is a data type pair that consists of a
     * <code>KeyName</code> and <code>Values</code> list.
     * </p>
     * <p>
     * This operation supports searching for profiles with a minimum of 1 key-value(s) pair and up to 5 key-value(s)
     * pairs using either <code>AND</code> or <code>OR</code> logic.
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(SearchProfilesRequest searchProfilesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for profiles within a specific domain using one or more predefined search keys (e.g., _fullName, _phone,
     * _email, _account, etc.) and/or custom-defined search keys. A search key is a data type pair that consists of a
     * <code>KeyName</code> and <code>Values</code> list.
     * </p>
     * <p>
     * This operation supports searching for profiles with a minimum of 1 key-value(s) pair and up to 5 key-value(s)
     * pairs using either <code>AND</code> or <code>OR</code> logic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProfilesRequest#builder()}
     * </p>
     *
     * @param searchProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.SearchProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(Consumer<SearchProfilesRequest.Builder> searchProfilesRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return searchProfiles(SearchProfilesRequest.builder().applyMutation(searchProfilesRequest).build());
    }

    /**
     * <p>
     * This API starts the processing of an upload job to ingest profile data.
     * </p>
     *
     * @param startUploadJobRequest
     * @return Result of the StartUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.StartUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/StartUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUploadJobResponse startUploadJob(StartUploadJobRequest startUploadJobRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API starts the processing of an upload job to ingest profile data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUploadJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartUploadJobRequest#builder()}
     * </p>
     *
     * @param startUploadJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.StartUploadJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.StartUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/StartUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUploadJobResponse startUploadJob(Consumer<StartUploadJobRequest.Builder> startUploadJobRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return startUploadJob(StartUploadJobRequest.builder().applyMutation(startUploadJobRequest).build());
    }

    /**
     * <p>
     * This API stops the processing of an upload job.
     * </p>
     *
     * @param stopUploadJobRequest
     * @return Result of the StopUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.StopUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/StopUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopUploadJobResponse stopUploadJob(StopUploadJobRequest stopUploadJobRequest) throws ResourceNotFoundException,
            InternalServerException, BadRequestException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API stops the processing of an upload job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopUploadJobRequest.Builder} avoiding the need to
     * create one manually via {@link StopUploadJobRequest#builder()}
     * </p>
     *
     * @param stopUploadJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.StopUploadJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopUploadJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.StopUploadJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/StopUploadJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopUploadJobResponse stopUploadJob(Consumer<StopUploadJobRequest.Builder> stopUploadJobRequest)
            throws ResourceNotFoundException, InternalServerException, BadRequestException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return stopUploadJob(StopUploadJobRequest.builder().applyMutation(stopUploadJobRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can
     * help you organize and categorize your resources. You can also use them to scope user permissions by granting a
     * user permission to access or change only resources with certain tag values. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * </p>
     * <p>
     * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag
     * is appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can
     * help you organize and categorize your resources. You can also use them to scope user permissions by granting a
     * user permission to access or change only resources with certain tag values. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * </p>
     * <p>
     * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag
     * is appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer
     * Profiles, domains, profile object types, and integrations can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer
     * Profiles, domains, profile object types, and integrations can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing calculated attribute definition. When updating the Conditions, note that increasing the date
     * range of a calculated attribute will not trigger inclusion of historical data greater than the current date
     * range.
     * </p>
     *
     * @param updateCalculatedAttributeDefinitionRequest
     * @return Result of the UpdateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCalculatedAttributeDefinitionResponse updateCalculatedAttributeDefinition(
            UpdateCalculatedAttributeDefinitionRequest updateCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing calculated attribute definition. When updating the Conditions, note that increasing the date
     * range of a calculated attribute will not trigger inclusion of historical data greater than the current date
     * range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param updateCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.UpdateCalculatedAttributeDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCalculatedAttributeDefinitionResponse updateCalculatedAttributeDefinition(
            Consumer<UpdateCalculatedAttributeDefinitionRequest.Builder> updateCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateCalculatedAttributeDefinition(UpdateCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(updateCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
     * </p>
     * <p>
     * After a domain is created, the name can’t be changed.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     * <p>
     * To add or remove tags on an existing Domain, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html">TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     *
     * @param updateDomainRequest
     * @return Result of the UpdateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainResponse updateDomain(UpdateDomainRequest updateDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
     * </p>
     * <p>
     * After a domain is created, the name can’t be changed.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     * <p>
     * To add or remove tags on an existing Domain, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html">TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDomainRequest#builder()}
     * </p>
     *
     * @param updateDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.UpdateDomainRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainResponse updateDomain(Consumer<UpdateDomainRequest.Builder> updateDomainRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateDomain(UpdateDomainRequest.builder().applyMutation(updateDomainRequest).build());
    }

    /**
     * <p>
     * Updates the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect
     * admin website.
     * </p>
     *
     * @param updateDomainLayoutRequest
     * @return Result of the UpdateDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainLayoutResponse updateDomainLayout(UpdateDomainLayoutRequest updateDomainLayoutRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect
     * admin website.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainLayoutRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDomainLayoutRequest#builder()}
     * </p>
     *
     * @param updateDomainLayoutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.UpdateDomainLayoutRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDomainLayout operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateDomainLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomainLayout"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainLayoutResponse updateDomainLayout(Consumer<UpdateDomainLayoutRequest.Builder> updateDomainLayoutRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateDomainLayout(UpdateDomainLayoutRequest.builder().applyMutation(updateDomainLayoutRequest).build());
    }

    /**
     * <p>
     * Update the properties of an Event Trigger.
     * </p>
     *
     * @param updateEventTriggerRequest
     * @return Result of the UpdateEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventTriggerResponse updateEventTrigger(UpdateEventTriggerRequest updateEventTriggerRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the properties of an Event Trigger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventTriggerRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventTriggerRequest#builder()}
     * </p>
     *
     * @param updateEventTriggerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.UpdateEventTriggerRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateEventTrigger operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateEventTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateEventTrigger"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventTriggerResponse updateEventTrigger(Consumer<UpdateEventTriggerRequest.Builder> updateEventTriggerRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateEventTrigger(UpdateEventTriggerRequest.builder().applyMutation(updateEventTriggerRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
     * </p>
     * <p>
     * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be
     * removed. Not specifying a string value means that any value already there will be kept.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
     * </p>
     * <p>
     * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be
     * removed. Not specifying a string value means that any value already there will be kept.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.customerprofiles.model.UpdateProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * Create a {@link CustomerProfilesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CustomerProfilesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CustomerProfilesClient}.
     */
    static CustomerProfilesClientBuilder builder() {
        return new DefaultCustomerProfilesClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CustomerProfilesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
