/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure holding all <code>APPFLOW_INTEGRATION</code> specific workflow attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppflowIntegrationWorkflowAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AppflowIntegrationWorkflowAttributes.Builder, AppflowIntegrationWorkflowAttributes> {
    private static final SdkField<String> SOURCE_CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceConnectorType").getter(getter(AppflowIntegrationWorkflowAttributes::sourceConnectorTypeAsString))
            .setter(setter(Builder::sourceConnectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConnectorType").build())
            .build();

    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorProfileName").getter(getter(AppflowIntegrationWorkflowAttributes::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorProfileName").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AppflowIntegrationWorkflowAttributes::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CONNECTOR_TYPE_FIELD,
            CONNECTOR_PROFILE_NAME_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceConnectorType;

    private final String connectorProfileName;

    private final String roleArn;

    private AppflowIntegrationWorkflowAttributes(BuilderImpl builder) {
        this.sourceConnectorType = builder.sourceConnectorType;
        this.connectorProfileName = builder.connectorProfileName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceConnectorType} will return {@link SourceConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sourceConnectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of
     *         ingestion.
     * @see SourceConnectorType
     */
    public final SourceConnectorType sourceConnectorType() {
        return SourceConnectorType.fromValue(sourceConnectorType);
    }

    /**
     * <p>
     * Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of ingestion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceConnectorType} will return {@link SourceConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sourceConnectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of
     *         ingestion.
     * @see SourceConnectorType
     */
    public final String sourceConnectorTypeAsString() {
        return sourceConnectorType;
    }

    /**
     * <p>
     * The name of the AppFlow connector profile used for ingestion.
     * </p>
     * 
     * @return The name of the AppFlow connector profile used for ingestion.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your
     * behalf as part of workflow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources
     *         on your behalf as part of workflow execution.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceConnectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppflowIntegrationWorkflowAttributes)) {
            return false;
        }
        AppflowIntegrationWorkflowAttributes other = (AppflowIntegrationWorkflowAttributes) obj;
        return Objects.equals(sourceConnectorTypeAsString(), other.sourceConnectorTypeAsString())
                && Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppflowIntegrationWorkflowAttributes").add("SourceConnectorType", sourceConnectorTypeAsString())
                .add("ConnectorProfileName", connectorProfileName()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceConnectorType":
            return Optional.ofNullable(clazz.cast(sourceConnectorTypeAsString()));
        case "ConnectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceConnectorType", SOURCE_CONNECTOR_TYPE_FIELD);
        map.put("ConnectorProfileName", CONNECTOR_PROFILE_NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppflowIntegrationWorkflowAttributes, T> g) {
        return obj -> g.apply((AppflowIntegrationWorkflowAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppflowIntegrationWorkflowAttributes> {
        /**
         * <p>
         * Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of
         * ingestion.
         * </p>
         * 
         * @param sourceConnectorType
         *        Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of
         *        ingestion.
         * @see SourceConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceConnectorType
         */
        Builder sourceConnectorType(String sourceConnectorType);

        /**
         * <p>
         * Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of
         * ingestion.
         * </p>
         * 
         * @param sourceConnectorType
         *        Specifies the source connector type, such as Salesforce, ServiceNow, and Marketo. Indicates source of
         *        ingestion.
         * @see SourceConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceConnectorType
         */
        Builder sourceConnectorType(SourceConnectorType sourceConnectorType);

        /**
         * <p>
         * The name of the AppFlow connector profile used for ingestion.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the AppFlow connector profile used for ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on
         * your behalf as part of workflow execution.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create
         *        resources on your behalf as part of workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String sourceConnectorType;

        private String connectorProfileName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AppflowIntegrationWorkflowAttributes model) {
            sourceConnectorType(model.sourceConnectorType);
            connectorProfileName(model.connectorProfileName);
            roleArn(model.roleArn);
        }

        public final String getSourceConnectorType() {
            return sourceConnectorType;
        }

        public final void setSourceConnectorType(String sourceConnectorType) {
            this.sourceConnectorType = sourceConnectorType;
        }

        @Override
        public final Builder sourceConnectorType(String sourceConnectorType) {
            this.sourceConnectorType = sourceConnectorType;
            return this;
        }

        @Override
        public final Builder sourceConnectorType(SourceConnectorType sourceConnectorType) {
            this.sourceConnectorType(sourceConnectorType == null ? null : sourceConnectorType.toString());
            return this;
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public AppflowIntegrationWorkflowAttributes build() {
            return new AppflowIntegrationWorkflowAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
