/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCalculatedAttributeForProfileRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<BatchGetCalculatedAttributeForProfileRequest.Builder, BatchGetCalculatedAttributeForProfileRequest> {
    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatedAttributeName")
            .getter(getter(BatchGetCalculatedAttributeForProfileRequest::calculatedAttributeName))
            .setter(setter(Builder::calculatedAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatedAttributeName").build())
            .build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(BatchGetCalculatedAttributeForProfileRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProfileIds")
            .getter(getter(BatchGetCalculatedAttributeForProfileRequest::profileIds))
            .setter(setter(Builder::profileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConditionOverrides> CONDITION_OVERRIDES_FIELD = SdkField
            .<ConditionOverrides> builder(MarshallingType.SDK_POJO).memberName("ConditionOverrides")
            .getter(getter(BatchGetCalculatedAttributeForProfileRequest::conditionOverrides))
            .setter(setter(Builder::conditionOverrides)).constructor(ConditionOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionOverrides").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CALCULATED_ATTRIBUTE_NAME_FIELD, DOMAIN_NAME_FIELD, PROFILE_IDS_FIELD, CONDITION_OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String calculatedAttributeName;

    private final String domainName;

    private final List<String> profileIds;

    private final ConditionOverrides conditionOverrides;

    private BatchGetCalculatedAttributeForProfileRequest(BuilderImpl builder) {
        super(builder);
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.domainName = builder.domainName;
        this.profileIds = builder.profileIds;
        this.conditionOverrides = builder.conditionOverrides;
    }

    /**
     * <p>
     * The unique name of the calculated attribute.
     * </p>
     * 
     * @return The unique name of the calculated attribute.
     */
    public final String calculatedAttributeName() {
        return calculatedAttributeName;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfileIds() {
        return profileIds != null && !(profileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of unique identifiers for customer profiles to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileIds} method.
     * </p>
     * 
     * @return List of unique identifiers for customer profiles to retrieve.
     */
    public final List<String> profileIds() {
        return profileIds;
    }

    /**
     * <p>
     * Overrides the condition block within the original calculated attribute definition.
     * </p>
     * 
     * @return Overrides the condition block within the original calculated attribute definition.
     */
    public final ConditionOverrides conditionOverrides() {
        return conditionOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileIds() ? profileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conditionOverrides());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCalculatedAttributeForProfileRequest)) {
            return false;
        }
        BatchGetCalculatedAttributeForProfileRequest other = (BatchGetCalculatedAttributeForProfileRequest) obj;
        return Objects.equals(calculatedAttributeName(), other.calculatedAttributeName())
                && Objects.equals(domainName(), other.domainName()) && hasProfileIds() == other.hasProfileIds()
                && Objects.equals(profileIds(), other.profileIds())
                && Objects.equals(conditionOverrides(), other.conditionOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCalculatedAttributeForProfileRequest")
                .add("CalculatedAttributeName", calculatedAttributeName()).add("DomainName", domainName())
                .add("ProfileIds", hasProfileIds() ? profileIds() : null)
                .add("ConditionOverrides", conditionOverrides() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculatedAttributeName":
            return Optional.ofNullable(clazz.cast(calculatedAttributeName()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ProfileIds":
            return Optional.ofNullable(clazz.cast(profileIds()));
        case "ConditionOverrides":
            return Optional.ofNullable(clazz.cast(conditionOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CalculatedAttributeName", CALCULATED_ATTRIBUTE_NAME_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ProfileIds", PROFILE_IDS_FIELD);
        map.put("ConditionOverrides", CONDITION_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCalculatedAttributeForProfileRequest, T> g) {
        return obj -> g.apply((BatchGetCalculatedAttributeForProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetCalculatedAttributeForProfileRequest> {
        /**
         * <p>
         * The unique name of the calculated attribute.
         * </p>
         * 
         * @param calculatedAttributeName
         *        The unique name of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedAttributeName(String calculatedAttributeName);

        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * List of unique identifiers for customer profiles to retrieve.
         * </p>
         * 
         * @param profileIds
         *        List of unique identifiers for customer profiles to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(Collection<String> profileIds);

        /**
         * <p>
         * List of unique identifiers for customer profiles to retrieve.
         * </p>
         * 
         * @param profileIds
         *        List of unique identifiers for customer profiles to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(String... profileIds);

        /**
         * <p>
         * Overrides the condition block within the original calculated attribute definition.
         * </p>
         * 
         * @param conditionOverrides
         *        Overrides the condition block within the original calculated attribute definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionOverrides(ConditionOverrides conditionOverrides);

        /**
         * <p>
         * Overrides the condition block within the original calculated attribute definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionOverrides.Builder} avoiding the
         * need to create one manually via {@link ConditionOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #conditionOverrides(ConditionOverrides)}.
         * 
         * @param conditionOverrides
         *        a consumer that will call methods on {@link ConditionOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionOverrides(ConditionOverrides)
         */
        default Builder conditionOverrides(Consumer<ConditionOverrides.Builder> conditionOverrides) {
            return conditionOverrides(ConditionOverrides.builder().applyMutation(conditionOverrides).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String calculatedAttributeName;

        private String domainName;

        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();

        private ConditionOverrides conditionOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCalculatedAttributeForProfileRequest model) {
            super(model);
            calculatedAttributeName(model.calculatedAttributeName);
            domainName(model.domainName);
            profileIds(model.profileIds);
            conditionOverrides(model.conditionOverrides);
        }

        public final String getCalculatedAttributeName() {
            return calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getProfileIds() {
            if (profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return profileIds;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = BatchGetCalculatedAttributeForProfileIdListCopier.copy(profileIds);
        }

        @Override
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = BatchGetCalculatedAttributeForProfileIdListCopier.copy(profileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIds(String... profileIds) {
            profileIds(Arrays.asList(profileIds));
            return this;
        }

        public final ConditionOverrides.Builder getConditionOverrides() {
            return conditionOverrides != null ? conditionOverrides.toBuilder() : null;
        }

        public final void setConditionOverrides(ConditionOverrides.BuilderImpl conditionOverrides) {
            this.conditionOverrides = conditionOverrides != null ? conditionOverrides.build() : null;
        }

        @Override
        public final Builder conditionOverrides(ConditionOverrides conditionOverrides) {
            this.conditionOverrides = conditionOverrides;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCalculatedAttributeForProfileRequest build() {
            return new BatchGetCalculatedAttributeForProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
