/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCalculatedAttributeForProfileResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<BatchGetCalculatedAttributeForProfileResponse.Builder, BatchGetCalculatedAttributeForProfileResponse> {
    private static final SdkField<List<BatchGetCalculatedAttributeForProfileError>> ERRORS_FIELD = SdkField
            .<List<BatchGetCalculatedAttributeForProfileError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetCalculatedAttributeForProfileResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetCalculatedAttributeForProfileError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetCalculatedAttributeForProfileError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CalculatedAttributeValue>> CALCULATED_ATTRIBUTE_VALUES_FIELD = SdkField
            .<List<CalculatedAttributeValue>> builder(MarshallingType.LIST)
            .memberName("CalculatedAttributeValues")
            .getter(getter(BatchGetCalculatedAttributeForProfileResponse::calculatedAttributeValues))
            .setter(setter(Builder::calculatedAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedAttributeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CalculatedAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(CalculatedAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConditionOverrides> CONDITION_OVERRIDES_FIELD = SdkField
            .<ConditionOverrides> builder(MarshallingType.SDK_POJO).memberName("ConditionOverrides")
            .getter(getter(BatchGetCalculatedAttributeForProfileResponse::conditionOverrides))
            .setter(setter(Builder::conditionOverrides)).constructor(ConditionOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionOverrides").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            CALCULATED_ATTRIBUTE_VALUES_FIELD, CONDITION_OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetCalculatedAttributeForProfileError> errors;

    private final List<CalculatedAttributeValue> calculatedAttributeValues;

    private final ConditionOverrides conditionOverrides;

    private BatchGetCalculatedAttributeForProfileResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.calculatedAttributeValues = builder.calculatedAttributeValues;
        this.conditionOverrides = builder.conditionOverrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of errors for calculated attribute values that could not be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return List of errors for calculated attribute values that could not be retrieved.
     */
    public final List<BatchGetCalculatedAttributeForProfileError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalculatedAttributeValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCalculatedAttributeValues() {
        return calculatedAttributeValues != null && !(calculatedAttributeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of calculated attribute values retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalculatedAttributeValues} method.
     * </p>
     * 
     * @return List of calculated attribute values retrieved.
     */
    public final List<CalculatedAttributeValue> calculatedAttributeValues() {
        return calculatedAttributeValues;
    }

    /**
     * <p>
     * Overrides the condition block within the original calculated attribute definition.
     * </p>
     * 
     * @return Overrides the condition block within the original calculated attribute definition.
     */
    public final ConditionOverrides conditionOverrides() {
        return conditionOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCalculatedAttributeValues() ? calculatedAttributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conditionOverrides());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCalculatedAttributeForProfileResponse)) {
            return false;
        }
        BatchGetCalculatedAttributeForProfileResponse other = (BatchGetCalculatedAttributeForProfileResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasCalculatedAttributeValues() == other.hasCalculatedAttributeValues()
                && Objects.equals(calculatedAttributeValues(), other.calculatedAttributeValues())
                && Objects.equals(conditionOverrides(), other.conditionOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCalculatedAttributeForProfileResponse").add("Errors", hasErrors() ? errors() : null)
                .add("CalculatedAttributeValues", hasCalculatedAttributeValues() ? calculatedAttributeValues() : null)
                .add("ConditionOverrides", conditionOverrides() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "CalculatedAttributeValues":
            return Optional.ofNullable(clazz.cast(calculatedAttributeValues()));
        case "ConditionOverrides":
            return Optional.ofNullable(clazz.cast(conditionOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Errors", ERRORS_FIELD);
        map.put("CalculatedAttributeValues", CALCULATED_ATTRIBUTE_VALUES_FIELD);
        map.put("ConditionOverrides", CONDITION_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCalculatedAttributeForProfileResponse, T> g) {
        return obj -> g.apply((BatchGetCalculatedAttributeForProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetCalculatedAttributeForProfileResponse> {
        /**
         * <p>
         * List of errors for calculated attribute values that could not be retrieved.
         * </p>
         * 
         * @param errors
         *        List of errors for calculated attribute values that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetCalculatedAttributeForProfileError> errors);

        /**
         * <p>
         * List of errors for calculated attribute values that could not be retrieved.
         * </p>
         * 
         * @param errors
         *        List of errors for calculated attribute values that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetCalculatedAttributeForProfileError... errors);

        /**
         * <p>
         * List of errors for calculated attribute values that could not be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileError#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileError.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errors(List<BatchGetCalculatedAttributeForProfileError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetCalculatedAttributeForProfileError>)
         */
        Builder errors(Consumer<BatchGetCalculatedAttributeForProfileError.Builder>... errors);

        /**
         * <p>
         * List of calculated attribute values retrieved.
         * </p>
         * 
         * @param calculatedAttributeValues
         *        List of calculated attribute values retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedAttributeValues(Collection<CalculatedAttributeValue> calculatedAttributeValues);

        /**
         * <p>
         * List of calculated attribute values retrieved.
         * </p>
         * 
         * @param calculatedAttributeValues
         *        List of calculated attribute values retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedAttributeValues(CalculatedAttributeValue... calculatedAttributeValues);

        /**
         * <p>
         * List of calculated attribute values retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.CalculatedAttributeValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.CalculatedAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.CalculatedAttributeValue.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #calculatedAttributeValues(List<CalculatedAttributeValue>)}.
         * 
         * @param calculatedAttributeValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.CalculatedAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedAttributeValues(java.util.Collection<CalculatedAttributeValue>)
         */
        Builder calculatedAttributeValues(Consumer<CalculatedAttributeValue.Builder>... calculatedAttributeValues);

        /**
         * <p>
         * Overrides the condition block within the original calculated attribute definition.
         * </p>
         * 
         * @param conditionOverrides
         *        Overrides the condition block within the original calculated attribute definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionOverrides(ConditionOverrides conditionOverrides);

        /**
         * <p>
         * Overrides the condition block within the original calculated attribute definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionOverrides.Builder} avoiding the
         * need to create one manually via {@link ConditionOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #conditionOverrides(ConditionOverrides)}.
         * 
         * @param conditionOverrides
         *        a consumer that will call methods on {@link ConditionOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionOverrides(ConditionOverrides)
         */
        default Builder conditionOverrides(Consumer<ConditionOverrides.Builder> conditionOverrides) {
            return conditionOverrides(ConditionOverrides.builder().applyMutation(conditionOverrides).build());
        }
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private List<BatchGetCalculatedAttributeForProfileError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<CalculatedAttributeValue> calculatedAttributeValues = DefaultSdkAutoConstructList.getInstance();

        private ConditionOverrides conditionOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCalculatedAttributeForProfileResponse model) {
            super(model);
            errors(model.errors);
            calculatedAttributeValues(model.calculatedAttributeValues);
            conditionOverrides(model.conditionOverrides);
        }

        public final List<BatchGetCalculatedAttributeForProfileError.Builder> getErrors() {
            List<BatchGetCalculatedAttributeForProfileError.Builder> result = BatchGetCalculatedAttributeForProfileErrorListCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetCalculatedAttributeForProfileError.BuilderImpl> errors) {
            this.errors = BatchGetCalculatedAttributeForProfileErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetCalculatedAttributeForProfileError> errors) {
            this.errors = BatchGetCalculatedAttributeForProfileErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetCalculatedAttributeForProfileError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetCalculatedAttributeForProfileError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetCalculatedAttributeForProfileError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CalculatedAttributeValue.Builder> getCalculatedAttributeValues() {
            List<CalculatedAttributeValue.Builder> result = CalculatedAttributeValueListCopier
                    .copyToBuilder(this.calculatedAttributeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedAttributeValues(Collection<CalculatedAttributeValue.BuilderImpl> calculatedAttributeValues) {
            this.calculatedAttributeValues = CalculatedAttributeValueListCopier.copyFromBuilder(calculatedAttributeValues);
        }

        @Override
        public final Builder calculatedAttributeValues(Collection<CalculatedAttributeValue> calculatedAttributeValues) {
            this.calculatedAttributeValues = CalculatedAttributeValueListCopier.copy(calculatedAttributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedAttributeValues(CalculatedAttributeValue... calculatedAttributeValues) {
            calculatedAttributeValues(Arrays.asList(calculatedAttributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedAttributeValues(Consumer<CalculatedAttributeValue.Builder>... calculatedAttributeValues) {
            calculatedAttributeValues(Stream.of(calculatedAttributeValues)
                    .map(c -> CalculatedAttributeValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConditionOverrides.Builder getConditionOverrides() {
            return conditionOverrides != null ? conditionOverrides.toBuilder() : null;
        }

        public final void setConditionOverrides(ConditionOverrides.BuilderImpl conditionOverrides) {
            this.conditionOverrides = conditionOverrides != null ? conditionOverrides.build() : null;
        }

        @Override
        public final Builder conditionOverrides(ConditionOverrides conditionOverrides) {
            this.conditionOverrides = conditionOverrides;
            return this;
        }

        @Override
        public BatchGetCalculatedAttributeForProfileResponse build() {
            return new BatchGetCalculatedAttributeForProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
