/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object to override the original condition block of a calculated attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionOverrides.Builder, ConditionOverrides> {
    private static final SdkField<RangeOverride> RANGE_FIELD = SdkField.<RangeOverride> builder(MarshallingType.SDK_POJO)
            .memberName("Range").getter(getter(ConditionOverrides::range)).setter(setter(Builder::range))
            .constructor(RangeOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RangeOverride range;

    private ConditionOverrides(BuilderImpl builder) {
        this.range = builder.range;
    }

    /**
     * <p>
     * The relative time period over which data is included in the aggregation for this override.
     * </p>
     * 
     * @return The relative time period over which data is included in the aggregation for this override.
     */
    public final RangeOverride range() {
        return range;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(range());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionOverrides)) {
            return false;
        }
        ConditionOverrides other = (ConditionOverrides) obj;
        return Objects.equals(range(), other.range());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionOverrides").add("Range", range()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Range", RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionOverrides, T> g) {
        return obj -> g.apply((ConditionOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionOverrides> {
        /**
         * <p>
         * The relative time period over which data is included in the aggregation for this override.
         * </p>
         * 
         * @param range
         *        The relative time period over which data is included in the aggregation for this override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(RangeOverride range);

        /**
         * <p>
         * The relative time period over which data is included in the aggregation for this override.
         * </p>
         * This is a convenience method that creates an instance of the {@link RangeOverride.Builder} avoiding the need
         * to create one manually via {@link RangeOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RangeOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #range(RangeOverride)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link RangeOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(RangeOverride)
         */
        default Builder range(Consumer<RangeOverride.Builder> range) {
            return range(RangeOverride.builder().applyMutation(range).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RangeOverride range;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionOverrides model) {
            range(model.range);
        }

        public final RangeOverride.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(RangeOverride.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(RangeOverride range) {
            this.range = range;
            return this;
        }

        @Override
        public ConditionOverrides build() {
            return new ConditionOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
