/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How the auto-merging process should resolve conflicts between different profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictResolution implements SdkPojo, Serializable,
        ToCopyableBuilder<ConflictResolution.Builder, ConflictResolution> {
    private static final SdkField<String> CONFLICT_RESOLVING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConflictResolvingModel").getter(getter(ConflictResolution::conflictResolvingModelAsString))
            .setter(setter(Builder::conflictResolvingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictResolvingModel").build())
            .build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceName").getter(getter(ConflictResolution::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFLICT_RESOLVING_MODEL_FIELD, SOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conflictResolvingModel;

    private final String sourceName;

    private ConflictResolution(BuilderImpl builder) {
        this.conflictResolvingModel = builder.conflictResolvingModel;
        this.sourceName = builder.sourceName;
    }

    /**
     * <p>
     * How the auto-merging process should resolve conflicts between different profiles.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RECENCY</code>: Uses the data that was most recently updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired or two
     * departments have merged, data from the specified source is used. If two duplicate profiles are from the same
     * source, then <code>RECENCY</code> is used again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolvingModel} will return {@link ConflictResolvingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conflictResolvingModelAsString}.
     * </p>
     * 
     * @return How the auto-merging process should resolve conflicts between different profiles.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RECENCY</code>: Uses the data that was most recently updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired or
     *         two departments have merged, data from the specified source is used. If two duplicate profiles are from
     *         the same source, then <code>RECENCY</code> is used again.
     *         </p>
     *         </li>
     * @see ConflictResolvingModel
     */
    public final ConflictResolvingModel conflictResolvingModel() {
        return ConflictResolvingModel.fromValue(conflictResolvingModel);
    }

    /**
     * <p>
     * How the auto-merging process should resolve conflicts between different profiles.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RECENCY</code>: Uses the data that was most recently updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired or two
     * departments have merged, data from the specified source is used. If two duplicate profiles are from the same
     * source, then <code>RECENCY</code> is used again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolvingModel} will return {@link ConflictResolvingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conflictResolvingModelAsString}.
     * </p>
     * 
     * @return How the auto-merging process should resolve conflicts between different profiles.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RECENCY</code>: Uses the data that was most recently updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired or
     *         two departments have merged, data from the specified source is used. If two duplicate profiles are from
     *         the same source, then <code>RECENCY</code> is used again.
     *         </p>
     *         </li>
     * @see ConflictResolvingModel
     */
    public final String conflictResolvingModelAsString() {
        return conflictResolvingModel;
    }

    /**
     * <p>
     * The <code>ObjectType</code> name that is used to resolve profile merging conflicts when choosing
     * <code>SOURCE</code> as the <code>ConflictResolvingModel</code>.
     * </p>
     * 
     * @return The <code>ObjectType</code> name that is used to resolve profile merging conflicts when choosing
     *         <code>SOURCE</code> as the <code>ConflictResolvingModel</code>.
     */
    public final String sourceName() {
        return sourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolvingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictResolution)) {
            return false;
        }
        ConflictResolution other = (ConflictResolution) obj;
        return Objects.equals(conflictResolvingModelAsString(), other.conflictResolvingModelAsString())
                && Objects.equals(sourceName(), other.sourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConflictResolution").add("ConflictResolvingModel", conflictResolvingModelAsString())
                .add("SourceName", sourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConflictResolvingModel":
            return Optional.ofNullable(clazz.cast(conflictResolvingModelAsString()));
        case "SourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConflictResolvingModel", CONFLICT_RESOLVING_MODEL_FIELD);
        map.put("SourceName", SOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConflictResolution, T> g) {
        return obj -> g.apply((ConflictResolution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictResolution> {
        /**
         * <p>
         * How the auto-merging process should resolve conflicts between different profiles.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RECENCY</code>: Uses the data that was most recently updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired or two
         * departments have merged, data from the specified source is used. If two duplicate profiles are from the same
         * source, then <code>RECENCY</code> is used again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictResolvingModel
         *        How the auto-merging process should resolve conflicts between different profiles.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RECENCY</code>: Uses the data that was most recently updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired
         *        or two departments have merged, data from the specified source is used. If two duplicate profiles are
         *        from the same source, then <code>RECENCY</code> is used again.
         *        </p>
         *        </li>
         * @see ConflictResolvingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolvingModel
         */
        Builder conflictResolvingModel(String conflictResolvingModel);

        /**
         * <p>
         * How the auto-merging process should resolve conflicts between different profiles.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RECENCY</code>: Uses the data that was most recently updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired or two
         * departments have merged, data from the specified source is used. If two duplicate profiles are from the same
         * source, then <code>RECENCY</code> is used again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictResolvingModel
         *        How the auto-merging process should resolve conflicts between different profiles.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RECENCY</code>: Uses the data that was most recently updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SOURCE</code>: Uses the data from a specific source. For example, if a company has been aquired
         *        or two departments have merged, data from the specified source is used. If two duplicate profiles are
         *        from the same source, then <code>RECENCY</code> is used again.
         *        </p>
         *        </li>
         * @see ConflictResolvingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolvingModel
         */
        Builder conflictResolvingModel(ConflictResolvingModel conflictResolvingModel);

        /**
         * <p>
         * The <code>ObjectType</code> name that is used to resolve profile merging conflicts when choosing
         * <code>SOURCE</code> as the <code>ConflictResolvingModel</code>.
         * </p>
         * 
         * @param sourceName
         *        The <code>ObjectType</code> name that is used to resolve profile merging conflicts when choosing
         *        <code>SOURCE</code> as the <code>ConflictResolvingModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);
    }

    static final class BuilderImpl implements Builder {
        private String conflictResolvingModel;

        private String sourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictResolution model) {
            conflictResolvingModel(model.conflictResolvingModel);
            sourceName(model.sourceName);
        }

        public final String getConflictResolvingModel() {
            return conflictResolvingModel;
        }

        public final void setConflictResolvingModel(String conflictResolvingModel) {
            this.conflictResolvingModel = conflictResolvingModel;
        }

        @Override
        public final Builder conflictResolvingModel(String conflictResolvingModel) {
            this.conflictResolvingModel = conflictResolvingModel;
            return this;
        }

        @Override
        public final Builder conflictResolvingModel(ConflictResolvingModel conflictResolvingModel) {
            this.conflictResolvingModel(conflictResolvingModel == null ? null : conflictResolvingModel.toString());
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public ConflictResolution build() {
            return new ConflictResolution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
