/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation to be performed on the provided source fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorOperator implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorOperator.Builder, ConnectorOperator> {
    private static final SdkField<String> MARKETO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marketo")
            .getter(getter(ConnectorOperator::marketoAsString)).setter(setter(Builder::marketo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()).build();

    private static final SdkField<String> S3_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3")
            .getter(getter(ConnectorOperator::s3AsString)).setter(setter(Builder::s3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final SdkField<String> SALESFORCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Salesforce").getter(getter(ConnectorOperator::salesforceAsString)).setter(setter(Builder::salesforce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<String> SERVICE_NOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNow").getter(getter(ConnectorOperator::serviceNowAsString)).setter(setter(Builder::serviceNow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final SdkField<String> ZENDESK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Zendesk")
            .getter(getter(ConnectorOperator::zendeskAsString)).setter(setter(Builder::zendesk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKETO_FIELD, S3_FIELD,
            SALESFORCE_FIELD, SERVICE_NOW_FIELD, ZENDESK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String marketo;

    private final String s3;

    private final String salesforce;

    private final String serviceNow;

    private final String zendesk;

    private ConnectorOperator(BuilderImpl builder) {
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.zendesk = builder.zendesk;
    }

    /**
     * <p>
     * The operation to be performed on the provided Marketo source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketo} will
     * return {@link MarketoConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #marketoAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Marketo source fields.
     * @see MarketoConnectorOperator
     */
    public final MarketoConnectorOperator marketo() {
        return MarketoConnectorOperator.fromValue(marketo);
    }

    /**
     * <p>
     * The operation to be performed on the provided Marketo source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketo} will
     * return {@link MarketoConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #marketoAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Marketo source fields.
     * @see MarketoConnectorOperator
     */
    public final String marketoAsString() {
        return marketo;
    }

    /**
     * <p>
     * The operation to be performed on the provided Amazon S3 source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3} will return
     * {@link S3ConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Amazon S3 source fields.
     * @see S3ConnectorOperator
     */
    public final S3ConnectorOperator s3() {
        return S3ConnectorOperator.fromValue(s3);
    }

    /**
     * <p>
     * The operation to be performed on the provided Amazon S3 source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3} will return
     * {@link S3ConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Amazon S3 source fields.
     * @see S3ConnectorOperator
     */
    public final String s3AsString() {
        return s3;
    }

    /**
     * <p>
     * The operation to be performed on the provided Salesforce source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #salesforce} will
     * return {@link SalesforceConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #salesforceAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Salesforce source fields.
     * @see SalesforceConnectorOperator
     */
    public final SalesforceConnectorOperator salesforce() {
        return SalesforceConnectorOperator.fromValue(salesforce);
    }

    /**
     * <p>
     * The operation to be performed on the provided Salesforce source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #salesforce} will
     * return {@link SalesforceConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #salesforceAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Salesforce source fields.
     * @see SalesforceConnectorOperator
     */
    public final String salesforceAsString() {
        return salesforce;
    }

    /**
     * <p>
     * The operation to be performed on the provided ServiceNow source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNow} will
     * return {@link ServiceNowConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceNowAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided ServiceNow source fields.
     * @see ServiceNowConnectorOperator
     */
    public final ServiceNowConnectorOperator serviceNow() {
        return ServiceNowConnectorOperator.fromValue(serviceNow);
    }

    /**
     * <p>
     * The operation to be performed on the provided ServiceNow source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNow} will
     * return {@link ServiceNowConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceNowAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided ServiceNow source fields.
     * @see ServiceNowConnectorOperator
     */
    public final String serviceNowAsString() {
        return serviceNow;
    }

    /**
     * <p>
     * The operation to be performed on the provided Zendesk source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zendesk} will
     * return {@link ZendeskConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #zendeskAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Zendesk source fields.
     * @see ZendeskConnectorOperator
     */
    public final ZendeskConnectorOperator zendesk() {
        return ZendeskConnectorOperator.fromValue(zendesk);
    }

    /**
     * <p>
     * The operation to be performed on the provided Zendesk source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zendesk} will
     * return {@link ZendeskConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #zendeskAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Zendesk source fields.
     * @see ZendeskConnectorOperator
     */
    public final String zendeskAsString() {
        return zendesk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marketoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3AsString());
        hashCode = 31 * hashCode + Objects.hashCode(salesforceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zendeskAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOperator)) {
            return false;
        }
        ConnectorOperator other = (ConnectorOperator) obj;
        return Objects.equals(marketoAsString(), other.marketoAsString()) && Objects.equals(s3AsString(), other.s3AsString())
                && Objects.equals(salesforceAsString(), other.salesforceAsString())
                && Objects.equals(serviceNowAsString(), other.serviceNowAsString())
                && Objects.equals(zendeskAsString(), other.zendeskAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorOperator").add("Marketo", marketoAsString()).add("S3", s3AsString())
                .add("Salesforce", salesforceAsString()).add("ServiceNow", serviceNowAsString())
                .add("Zendesk", zendeskAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marketo":
            return Optional.ofNullable(clazz.cast(marketoAsString()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3AsString()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforceAsString()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNowAsString()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendeskAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marketo", MARKETO_FIELD);
        map.put("S3", S3_FIELD);
        map.put("Salesforce", SALESFORCE_FIELD);
        map.put("ServiceNow", SERVICE_NOW_FIELD);
        map.put("Zendesk", ZENDESK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOperator, T> g) {
        return obj -> g.apply((ConnectorOperator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorOperator> {
        /**
         * <p>
         * The operation to be performed on the provided Marketo source fields.
         * </p>
         * 
         * @param marketo
         *        The operation to be performed on the provided Marketo source fields.
         * @see MarketoConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketoConnectorOperator
         */
        Builder marketo(String marketo);

        /**
         * <p>
         * The operation to be performed on the provided Marketo source fields.
         * </p>
         * 
         * @param marketo
         *        The operation to be performed on the provided Marketo source fields.
         * @see MarketoConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketoConnectorOperator
         */
        Builder marketo(MarketoConnectorOperator marketo);

        /**
         * <p>
         * The operation to be performed on the provided Amazon S3 source fields.
         * </p>
         * 
         * @param s3
         *        The operation to be performed on the provided Amazon S3 source fields.
         * @see S3ConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3ConnectorOperator
         */
        Builder s3(String s3);

        /**
         * <p>
         * The operation to be performed on the provided Amazon S3 source fields.
         * </p>
         * 
         * @param s3
         *        The operation to be performed on the provided Amazon S3 source fields.
         * @see S3ConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3ConnectorOperator
         */
        Builder s3(S3ConnectorOperator s3);

        /**
         * <p>
         * The operation to be performed on the provided Salesforce source fields.
         * </p>
         * 
         * @param salesforce
         *        The operation to be performed on the provided Salesforce source fields.
         * @see SalesforceConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceConnectorOperator
         */
        Builder salesforce(String salesforce);

        /**
         * <p>
         * The operation to be performed on the provided Salesforce source fields.
         * </p>
         * 
         * @param salesforce
         *        The operation to be performed on the provided Salesforce source fields.
         * @see SalesforceConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceConnectorOperator
         */
        Builder salesforce(SalesforceConnectorOperator salesforce);

        /**
         * <p>
         * The operation to be performed on the provided ServiceNow source fields.
         * </p>
         * 
         * @param serviceNow
         *        The operation to be performed on the provided ServiceNow source fields.
         * @see ServiceNowConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNowConnectorOperator
         */
        Builder serviceNow(String serviceNow);

        /**
         * <p>
         * The operation to be performed on the provided ServiceNow source fields.
         * </p>
         * 
         * @param serviceNow
         *        The operation to be performed on the provided ServiceNow source fields.
         * @see ServiceNowConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNowConnectorOperator
         */
        Builder serviceNow(ServiceNowConnectorOperator serviceNow);

        /**
         * <p>
         * The operation to be performed on the provided Zendesk source fields.
         * </p>
         * 
         * @param zendesk
         *        The operation to be performed on the provided Zendesk source fields.
         * @see ZendeskConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZendeskConnectorOperator
         */
        Builder zendesk(String zendesk);

        /**
         * <p>
         * The operation to be performed on the provided Zendesk source fields.
         * </p>
         * 
         * @param zendesk
         *        The operation to be performed on the provided Zendesk source fields.
         * @see ZendeskConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZendeskConnectorOperator
         */
        Builder zendesk(ZendeskConnectorOperator zendesk);
    }

    static final class BuilderImpl implements Builder {
        private String marketo;

        private String s3;

        private String salesforce;

        private String serviceNow;

        private String zendesk;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOperator model) {
            marketo(model.marketo);
            s3(model.s3);
            salesforce(model.salesforce);
            serviceNow(model.serviceNow);
            zendesk(model.zendesk);
        }

        public final String getMarketo() {
            return marketo;
        }

        public final void setMarketo(String marketo) {
            this.marketo = marketo;
        }

        @Override
        public final Builder marketo(String marketo) {
            this.marketo = marketo;
            return this;
        }

        @Override
        public final Builder marketo(MarketoConnectorOperator marketo) {
            this.marketo(marketo == null ? null : marketo.toString());
            return this;
        }

        public final String getS3() {
            return s3;
        }

        public final void setS3(String s3) {
            this.s3 = s3;
        }

        @Override
        public final Builder s3(String s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public final Builder s3(S3ConnectorOperator s3) {
            this.s3(s3 == null ? null : s3.toString());
            return this;
        }

        public final String getSalesforce() {
            return salesforce;
        }

        public final void setSalesforce(String salesforce) {
            this.salesforce = salesforce;
        }

        @Override
        public final Builder salesforce(String salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        @Override
        public final Builder salesforce(SalesforceConnectorOperator salesforce) {
            this.salesforce(salesforce == null ? null : salesforce.toString());
            return this;
        }

        public final String getServiceNow() {
            return serviceNow;
        }

        public final void setServiceNow(String serviceNow) {
            this.serviceNow = serviceNow;
        }

        @Override
        public final Builder serviceNow(String serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        @Override
        public final Builder serviceNow(ServiceNowConnectorOperator serviceNow) {
            this.serviceNow(serviceNow == null ? null : serviceNow.toString());
            return this;
        }

        public final String getZendesk() {
            return zendesk;
        }

        public final void setZendesk(String zendesk) {
            this.zendesk = zendesk;
        }

        @Override
        public final Builder zendesk(String zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        @Override
        public final Builder zendesk(ZendeskConnectorOperator zendesk) {
            this.zendesk(zendesk == null ? null : zendesk.toString());
            return this;
        }

        @Override
        public ConnectorOperator build() {
            return new ConnectorOperator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
