/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that defines users contact preference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactPreference.Builder, ContactPreference> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(ContactPreference::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyValue").getter(getter(ContactPreference::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValue").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(ContactPreference::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> CONTACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactType").getter(getter(ContactPreference::contactTypeAsString))
            .setter(setter(Builder::contactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD,
            KEY_VALUE_FIELD, PROFILE_ID_FIELD, CONTACT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyName;

    private final String keyValue;

    private final String profileId;

    private final String contactType;

    private ContactPreference(BuilderImpl builder) {
        this.keyName = builder.keyName;
        this.keyValue = builder.keyValue;
        this.profileId = builder.profileId;
        this.contactType = builder.contactType;
    }

    /**
     * <p>
     * A searchable, unique identifier of a customer profile.
     * </p>
     * 
     * @return A searchable, unique identifier of a customer profile.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The key value used to look up profile based off the keyName.
     * </p>
     * 
     * @return The key value used to look up profile based off the keyName.
     */
    public final String keyValue() {
        return keyValue;
    }

    /**
     * <p>
     * The unique identifier of a customer profile.
     * </p>
     * 
     * @return The unique identifier of a customer profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactType} will
     * return {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contactTypeAsString}.
     * </p>
     * 
     * @return The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
     * @see ContactType
     */
    public final ContactType contactType() {
        return ContactType.fromValue(contactType);
    }

    /**
     * <p>
     * The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactType} will
     * return {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contactTypeAsString}.
     * </p>
     * 
     * @return The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
     * @see ContactType
     */
    public final String contactTypeAsString() {
        return contactType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(contactTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactPreference)) {
            return false;
        }
        ContactPreference other = (ContactPreference) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(keyValue(), other.keyValue())
                && Objects.equals(profileId(), other.profileId())
                && Objects.equals(contactTypeAsString(), other.contactTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactPreference").add("KeyName", keyName()).add("KeyValue", keyValue())
                .add("ProfileId", profileId()).add("ContactType", contactTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "KeyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "ContactType":
            return Optional.ofNullable(clazz.cast(contactTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("KeyValue", KEY_VALUE_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("ContactType", CONTACT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactPreference, T> g) {
        return obj -> g.apply((ContactPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactPreference> {
        /**
         * <p>
         * A searchable, unique identifier of a customer profile.
         * </p>
         * 
         * @param keyName
         *        A searchable, unique identifier of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The key value used to look up profile based off the keyName.
         * </p>
         * 
         * @param keyValue
         *        The key value used to look up profile based off the keyName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);

        /**
         * <p>
         * The unique identifier of a customer profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
         * </p>
         * 
         * @param contactType
         *        The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder contactType(String contactType);

        /**
         * <p>
         * The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
         * </p>
         * 
         * @param contactType
         *        The contact type used for engagement. For example: HomePhoneNumber, PersonalEmailAddress.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder contactType(ContactType contactType);
    }

    static final class BuilderImpl implements Builder {
        private String keyName;

        private String keyValue;

        private String profileId;

        private String contactType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactPreference model) {
            keyName(model.keyName);
            keyValue(model.keyValue);
            profileId(model.profileId);
            contactType(model.contactType);
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getContactType() {
            return contactType;
        }

        public final void setContactType(String contactType) {
            this.contactType = contactType;
        }

        @Override
        public final Builder contactType(String contactType) {
            this.contactType = contactType;
            return this;
        }

        @Override
        public final Builder contactType(ContactType contactType) {
            this.contactType(contactType == null ? null : contactType.toString());
            return this;
        }

        @Override
        public ContactPreference build() {
            return new ContactPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
