/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<CreateDomainRequest.Builder, CreateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<Integer> DEFAULT_EXPIRATION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultExpirationDays").getter(getter(CreateDomainRequest::defaultExpirationDays))
            .setter(setter(Builder::defaultExpirationDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExpirationDays").build())
            .build();

    private static final SdkField<String> DEFAULT_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultEncryptionKey").getter(getter(CreateDomainRequest::defaultEncryptionKey))
            .setter(setter(Builder::defaultEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEncryptionKey").build())
            .build();

    private static final SdkField<String> DEAD_LETTER_QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeadLetterQueueUrl").getter(getter(CreateDomainRequest::deadLetterQueueUrl))
            .setter(setter(Builder::deadLetterQueueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterQueueUrl").build())
            .build();

    private static final SdkField<MatchingRequest> MATCHING_FIELD = SdkField.<MatchingRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Matching").getter(getter(CreateDomainRequest::matching)).setter(setter(Builder::matching))
            .constructor(MatchingRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matching").build()).build();

    private static final SdkField<RuleBasedMatchingRequest> RULE_BASED_MATCHING_FIELD = SdkField
            .<RuleBasedMatchingRequest> builder(MarshallingType.SDK_POJO).memberName("RuleBasedMatching")
            .getter(getter(CreateDomainRequest::ruleBasedMatching)).setter(setter(Builder::ruleBasedMatching))
            .constructor(RuleBasedMatchingRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleBasedMatching").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDomainRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DEFAULT_EXPIRATION_DAYS_FIELD, DEFAULT_ENCRYPTION_KEY_FIELD, DEAD_LETTER_QUEUE_URL_FIELD, MATCHING_FIELD,
            RULE_BASED_MATCHING_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final Integer defaultExpirationDays;

    private final String defaultEncryptionKey;

    private final String deadLetterQueueUrl;

    private final MatchingRequest matching;

    private final RuleBasedMatchingRequest ruleBasedMatching;

    private final Map<String, String> tags;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.defaultExpirationDays = builder.defaultExpirationDays;
        this.defaultEncryptionKey = builder.defaultEncryptionKey;
        this.deadLetterQueueUrl = builder.deadLetterQueueUrl;
        this.matching = builder.matching;
        this.ruleBasedMatching = builder.ruleBasedMatching;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The default number of days until the data within the domain expires.
     * </p>
     * 
     * @return The default number of days until the data within the domain expires.
     */
    public final Integer defaultExpirationDays() {
        return defaultExpirationDays;
    }

    /**
     * <p>
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is
     * specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     * </p>
     * 
     * @return The default encryption key, which is an AWS managed key, is used when no specific type of encryption key
     *         is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     */
    public final String defaultEncryptionKey() {
        return defaultEncryptionKey;
    }

    /**
     * <p>
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from
     * third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable
     * Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
     * </p>
     * 
     * @return The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data
     *         from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage
     *         operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
     */
    public final String deadLetterQueueUrl() {
        return deadLetterQueueUrl;
    }

    /**
     * <p>
     * The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer
     * Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for
     * Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in
     * your domains.
     * </p>
     * <p>
     * After the Identity Resolution Job completes, use the <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to
     * return and review the results. Or, if you have configured <code>ExportingConfig</code> in the
     * <code>MatchingRequest</code>, you can download the results from S3.
     * </p>
     * 
     * @return The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect
     *         Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a
     *         date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect
     *         duplicate profiles in your domains. </p>
     *         <p>
     *         After the Identity Resolution Job completes, use the <a
     *         href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html"
     *         >GetMatches</a> API to return and review the results. Or, if you have configured
     *         <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.
     */
    public final MatchingRequest matching() {
        return matching;
    }

    /**
     * <p>
     * The process of matching duplicate profiles using the Rule-Based matching. If <code>RuleBasedMatching</code> =
     * true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your
     * configuration in the <code>RuleBasedMatchingRequest</code>. You can use the <code>ListRuleBasedMatches</code> and
     * <code>GetSimilarProfiles</code> API to return and review the results. Also, if you have configured
     * <code>ExportingConfig</code> in the <code>RuleBasedMatchingRequest</code>, you can download the results from S3.
     * </p>
     * 
     * @return The process of matching duplicate profiles using the Rule-Based matching. If
     *         <code>RuleBasedMatching</code> = true, Amazon Connect Customer Profiles will start to match and merge
     *         your profiles according to your configuration in the <code>RuleBasedMatchingRequest</code>. You can use
     *         the <code>ListRuleBasedMatches</code> and <code>GetSimilarProfiles</code> API to return and review the
     *         results. Also, if you have configured <code>ExportingConfig</code> in the
     *         <code>RuleBasedMatchingRequest</code>, you can download the results from S3.
     */
    public final RuleBasedMatchingRequest ruleBasedMatching() {
        return ruleBasedMatching;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultExpirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterQueueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(matching());
        hashCode = 31 * hashCode + Objects.hashCode(ruleBasedMatching());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(defaultExpirationDays(), other.defaultExpirationDays())
                && Objects.equals(defaultEncryptionKey(), other.defaultEncryptionKey())
                && Objects.equals(deadLetterQueueUrl(), other.deadLetterQueueUrl())
                && Objects.equals(matching(), other.matching()) && Objects.equals(ruleBasedMatching(), other.ruleBasedMatching())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDomainRequest").add("DomainName", domainName())
                .add("DefaultExpirationDays", defaultExpirationDays()).add("DefaultEncryptionKey", defaultEncryptionKey())
                .add("DeadLetterQueueUrl", deadLetterQueueUrl()).add("Matching", matching())
                .add("RuleBasedMatching", ruleBasedMatching()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DefaultExpirationDays":
            return Optional.ofNullable(clazz.cast(defaultExpirationDays()));
        case "DefaultEncryptionKey":
            return Optional.ofNullable(clazz.cast(defaultEncryptionKey()));
        case "DeadLetterQueueUrl":
            return Optional.ofNullable(clazz.cast(deadLetterQueueUrl()));
        case "Matching":
            return Optional.ofNullable(clazz.cast(matching()));
        case "RuleBasedMatching":
            return Optional.ofNullable(clazz.cast(ruleBasedMatching()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("DefaultExpirationDays", DEFAULT_EXPIRATION_DAYS_FIELD);
        map.put("DefaultEncryptionKey", DEFAULT_ENCRYPTION_KEY_FIELD);
        map.put("DeadLetterQueueUrl", DEAD_LETTER_QUEUE_URL_FIELD);
        map.put("Matching", MATCHING_FIELD);
        map.put("RuleBasedMatching", RULE_BASED_MATCHING_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The default number of days until the data within the domain expires.
         * </p>
         * 
         * @param defaultExpirationDays
         *        The default number of days until the data within the domain expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExpirationDays(Integer defaultExpirationDays);

        /**
         * <p>
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is
         * specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
         * </p>
         * 
         * @param defaultEncryptionKey
         *        The default encryption key, which is an AWS managed key, is used when no specific type of encryption
         *        key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEncryptionKey(String defaultEncryptionKey);

        /**
         * <p>
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from
         * third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to
         * enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
         * </p>
         * 
         * @param deadLetterQueueUrl
         *        The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting
         *        data from third party applications. You must set up a policy on the DeadLetterQueue for the
         *        SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the
         *        DeadLetterQueue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterQueueUrl(String deadLetterQueueUrl);

        /**
         * <p>
         * The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect
         * Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date
         * and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect
         * duplicate profiles in your domains.
         * </p>
         * <p>
         * After the Identity Resolution Job completes, use the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
         * API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the
         * <code>MatchingRequest</code>, you can download the results from S3.
         * </p>
         * 
         * @param matching
         *        The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon
         *        Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not
         *        specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM
         *        UTC to detect duplicate profiles in your domains. </p>
         *        <p>
         *        After the Identity Resolution Job completes, use the <a
         *        href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html"
         *        >GetMatches</a> API to return and review the results. Or, if you have configured
         *        <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from
         *        S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matching(MatchingRequest matching);

        /**
         * <p>
         * The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect
         * Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date
         * and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect
         * duplicate profiles in your domains.
         * </p>
         * <p>
         * After the Identity Resolution Job completes, use the <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
         * API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the
         * <code>MatchingRequest</code>, you can download the results from S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchingRequest.Builder} avoiding the
         * need to create one manually via {@link MatchingRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchingRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #matching(MatchingRequest)}.
         * 
         * @param matching
         *        a consumer that will call methods on {@link MatchingRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matching(MatchingRequest)
         */
        default Builder matching(Consumer<MatchingRequest.Builder> matching) {
            return matching(MatchingRequest.builder().applyMutation(matching).build());
        }

        /**
         * <p>
         * The process of matching duplicate profiles using the Rule-Based matching. If <code>RuleBasedMatching</code> =
         * true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your
         * configuration in the <code>RuleBasedMatchingRequest</code>. You can use the <code>ListRuleBasedMatches</code>
         * and <code>GetSimilarProfiles</code> API to return and review the results. Also, if you have configured
         * <code>ExportingConfig</code> in the <code>RuleBasedMatchingRequest</code>, you can download the results from
         * S3.
         * </p>
         * 
         * @param ruleBasedMatching
         *        The process of matching duplicate profiles using the Rule-Based matching. If
         *        <code>RuleBasedMatching</code> = true, Amazon Connect Customer Profiles will start to match and merge
         *        your profiles according to your configuration in the <code>RuleBasedMatchingRequest</code>. You can
         *        use the <code>ListRuleBasedMatches</code> and <code>GetSimilarProfiles</code> API to return and review
         *        the results. Also, if you have configured <code>ExportingConfig</code> in the
         *        <code>RuleBasedMatchingRequest</code>, you can download the results from S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleBasedMatching(RuleBasedMatchingRequest ruleBasedMatching);

        /**
         * <p>
         * The process of matching duplicate profiles using the Rule-Based matching. If <code>RuleBasedMatching</code> =
         * true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your
         * configuration in the <code>RuleBasedMatchingRequest</code>. You can use the <code>ListRuleBasedMatches</code>
         * and <code>GetSimilarProfiles</code> API to return and review the results. Also, if you have configured
         * <code>ExportingConfig</code> in the <code>RuleBasedMatchingRequest</code>, you can download the results from
         * S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleBasedMatchingRequest.Builder}
         * avoiding the need to create one manually via {@link RuleBasedMatchingRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleBasedMatchingRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleBasedMatching(RuleBasedMatchingRequest)}.
         * 
         * @param ruleBasedMatching
         *        a consumer that will call methods on {@link RuleBasedMatchingRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleBasedMatching(RuleBasedMatchingRequest)
         */
        default Builder ruleBasedMatching(Consumer<RuleBasedMatchingRequest.Builder> ruleBasedMatching) {
            return ruleBasedMatching(RuleBasedMatchingRequest.builder().applyMutation(ruleBasedMatching).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private Integer defaultExpirationDays;

        private String defaultEncryptionKey;

        private String deadLetterQueueUrl;

        private MatchingRequest matching;

        private RuleBasedMatchingRequest ruleBasedMatching;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            domainName(model.domainName);
            defaultExpirationDays(model.defaultExpirationDays);
            defaultEncryptionKey(model.defaultEncryptionKey);
            deadLetterQueueUrl(model.deadLetterQueueUrl);
            matching(model.matching);
            ruleBasedMatching(model.ruleBasedMatching);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getDefaultExpirationDays() {
            return defaultExpirationDays;
        }

        public final void setDefaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
        }

        @Override
        public final Builder defaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
            return this;
        }

        public final String getDefaultEncryptionKey() {
            return defaultEncryptionKey;
        }

        public final void setDefaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
        }

        @Override
        public final Builder defaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
            return this;
        }

        public final String getDeadLetterQueueUrl() {
            return deadLetterQueueUrl;
        }

        public final void setDeadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
        }

        @Override
        public final Builder deadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
            return this;
        }

        public final MatchingRequest.Builder getMatching() {
            return matching != null ? matching.toBuilder() : null;
        }

        public final void setMatching(MatchingRequest.BuilderImpl matching) {
            this.matching = matching != null ? matching.build() : null;
        }

        @Override
        public final Builder matching(MatchingRequest matching) {
            this.matching = matching;
            return this;
        }

        public final RuleBasedMatchingRequest.Builder getRuleBasedMatching() {
            return ruleBasedMatching != null ? ruleBasedMatching.toBuilder() : null;
        }

        public final void setRuleBasedMatching(RuleBasedMatchingRequest.BuilderImpl ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching != null ? ruleBasedMatching.build() : null;
        }

        @Override
        public final Builder ruleBasedMatching(RuleBasedMatchingRequest ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
