/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSegmentDefinitionResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<CreateSegmentDefinitionResponse.Builder, CreateSegmentDefinitionResponse> {
    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentDefinitionName").getter(getter(CreateSegmentDefinitionResponse::segmentDefinitionName))
            .setter(setter(Builder::segmentDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateSegmentDefinitionResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateSegmentDefinitionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(CreateSegmentDefinitionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> SEGMENT_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentDefinitionArn").getter(getter(CreateSegmentDefinitionResponse::segmentDefinitionArn))
            .setter(setter(Builder::segmentDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionArn").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSegmentDefinitionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_DEFINITION_NAME_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, SEGMENT_DEFINITION_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String segmentDefinitionName;

    private final String displayName;

    private final String description;

    private final Instant createdAt;

    private final String segmentDefinitionArn;

    private final Map<String, String> tags;

    private CreateSegmentDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.segmentDefinitionArn = builder.segmentDefinitionArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the segment definition.
     * </p>
     * 
     * @return The name of the segment definition.
     */
    public final String segmentDefinitionName() {
        return segmentDefinitionName;
    }

    /**
     * <p>
     * The display name of the segment definition.
     * </p>
     * 
     * @return The display name of the segment definition.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the segment definition.
     * </p>
     * 
     * @return The description of the segment definition.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp of when the segment definition was created.
     * </p>
     * 
     * @return The timestamp of when the segment definition was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The arn of the segment definition.
     * </p>
     * 
     * @return The arn of the segment definition.
     */
    public final String segmentDefinitionArn() {
        return segmentDefinitionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentDefinitionResponse)) {
            return false;
        }
        CreateSegmentDefinitionResponse other = (CreateSegmentDefinitionResponse) obj;
        return Objects.equals(segmentDefinitionName(), other.segmentDefinitionName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(segmentDefinitionArn(), other.segmentDefinitionArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSegmentDefinitionResponse").add("SegmentDefinitionName", segmentDefinitionName())
                .add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedAt", createdAt()).add("SegmentDefinitionArn", segmentDefinitionArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentDefinitionName":
            return Optional.ofNullable(clazz.cast(segmentDefinitionName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "SegmentDefinitionArn":
            return Optional.ofNullable(clazz.cast(segmentDefinitionArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("SegmentDefinitionArn", SEGMENT_DEFINITION_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSegmentDefinitionResponse, T> g) {
        return obj -> g.apply((CreateSegmentDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSegmentDefinitionResponse> {
        /**
         * <p>
         * The name of the segment definition.
         * </p>
         * 
         * @param segmentDefinitionName
         *        The name of the segment definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDefinitionName(String segmentDefinitionName);

        /**
         * <p>
         * The display name of the segment definition.
         * </p>
         * 
         * @param displayName
         *        The display name of the segment definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the segment definition.
         * </p>
         * 
         * @param description
         *        The description of the segment definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp of when the segment definition was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the segment definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The arn of the segment definition.
         * </p>
         * 
         * @param segmentDefinitionArn
         *        The arn of the segment definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDefinitionArn(String segmentDefinitionArn);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String segmentDefinitionName;

        private String displayName;

        private String description;

        private Instant createdAt;

        private String segmentDefinitionArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentDefinitionResponse model) {
            super(model);
            segmentDefinitionName(model.segmentDefinitionName);
            displayName(model.displayName);
            description(model.description);
            createdAt(model.createdAt);
            segmentDefinitionArn(model.segmentDefinitionArn);
            tags(model.tags);
        }

        public final String getSegmentDefinitionName() {
            return segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getSegmentDefinitionArn() {
            return segmentDefinitionArn;
        }

        public final void setSegmentDefinitionArn(String segmentDefinitionArn) {
            this.segmentDefinitionArn = segmentDefinitionArn;
        }

        @Override
        public final Builder segmentDefinitionArn(String segmentDefinitionArn) {
            this.segmentDefinitionArn = segmentDefinitionArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateSegmentDefinitionResponse build() {
            return new CreateSegmentDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
