/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSegmentEstimateRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<CreateSegmentEstimateRequest.Builder, CreateSegmentEstimateRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateSegmentEstimateRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<SegmentGroupStructure> SEGMENT_QUERY_FIELD = SdkField
            .<SegmentGroupStructure> builder(MarshallingType.SDK_POJO).memberName("SegmentQuery")
            .getter(getter(CreateSegmentEstimateRequest::segmentQuery)).setter(setter(Builder::segmentQuery))
            .constructor(SegmentGroupStructure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SEGMENT_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final SegmentGroupStructure segmentQuery;

    private CreateSegmentEstimateRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.segmentQuery = builder.segmentQuery;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The segment query for calculating a segment estimate.
     * </p>
     * 
     * @return The segment query for calculating a segment estimate.
     */
    public final SegmentGroupStructure segmentQuery() {
        return segmentQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(segmentQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentEstimateRequest)) {
            return false;
        }
        CreateSegmentEstimateRequest other = (CreateSegmentEstimateRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(segmentQuery(), other.segmentQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSegmentEstimateRequest").add("DomainName", domainName())
                .add("SegmentQuery", segmentQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "SegmentQuery":
            return Optional.ofNullable(clazz.cast(segmentQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("SegmentQuery", SEGMENT_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSegmentEstimateRequest, T> g) {
        return obj -> g.apply((CreateSegmentEstimateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSegmentEstimateRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The segment query for calculating a segment estimate.
         * </p>
         * 
         * @param segmentQuery
         *        The segment query for calculating a segment estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentQuery(SegmentGroupStructure segmentQuery);

        /**
         * <p>
         * The segment query for calculating a segment estimate.
         * </p>
         * This is a convenience method that creates an instance of the {@link SegmentGroupStructure.Builder} avoiding
         * the need to create one manually via {@link SegmentGroupStructure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SegmentGroupStructure.Builder#build()} is called immediately and
         * its result is passed to {@link #segmentQuery(SegmentGroupStructure)}.
         * 
         * @param segmentQuery
         *        a consumer that will call methods on {@link SegmentGroupStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentQuery(SegmentGroupStructure)
         */
        default Builder segmentQuery(Consumer<SegmentGroupStructure.Builder> segmentQuery) {
            return segmentQuery(SegmentGroupStructure.builder().applyMutation(segmentQuery).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private SegmentGroupStructure segmentQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentEstimateRequest model) {
            super(model);
            domainName(model.domainName);
            segmentQuery(model.segmentQuery);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final SegmentGroupStructure.Builder getSegmentQuery() {
            return segmentQuery != null ? segmentQuery.toBuilder() : null;
        }

        public final void setSegmentQuery(SegmentGroupStructure.BuilderImpl segmentQuery) {
            this.segmentQuery = segmentQuery != null ? segmentQuery.build() : null;
        }

        @Override
        public final Builder segmentQuery(SegmentGroupStructure segmentQuery) {
            this.segmentQuery = segmentQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSegmentEstimateRequest build() {
            return new CreateSegmentEstimateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
