/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSegmentEstimateResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<CreateSegmentEstimateResponse.Builder, CreateSegmentEstimateResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateSegmentEstimateResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ESTIMATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimateId").getter(getter(CreateSegmentEstimateResponse::estimateId))
            .setter(setter(Builder::estimateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimateId").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(CreateSegmentEstimateResponse::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ESTIMATE_ID_FIELD, STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String estimateId;

    private final Integer statusCode;

    private CreateSegmentEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.estimateId = builder.estimateId;
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A unique identifier for the resource. The value can be passed to <code>GetSegmentEstimate</code> to retrieve the
     * result of segment estimate status.
     * </p>
     * 
     * @return A unique identifier for the resource. The value can be passed to <code>GetSegmentEstimate</code> to
     *         retrieve the result of segment estimate status.
     */
    public final String estimateId() {
        return estimateId;
    }

    /**
     * <p>
     * The status code for the response.
     * </p>
     * 
     * @return The status code for the response.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(estimateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentEstimateResponse)) {
            return false;
        }
        CreateSegmentEstimateResponse other = (CreateSegmentEstimateResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(estimateId(), other.estimateId())
                && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSegmentEstimateResponse").add("DomainName", domainName()).add("EstimateId", estimateId())
                .add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EstimateId":
            return Optional.ofNullable(clazz.cast(estimateId()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EstimateId", ESTIMATE_ID_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSegmentEstimateResponse, T> g) {
        return obj -> g.apply((CreateSegmentEstimateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSegmentEstimateResponse> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A unique identifier for the resource. The value can be passed to <code>GetSegmentEstimate</code> to retrieve
         * the result of segment estimate status.
         * </p>
         * 
         * @param estimateId
         *        A unique identifier for the resource. The value can be passed to <code>GetSegmentEstimate</code> to
         *        retrieve the result of segment estimate status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimateId(String estimateId);

        /**
         * <p>
         * The status code for the response.
         * </p>
         * 
         * @param statusCode
         *        The status code for the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String domainName;

        private String estimateId;

        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentEstimateResponse model) {
            super(model);
            domainName(model.domainName);
            estimateId(model.estimateId);
            statusCode(model.statusCode);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEstimateId() {
            return estimateId;
        }

        public final void setEstimateId(String estimateId) {
            this.estimateId = estimateId;
        }

        @Override
        public final Builder estimateId(String estimateId) {
            this.estimateId = estimateId;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public CreateSegmentEstimateResponse build() {
            return new CreateSegmentEstimateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
