/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSegmentSnapshotRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<CreateSegmentSnapshotRequest.Builder, CreateSegmentSnapshotRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateSegmentSnapshotRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentDefinitionName").getter(getter(CreateSegmentSnapshotRequest::segmentDefinitionName))
            .setter(setter(Builder::segmentDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SegmentDefinitionName").build())
            .build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(CreateSegmentSnapshotRequest::dataFormatAsString))
            .setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKey").getter(getter(CreateSegmentSnapshotRequest::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateSegmentSnapshotRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESTINATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationUri").getter(getter(CreateSegmentSnapshotRequest::destinationUri))
            .setter(setter(Builder::destinationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SEGMENT_DEFINITION_NAME_FIELD, DATA_FORMAT_FIELD, ENCRYPTION_KEY_FIELD, ROLE_ARN_FIELD, DESTINATION_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String segmentDefinitionName;

    private final String dataFormat;

    private final String encryptionKey;

    private final String roleArn;

    private final String destinationUri;

    private CreateSegmentSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.dataFormat = builder.dataFormat;
        this.encryptionKey = builder.encryptionKey;
        this.roleArn = builder.roleArn;
        this.destinationUri = builder.destinationUri;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the segment definition used in this snapshot request.
     * </p>
     * 
     * @return The name of the segment definition used in this snapshot request.
     */
    public final String segmentDefinitionName() {
        return segmentDefinitionName;
    }

    /**
     * <p>
     * The format in which the segment will be exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format in which the segment will be exported.
     * @see DataFormat
     */
    public final DataFormat dataFormat() {
        return DataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The format in which the segment will be exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format in which the segment will be exported.
     * @see DataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume the role
     * for conducting KMS and S3 operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume
     *         the role for conducting KMS and S3 operations.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The destination to which the segment will be exported. This field must be provided if the request is not
     * submitted from the Amazon Connect Admin Website.
     * </p>
     * 
     * @return The destination to which the segment will be exported. This field must be provided if the request is not
     *         submitted from the Amazon Connect Admin Website.
     */
    public final String destinationUri() {
        return destinationUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentSnapshotRequest)) {
            return false;
        }
        CreateSegmentSnapshotRequest other = (CreateSegmentSnapshotRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(segmentDefinitionName(), other.segmentDefinitionName())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(destinationUri(), other.destinationUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSegmentSnapshotRequest").add("DomainName", domainName())
                .add("SegmentDefinitionName", segmentDefinitionName()).add("DataFormat", dataFormatAsString())
                .add("EncryptionKey", encryptionKey()).add("RoleArn", roleArn()).add("DestinationUri", destinationUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "SegmentDefinitionName":
            return Optional.ofNullable(clazz.cast(segmentDefinitionName()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DestinationUri":
            return Optional.ofNullable(clazz.cast(destinationUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
        map.put("DataFormat", DATA_FORMAT_FIELD);
        map.put("EncryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("DestinationUri", DESTINATION_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSegmentSnapshotRequest, T> g) {
        return obj -> g.apply((CreateSegmentSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSegmentSnapshotRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the segment definition used in this snapshot request.
         * </p>
         * 
         * @param segmentDefinitionName
         *        The name of the segment definition used in this snapshot request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDefinitionName(String segmentDefinitionName);

        /**
         * <p>
         * The format in which the segment will be exported.
         * </p>
         * 
         * @param dataFormat
         *        The format in which the segment will be exported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The format in which the segment will be exported.
         * </p>
         * 
         * @param dataFormat
         *        The format in which the segment will be exported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(DataFormat dataFormat);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
         * </p>
         * 
         * @param encryptionKey
         *        The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume the
         * role for conducting KMS and S3 operations.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to
         *        assume the role for conducting KMS and S3 operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The destination to which the segment will be exported. This field must be provided if the request is not
         * submitted from the Amazon Connect Admin Website.
         * </p>
         * 
         * @param destinationUri
         *        The destination to which the segment will be exported. This field must be provided if the request is
         *        not submitted from the Amazon Connect Admin Website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationUri(String destinationUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String segmentDefinitionName;

        private String dataFormat;

        private String encryptionKey;

        private String roleArn;

        private String destinationUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentSnapshotRequest model) {
            super(model);
            domainName(model.domainName);
            segmentDefinitionName(model.segmentDefinitionName);
            dataFormat(model.dataFormat);
            encryptionKey(model.encryptionKey);
            roleArn(model.roleArn);
            destinationUri(model.destinationUri);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getSegmentDefinitionName() {
            return segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDestinationUri() {
            return destinationUri;
        }

        public final void setDestinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
        }

        @Override
        public final Builder destinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSegmentSnapshotRequest build() {
            return new CreateSegmentSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
