/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUploadJobRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<CreateUploadJobRequest.Builder, CreateUploadJobRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateUploadJobRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateUploadJobRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField
            .<Map<String, ObjectTypeField>> builder(MarshallingType.MAP)
            .memberName("Fields")
            .getter(getter(CreateUploadJobRequest::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ObjectTypeField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectTypeField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UNIQUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UniqueKey").getter(getter(CreateUploadJobRequest::uniqueKey)).setter(setter(Builder::uniqueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueKey").build()).build();

    private static final SdkField<Integer> DATA_EXPIRY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataExpiry").getter(getter(CreateUploadJobRequest::dataExpiry)).setter(setter(Builder::dataExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExpiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DISPLAY_NAME_FIELD, FIELDS_FIELD, UNIQUE_KEY_FIELD, DATA_EXPIRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String displayName;

    private final Map<String, ObjectTypeField> fields;

    private final String uniqueKey;

    private final Integer dataExpiry;

    private CreateUploadJobRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.displayName = builder.displayName;
        this.fields = builder.fields;
        this.uniqueKey = builder.uniqueKey;
        this.dataExpiry = builder.dataExpiry;
    }

    /**
     * <p>
     * The unique name of the domain. Domain should be exists for the upload job to be created.
     * </p>
     * 
     * @return The unique name of the domain. Domain should be exists for the upload job to be created.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique name of the upload job. Could be a file name to identify the upload job.
     * </p>
     * 
     * @return The unique name of the upload job. Could be a file name to identify the upload job.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The mapping between CSV Columns and Profile Object attributes. A map of the name and ObjectType field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The mapping between CSV Columns and Profile Object attributes. A map of the name and ObjectType field.
     */
    public final Map<String, ObjectTypeField> fields() {
        return fields;
    }

    /**
     * <p>
     * The unique key columns for de-duping the profiles used to map data to the profile.
     * </p>
     * 
     * @return The unique key columns for de-duping the profiles used to map data to the profile.
     */
    public final String uniqueKey() {
        return uniqueKey;
    }

    /**
     * <p>
     * The expiry duration for the profiles ingested with the job. If not provided, the system default of 2 weeks is
     * used.
     * </p>
     * 
     * @return The expiry duration for the profiles ingested with the job. If not provided, the system default of 2
     *         weeks is used.
     */
    public final Integer dataExpiry() {
        return dataExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(dataExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadJobRequest)) {
            return false;
        }
        CreateUploadJobRequest other = (CreateUploadJobRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(displayName(), other.displayName())
                && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(uniqueKey(), other.uniqueKey()) && Objects.equals(dataExpiry(), other.dataExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUploadJobRequest").add("DomainName", domainName()).add("DisplayName", displayName())
                .add("Fields", fields() == null ? null : "*** Sensitive Data Redacted ***").add("UniqueKey", uniqueKey())
                .add("DataExpiry", dataExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "UniqueKey":
            return Optional.ofNullable(clazz.cast(uniqueKey()));
        case "DataExpiry":
            return Optional.ofNullable(clazz.cast(dataExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Fields", FIELDS_FIELD);
        map.put("UniqueKey", UNIQUE_KEY_FIELD);
        map.put("DataExpiry", DATA_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUploadJobRequest, T> g) {
        return obj -> g.apply((CreateUploadJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUploadJobRequest> {
        /**
         * <p>
         * The unique name of the domain. Domain should be exists for the upload job to be created.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain. Domain should be exists for the upload job to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique name of the upload job. Could be a file name to identify the upload job.
         * </p>
         * 
         * @param displayName
         *        The unique name of the upload job. Could be a file name to identify the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The mapping between CSV Columns and Profile Object attributes. A map of the name and ObjectType field.
         * </p>
         * 
         * @param fields
         *        The mapping between CSV Columns and Profile Object attributes. A map of the name and ObjectType field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ObjectTypeField> fields);

        /**
         * <p>
         * The unique key columns for de-duping the profiles used to map data to the profile.
         * </p>
         * 
         * @param uniqueKey
         *        The unique key columns for de-duping the profiles used to map data to the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueKey(String uniqueKey);

        /**
         * <p>
         * The expiry duration for the profiles ingested with the job. If not provided, the system default of 2 weeks is
         * used.
         * </p>
         * 
         * @param dataExpiry
         *        The expiry duration for the profiles ingested with the job. If not provided, the system default of 2
         *        weeks is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExpiry(Integer dataExpiry);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String displayName;

        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();

        private String uniqueKey;

        private Integer dataExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadJobRequest model) {
            super(model);
            domainName(model.domainName);
            displayName(model.displayName);
            fields(model.fields);
            uniqueKey(model.uniqueKey);
            dataExpiry(model.dataExpiry);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            Map<String, ObjectTypeField.Builder> result = FieldMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final String getUniqueKey() {
            return uniqueKey;
        }

        public final void setUniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
        }

        @Override
        public final Builder uniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
            return this;
        }

        public final Integer getDataExpiry() {
            return dataExpiry;
        }

        public final void setDataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
        }

        @Override
        public final Builder dataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUploadJobRequest build() {
            return new CreateUploadJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
